<?php
include_once 'lib/init.php';

$config = array(
	'title' => 'Cards',
	'body_class' => $GLOBALS['body_class'] . ''
);

get_header($config);
?>

<div class="content-wrapper">
	<?php get_template_part( $GLOBALS['sidebar_file'] ) ?>

	<main class="main-wrapper clearfix">

		<?php get_page_title($config); ?>

		<!-- =================================== -->
		<!-- Different data widgets ============ -->
		<!-- =================================== -->
		<div class="widget-list">
			<div class="row">

				<!-- Card with Image -->
				<div class="col-md-12 widget-holder">
					<div class="widget-bg-transparent">
			      <div class="widget-body">

							<h5 class="box-title">Cards with Images</h5>

							<div class="row">
	              <div class="col-md-4 mr-b-30">
	                <div class="card blog-post-new">
										<div class="card-header sub-heading-font-family border-bottom-0 p-0">
											<figure>
												<a href="javascript:void(0);">
													<img class="card-img-top" src="assets/demo/cards/blog-post-new-1.jpeg" alt="" />
												</a>
											</figure>
											<span class="badge badge-danger text-uppercase">Maldives</span>
											<figure class="user-image thumb-sm">
												<a href="javascript:void(0);">
													<img src="assets/demo/users/user6.jpg" class="rounded-circle" alt="">
												</a>
											</figure>
										</div>

										<div class="card-body sub-heading-font-family">
	                    <h5 class="card-title sub-heading-font-family mb-3">Dive In: Maldives</h5>
	                    <p class="card-text text-muted">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
	                  </div>

										<div class="card-action d-flex border-0">
	                    <a href="#" class="card-link fw-300 mr-auto mr-0-rtl ml-auto-rtl">July 16, 2015</a>
	                    <a href="#" class="card-link text-uppercase">
	                    	<i class="material-icons list-icon text-muted px-2">share</i>
												<i class="material-icons list-icon text-muted px-2">favorite_border</i>
	                    </a>
	                  </div>
	                </div>
	              </div>

								<div class="col-md-4 mr-b-30">
	                <div class="card blog-post-new">
										<div class="card-header sub-heading-font-family border-bottom-0 p-0">
											<figure>
												<a href="javascript:void(0);">
													<img class="card-img-top" src="assets/demo/cards/blog-post-new-2.jpeg" alt="" />
												</a>
											</figure>
											<span class="badge badge-danger text-uppercase">Brazil</span>
											<figure class="user-image thumb-sm">
												<a href="javascript:void(0);">
													<img src="assets/demo/users/user2.jpg" class="rounded-circle" alt="">
												</a>
											</figure>
										</div>

										<div class="card-body sub-heading-font-family">
	                    <h5 class="card-title sub-heading-font-family mb-3">Plan a Trip: Brazil</h5>
	                    <p class="card-text text-muted">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
	                  </div>

										<div class="card-action d-flex border-0">
	                    <a href="#" class="card-link fw-300 mr-auto mr-0-rtl ml-auto-rtl">December 05, 2016</a>
	                    <a href="#" class="card-link text-uppercase">
	                    	<i class="material-icons list-icon text-muted px-2">share</i>
												<i class="material-icons list-icon text-muted px-2">favorite_border</i>
	                    </a>
	                  </div>
	                </div>
	              </div>

								<div class="col-md-4 mr-b-30">
	                <div class="card blog-post-new">
										<div class="card-header sub-heading-font-family border-bottom-0 p-0">
											<figure>
												<a href="javascript:void(0);">
													<img class="card-img-top" src="assets/demo/cards/blog-post-new-3.jpeg" alt="" />
												</a>
											</figure>
											<span class="badge badge-danger text-uppercase">London</span>
											<figure class="user-image thumb-sm">
												<a href="javascript:void(0);">
													<img src="assets/demo/users/user4.jpg" class="rounded-circle" alt="">
												</a>
											</figure>
										</div>

										<div class="card-body sub-heading-font-family">
	                    <h5 class="card-title sub-heading-font-family  mb-3">The Freedom: London</h5>
	                    <p class="card-text text-muted">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
	                  </div>

										<div class="card-action d-flex border-0">
	                    <a href="#" class="card-link fw-300 mr-auto mr-0-rtl ml-auto-rtl">January 25, 2017</a>
	                    <a href="#" class="card-link text-uppercase">
	                    	<i class="material-icons list-icon text-muted px-2">share</i>
												<i class="material-icons list-icon text-muted px-2">favorite_border</i>
	                    </a>
	                  </div>
	                </div>
	              </div>
	            </div>

			      </div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->				

				<!-- Blog Posts -->
        <div class="col-md-12 widget-holder">
          <div class="widget-bg-transparent">
            <div class="widget-body">

							<h5 class="box-title">Blog Posts</h5>

              <div class="row">
                <div class="col-md-4 mr-b-30 d-flex">
                  <div class="blog-post blog-post-card text-center">
                    <figure>
                      <a href="#">
                        <img src="assets/demo/cards/blog-post-1.jpg" alt="Blog Post 1" />
                      </a>
                    </figure>

                    <header>
                      <ul class="blog-post-share-links list-unstyled list-inline">
                        <li class="list-inline-item"><a href="javascript:void(0)" class="bg-primary ripple toggle-link"><i class="list-icon social-icons">sharethis</i></a></li>
                        <li class="list-inline-item"><a href="javascript:void(0)" class="bg-facebook ripple"><i class="list-icon social-icons">facebook</i></a></li>
                        <li class="list-inline-item"><a href="javascript:void(0)" class="bg-twitter ripple"><i class="list-icon social-icons">twitter</i></a></li>
                        <li class="list-inline-item"><a href="javascript:void(0)" class="bg-dribbble ripple"><i class="list-icon social-icons">dribble</i></a></li>
                      </ul>
                      <div class="block text-muted blog-post-tags">Posted in
                        <ul class="ml-1 inline-block list-unstyled list-inline">
                          <li class="list-inline-item"><a href="#"><strong>Challenge</strong></a></li>
                          <li class="list-inline-item"><a href="#"><strong>Flowers</strong></a></li>
                        </ul>
                      </div>
                      <h4 class="h3 fw-300 m-1 blog-post-title"><a href="#">5 Amazing places to visit before you die</a></h4>
                    </header>

                    <footer class="mr-t-30">
											<a href="#" class="btn btn-outline-primary btn-rounded">Continue Reading</a>
                    </footer>
                  </div><!-- /.blog-post -->
                </div><!-- /.col-md-4 -->

								<div class="col-md-4 mr-b-30 d-flex">
                  <div class="blog-post blog-post-card text-center">
                    <figure>
                      <a href="#">
                        <img src="assets/demo/cards/blog-post-2.jpeg" alt="" />
                      </a>
                    </figure>

                    <header>
                      <ul class="blog-post-share-links list-unstyled list-inline">
                        <li class="list-inline-item"><a href="javascript:void(0)" class="bg-primary ripple toggle-link"><i class="list-icon social-icons">sharethis</i></a></li>
                        <li class="list-inline-item"><a href="javascript:void(0)" class="bg-facebook ripple"><i class="list-icon social-icons">facebook</i></a></li>
                        <li class="list-inline-item"><a href="javascript:void(0)" class="bg-twitter ripple"><i class="list-icon social-icons">twitter</i></a></li>
                        <li class="list-inline-item"><a href="javascript:void(0)" class="bg-dribbble ripple"><i class="list-icon social-icons">dribble</i></a></li>
                      </ul>
                      <div class="text-muted blog-post-tags">Posted in
                        <ul class="ml-1 inline-block list-unstyled list-inline">
                          <li class="list-inline-item"><a href="#"><strong>Challenge</strong></a></li>
                          <li class="list-inline-item"><a href="#"><strong>Flowers</strong></a></li>
                        </ul>
                      </div>
                      <h4 class="h3 fw-300 m-1 blog-post-title"><a href="#">8 Practical ways to improve yourself</a></h4>
                    </header>

                    <footer class="mr-t-30">
											<a href="#" class="btn btn-outline-primary btn-rounded">Continue Reading</a>
                    </footer>
                  </div><!-- /.blog-post -->
                </div><!-- /.col-md-4 -->

								<div class="col-md-4 mr-b-30 d-flex">
                  <div class="blog-post blog-post-card text-center">
                    <figure>
                      <a href="#">
                        <img src="assets/demo/cards/blog-post-3.jpeg" alt="" />
                      </a>
                    </figure>

                    <header>
                      <ul class="blog-post-share-links list-unstyled list-inline">
                        <li class="list-inline-item"><a href="javascript:void(0)" class="bg-primary ripple toggle-link"><i class="list-icon social-icons">sharethis</i></a></li>
                        <li class="list-inline-item"><a href="javascript:void(0)" class="bg-facebook ripple"><i class="list-icon social-icons">facebook</i></a></li>
                        <li class="list-inline-item"><a href="javascript:void(0)" class="bg-twitter ripple"><i class="list-icon social-icons">twitter</i></a></li>
                        <li class="list-inline-item"><a href="javascript:void(0)" class="bg-dribbble ripple"><i class="list-icon social-icons">dribble</i></a></li>
                      </ul>
                      <div class="block text-muted blog-post-tags">Posted in
                        <ul class="ml-1 inline-block list-unstyled list-inline">
                          <li class="list-inline-item"><a href="#"><strong>Challenge</strong></a></li>
                          <li class="list-inline-item"><a href="#"><strong>Flowers</strong></a></li>
                        </ul>
                      </div>
                      <h4 class="h3 fw-300 m-1 blog-post-title"><a href="#">3 Benefits of waking up early</a></h4>
                    </header>

                    <footer class="mr-t-30">
											<a href="#" class="btn btn-outline-primary btn-rounded">Continue Reading</a>
                    </footer>
                  </div><!-- /.blog-post -->
                </div><!-- /.col-md-4 -->

              </div><!-- /.row -->
            </div><!-- /.widget-body -->
          </div><!-- /.widget-bg-transparent -->
        </div><!-- /.widget-holder -->

			</div><!-- /.row -->
		</div><!-- /.widget-list -->
	</main><!-- /.main-wrappper -->

	<?php get_template_part('partials/right-sidebar') ?>
</div><!-- /.content-wrapper -->

<?php get_footer();
