<?php
include_once 'lib/init.php';

$config = array(
	'title' => 'Real Estate',
	'body_class' => $GLOBALS['body_class'] . '',
	'scripts' => array(
    'mithril',
    'theme-widgets',
    'gmaps-api',
    'gmaps',
	),
  'styles' => array(
    'linea-icons'
  )
);

get_header($config);
?>

<div class="content-wrapper">
	<?php get_template_part( $GLOBALS['sidebar_file'] ) ?>

	<main class="main-wrapper clearfix">

		<!-- =================================== -->
		<!-- Different data widgets ============ -->
		<!-- =================================== -->

    <div class="widget-list row widget-list-full-width">
      <div class="col p-0 widget-holder widget-map widget-no-padding">
        <div class="widget-bg-transparent">
          <div class="widget-body">

            <div class="row">
              <div class="col">
                <div class="gmap" data-toggle="google-map" style="height: 600px" data-plugin-options='{"lat": -12.043333, "lng": -77.028333}'>
                  <script type="text/json" class="map-style">
                    [{"featureType":"all","elementType":"labels.text.fill","stylers":[{"saturation":36},{"color":"#333333"},{"lightness":40}]},{"featureType":"all","elementType":"labels.text.stroke","stylers":[{"visibility":"on"},{"color":"#ffffff"},{"lightness":16}]},{"featureType":"all","elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"featureType":"administrative","elementType":"geometry.fill","stylers":[{"color":"#fefefe"},{"lightness":20}]},{"featureType":"administrative","elementType":"geometry.stroke","stylers":[{"color":"#fefefe"},{"lightness":17},{"weight":1.2}]},{"featureType":"administrative.land_parcel","elementType":"geometry.fill","stylers":[{"visibility":"on"}]},{"featureType":"landscape","elementType":"geometry","stylers":[{"color":"#f5f5f5"},{"lightness":20}]},{"featureType":"landscape.man_made","elementType":"geometry.fill","stylers":[{"visibility":"on"}]},{"featureType":"poi","elementType":"geometry","stylers":[{"color":"#f5f5f5"},{"lightness":21}]},{"featureType":"poi.attraction","elementType":"all","stylers":[{"visibility":"off"},{"weight":"0.01"},{"gamma":"1.00"},{"lightness":"0"},{"saturation":"0"},{"color":"#6300ff"}]},{"featureType":"poi.business","elementType":"all","stylers":[{"visibility":"off"}]},{"featureType":"poi.government","elementType":"all","stylers":[{"visibility":"on"},{"color":"#6300ff"},{"weight":"0.01"}]},{"featureType":"poi.park","elementType":"all","stylers":[{"color":"#ff0000"},{"visibility":"on"}]},{"featureType":"poi.park","elementType":"geometry","stylers":[{"color":"#6300ff"},{"lightness":"0"},{"visibility":"on"},{"weight":"1"},{"gamma":"1"},{"saturation":"-32"}]},{"featureType":"poi.park","elementType":"geometry.fill","stylers":[{"color":"#6300ff"},{"saturation":"0"},{"lightness":"82"}]},{"featureType":"poi.park","elementType":"labels.text","stylers":[{"color":"#6300ff"},{"weight":"0.01"}]},{"featureType":"poi.park","elementType":"labels.text.fill","stylers":[{"color":"#6300ff"}]},{"featureType":"poi.park","elementType":"labels.icon","stylers":[{"color":"#6300ff"},{"gamma":"9.28"},{"weight":"0.01"}]},{"featureType":"poi.school","elementType":"all","stylers":[{"visibility":"off"}]},{"featureType":"road.highway","elementType":"geometry.fill","stylers":[{"color":"#ffffff"},{"lightness":17}]},{"featureType":"road.highway","elementType":"geometry.stroke","stylers":[{"color":"#ffffff"},{"lightness":29},{"weight":0.2}]},{"featureType":"road.arterial","elementType":"geometry","stylers":[{"color":"#ffffff"},{"lightness":18}]},{"featureType":"road.local","elementType":"geometry","stylers":[{"color":"#ffffff"},{"lightness":16}]},{"featureType":"road.local","elementType":"labels","stylers":[{"visibility":"simplified"}]},{"featureType":"transit","elementType":"geometry","stylers":[{"color":"#f2f2f2"},{"lightness":19}]},{"featureType":"transit.station","elementType":"geometry.fill","stylers":[{"visibility":"on"}]},{"featureType":"transit.station.rail","elementType":"geometry.fill","stylers":[{"visibility":"on"}]},{"featureType":"transit.station.rail","elementType":"labels.text.fill","stylers":[{"visibility":"simplified"}]},{"featureType":"water","elementType":"all","stylers":[{"visibility":"on"},{"color":"#ffffff"}]},{"featureType":"water","elementType":"geometry","stylers":[{"color":"#e9e9e9"},{"lightness":17}]}]
                  </script>
                  <div class="map-overlays" data-plugin-options='{ "lat": -12.043449, "lng": -77.030497 }'>
                    <div class="overlay py-2">
                      <div class="inverse">
                        <p class="mr-b-0 fs-13 fw-700">$561K</p>
                      </div><!-- /.inverse -->
                    </div><!-- /.overlay -->
                  </div><!-- /.map-overlays -->

                  <div class="map-overlays" data-plugin-options='{ "lat": -12.0375, "lng": -77.04045 }'>
                    <div class="overlay py-2">
                      <div class="inverse">
                        <p class="mr-b-0 fs-13 fw-700">$340K</p>
                      </div><!-- /.inverse -->
                    </div><!-- /.overlay -->
                  </div><!-- /.map-overlays -->

                  <div class="map-overlays" data-plugin-options='{ "lat": -12.0523, "lng": -77.03745 }'>
                    <div class="overlay py-2">
                      <div class="inverse">
                        <p class="mr-b-0 fs-13 fw-700">$170K</p>
                      </div><!-- /.inverse -->
                    </div><!-- /.overlay -->
                  </div><!-- /.map-overlays -->

                  <div class="map-overlays" data-plugin-options='{ "lat": -12.04686, "lng": -77.01278}'>
                    <div class="overlay py-2">
                      <div class="inverse">
                        <p class="mr-b-0 fs-13 fw-700">$130K</p>
                      </div><!-- /.inverse -->
                    </div><!-- /.overlay -->
                  </div><!-- /.map-overlays -->

                  <div class="map-overlays" data-plugin-options='{ "lat": -12.03686, "lng": -77.02478}'>
                    <div class="overlay py-2">
                      <div class="inverse">
                        <p class="mr-b-0 fs-13 fw-700">$270K</p>
                      </div><!-- /.inverse -->
                    </div><!-- /.overlay -->
                  </div><!-- /.map-overlays -->

                  <div class="map-overlays" data-plugin-options='{ "lat": -12.04586, "lng": -77.04478}'>
                    <div class="overlay py-2">
                      <div class="inverse">
                        <p class="mr-b-0 fs-13 fw-700">$880K</p>
                      </div><!-- /.inverse -->
                    </div><!-- /.overlay -->
                  </div><!-- /.map-overlays -->
                </div><!-- /.gmap -->
              </div><!-- /.col -->

              <div class="col-md-4 d-none d-md-block pos-absolute pos-right vertical-center mr-4 pl-5">
                <div class="card bg-color-scheme radius-10 mb-3">
                  <div class="card-body px-4 py-3">
                    <p class="mb-0 headings-font-family"><span class="fw-700 border-bottom border-bottom-dotted">426 Properties</span> Listed. View All.</p>
                    <a href="#" class="opacity-0 pos-absolute pos-0">Something</a>
                  </div><!-- /.card-body -->
                </div><!-- /.card -->

                <div class="card radius-10 mb-3">
                  <div class="card-body pd-10">
                    <div class="media align-items-stretch">
                      <figure class="mr-3 mr-0-rtl ml-3-rtl pos-relative">
                        <a href="#">
                          <img src="assets/demo/real-estate/real-11.jpg" class="radius-10" alt="Image 1" />
                          <span class="featured text-uppercase bg-color-scheme p-1 fs-10 headings-font-family fw-500 radius-3">Featured</span>
                        </a>
                      </figure>
                      <div class="media-body d-flex flex-column">
                        <h6 class="mt-2 mb-1 fs-14 fw-500"><a href="#" class="headings-color">3 Bedroom House</a></h6>
                        <small class="fs-11"><i class="feather feather-map-pin lh-10"></i> 8 Cuvier St., San Fransisco, CA</small>
                        <span class="mt-0 color-color-scheme fs-24 headings-font-family">$516K</span>
                        <span class="flex-1"></span>
                        <div class="mb-2 d-flex align-items-center">
                          <span class="star-ratings fs-12"><span style="width: 100%"></span></span>
                          <span class="color-color-scheme headings-font-family fs-11 fw-semibold ml-2 ml-0-rtl mr-2-rtl">Seller Ratings</span>
                        </div>
                      </div><!-- /.media-body -->
                    </div><!-- /.media -->
                  </div><!-- /.card-body -->
                </div><!-- /.card -->

                <div class="card radius-10">
                  <div class="card-body pd-10">
                    <div class="media align-items-stretch">
                      <figure class="mr-3 mr-0-rtl ml-3-rtl pos-relative">
                        <a href="#">
                          <img src="assets/demo/real-estate/real-12.jpg" class="radius-10" alt="Image 1" />
                          <span class="featured text-uppercase bg-color-scheme p-1 fs-10 headings-font-family fw-500 radius-3">Featured</span>
                        </a>
                      </figure>
                      <div class="media-body d-flex flex-column">
                        <h6 class="mt-2 mb-1 fs-14 fw-500"><a href="#" class="headings-color">2 Bedroom Condo</a></h6>
                        <small class="fs-11"><i class="feather feather-map-pin lh-10"></i> 8 Cuvier St., San Fransisco, CA</small>
                        <span class="mt-0 color-color-scheme fs-24 headings-font-family">$340K</span>
                        <span class="flex-1"></span>
                        <div class="mb-2 d-flex align-items-center">
                          <span class="star-ratings fs-10"><span style="width: 80%"></span></span>
                          <span class="color-color-scheme headings-font-family fs-11 fw-semibold ml-2 ml-0-rtl mr-2-rtl">Seller Ratings</span>
                        </div>
                      </div><!-- /.media-body -->
                    </div><!-- /.media -->
                  </div><!-- /.card-body -->
                </div><!-- /.card -->
              </div><!-- /.col-3 -->
            </div><!-- /.row -->
          </div><!-- /.widget-body -->
        </div><!-- /.widget-bg-transparent -->
      </div><!-- /.widget-holder -->
    </div><!-- /.widget-list -->

    <hr class="border-0" />

    <div class="widget-list row mt-5">

      <div class="col-md-12 widget-holder">
        <div class="widget-bg-transparent">
          <div class="widget-body pd-0">

            <div class="row">
              <div class="col-md-4 d-flex">

                <div class="listing-card">
                  <figure>
                    <a href="#">
                      <img src="assets/demo/real-estate/real-10.jpg" alt="" />
                    </a>

                    <a class="add-to-favourites" href="javascript:void(0);" title="Add to Favourites">
                      <i class="list-icon feather feather-heart"></i>
                    </a>
                  </figure>

                  <header>
                    <div class="clearfix">
                      <h4 class="fw-600 my-0">
                        <a href="#">&dollar;516,000</a>
                        <span class="badge bg-color-scheme text-uppercase fs-10 py-2 mx-2 align-middle">Featured</span>
                      </h4>

                    </div>

                    <strong>8 Cuvier St</strong>, San Fransisco, CA
                  </header>

                  <div class="card-info row">
                    <div class="col-md-4 card-info-room">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                        <g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"><path d="   M90,264c0,1.657,1.343,3,3,3h114c1.657,0,3-1.343,3-3V36c0-1.657-1.343-3-3-3H93c-1.657,0-3,1.343-3,3V264z"></path>
                        <polyline points="107 135 107 50 193 50 193 250 107 250 107 205"></polyline>
                        <path d="m115 174v15s-0.377 2-6.751 2-7.249-2-7.249-2v-38s2.068-2 7.626-2 6.374 2 6.374 2v5"></path>
                        <line x1="128" x2="111" y1="165" y2="165"></line>
                        </g>
                      </svg>

                      <span><strong>1876</strong> Sqft</span>
                    </div> <!-- /.col-md-4 -->

                    <div class="col-md-4 card-info-beds">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg"><g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"><path d="m225.65 137h-149.92c-16.693 0-31.726 12.269-31.726 28.962v43.525c0 2.003 3.124 4.513 5.127 4.513h203.12c2.004 0 2.755-2.51 2.755-4.513v-43.525c0-16.693-12.661-28.962-29.354-28.962z"></path>
                        <path d="m255 176.63c0-2.003-1.624-3.627-3.627-3.627h-203.75c-2.003 0-3.627 1.624-3.627 3.627v33.746c0 2.003 1.624 3.627 3.627 3.627h203.75c2.003 0 3.627-1.624 3.627-3.627v-33.746z"></path>
                        <path d="   M237,126V71.657c0-2.003-0.887-2.657-2.891-2.657H67.263C65.26,69,63,69.654,63,71.657V126"></path>
                        <line x1="44" x2="44" y1="195" y2="231"></line>
                        <line x1="255" x2="255" y1="195" y2="231"></line>
                        <path d="m199.54 125.91c0-8.987 1.927-18.451 1.927-18.451 0-1.595-1.294-3.046-2.89-3.046 0 0-8.986 1.846-17.812 1.846s-18.774-1.965-18.774-1.965c-1.597 0-2.891 1.273-2.891 2.869 0 0 1.927 9.128 1.927 18.757"></path>
                        <path d="m140.35 125.91c0-8.987 1.926-18.451 1.926-18.451 0-1.595-1.294-3.046-2.889-3.046 0 0-8.987 1.846-17.812 1.846-8.827 0-18.775-1.965-18.775-1.965-1.597 0-2.889 1.273-2.889 2.869 0 0 1.925 9.128 1.925 18.757"></path>
                        </g>
                      </svg>

                      <span><strong>3</strong> beds</span>
                    </div> <!-- /.col-md-4 -->

                    <div class="col-md-4 card-info-baths">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                        <path d="  M203,178.5H50.551c1.053,28.343,24.349,64,52.949,64h92c28.6,0,51.896-35.657,52.949-64H203" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></path>
                        <line x1="39" x2="52" y1="178.5" y2="178.5" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="248" x2="261" y1="178.5" y2="178.5" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="97.958" x2="92.041" y1="244.32" y2="258.68" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="203.04" x2="208.96" y1="244.32" y2="258.68" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <path d="m82 132v-10c0-8.837-7.164-16-16-16s-16 7.163-16 16v57" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"></path>
                        <line x1="71" x2="94" y1="133" y2="133" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"></line>
                        <g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10"><rect x="169" y="178" width="33" height="37" stroke-width="6"></rect>
                        <line x1="170" x2="201" y1="196.5" y2="196.5" stroke-width="7"></line>
                        </g>
                      </svg>

                      <span><strong>3</strong> baths</span>
                    </div> <!-- /.col-md-4 -->
                  </div><!-- /.card-info -->

                  <footer class="mr-t-20 clearfix">
                    <div class="float-left">
                      <a href="javascript:void(0)">
                        <i class="feather feather-share-2 fs-18"></i>
                        Share
                      </a>
                    </div>

                    <div class="float-right text-right">
                      <a href="#" class="btn btn-sm btn-outline-primary ripple">View Property</a>
                    </div>
                  </footer>
                </div><!-- /.listing-card -->

              </div><!-- /.col-md-4 -->

              <div class="col-md-4 d-flex">

                <div class="listing-card">
                  <figure>
                    <a href="#">
                      <img src="assets/demo/real-estate/real-09.jpg" alt="" />
                    </a>

                    <a class="add-to-favourites" href="javascript:void(0);" title="Add to Favourites">
                      <i class="list-icon feather feather-heart"></i>
                    </a>
                  </figure>

                  <header>
                    <div class="clearfix">
                      <h4 class="fw-600 my-0">
                        <a href="#">&dollar;819,000</a>
                        <span class="badge bg-color-scheme text-uppercase fs-10 py-2 mx-2 align-middle">Featured</span>
                      </h4>

                    </div>

                    <strong>2859 Steiner St</strong>, San Fransisco, CA
                  </header>

                  <div class="card-info row">
                    <div class="col-md-4 card-info-room">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                        <g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"><path d="   M90,264c0,1.657,1.343,3,3,3h114c1.657,0,3-1.343,3-3V36c0-1.657-1.343-3-3-3H93c-1.657,0-3,1.343-3,3V264z"></path>
                        <polyline points="107 135 107 50 193 50 193 250 107 250 107 205"></polyline>
                        <path d="m115 174v15s-0.377 2-6.751 2-7.249-2-7.249-2v-38s2.068-2 7.626-2 6.374 2 6.374 2v5"></path>
                        <line x1="128" x2="111" y1="165" y2="165"></line>
                        </g>
                      </svg>

                      <span><strong>3922</strong> Sqft</span>
                    </div> <!-- /.col-md-4 -->

                    <div class="col-md-4 card-info-beds">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg"><g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"><path d="m225.65 137h-149.92c-16.693 0-31.726 12.269-31.726 28.962v43.525c0 2.003 3.124 4.513 5.127 4.513h203.12c2.004 0 2.755-2.51 2.755-4.513v-43.525c0-16.693-12.661-28.962-29.354-28.962z"></path>
                        <path d="m255 176.63c0-2.003-1.624-3.627-3.627-3.627h-203.75c-2.003 0-3.627 1.624-3.627 3.627v33.746c0 2.003 1.624 3.627 3.627 3.627h203.75c2.003 0 3.627-1.624 3.627-3.627v-33.746z"></path>
                        <path d="   M237,126V71.657c0-2.003-0.887-2.657-2.891-2.657H67.263C65.26,69,63,69.654,63,71.657V126"></path>
                        <line x1="44" x2="44" y1="195" y2="231"></line>
                        <line x1="255" x2="255" y1="195" y2="231"></line>
                        <path d="m199.54 125.91c0-8.987 1.927-18.451 1.927-18.451 0-1.595-1.294-3.046-2.89-3.046 0 0-8.986 1.846-17.812 1.846s-18.774-1.965-18.774-1.965c-1.597 0-2.891 1.273-2.891 2.869 0 0 1.927 9.128 1.927 18.757"></path>
                        <path d="m140.35 125.91c0-8.987 1.926-18.451 1.926-18.451 0-1.595-1.294-3.046-2.889-3.046 0 0-8.987 1.846-17.812 1.846-8.827 0-18.775-1.965-18.775-1.965-1.597 0-2.889 1.273-2.889 2.869 0 0 1.925 9.128 1.925 18.757"></path>
                        </g>
                      </svg>

                      <span><strong>8</strong> beds</span>
                    </div> <!-- /.col-md-4 -->

                    <div class="col-md-4 card-info-baths">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                        <path d="  M203,178.5H50.551c1.053,28.343,24.349,64,52.949,64h92c28.6,0,51.896-35.657,52.949-64H203" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></path>
                        <line x1="39" x2="52" y1="178.5" y2="178.5" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="248" x2="261" y1="178.5" y2="178.5" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="97.958" x2="92.041" y1="244.32" y2="258.68" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="203.04" x2="208.96" y1="244.32" y2="258.68" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <path d="m82 132v-10c0-8.837-7.164-16-16-16s-16 7.163-16 16v57" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"></path>
                        <line x1="71" x2="94" y1="133" y2="133" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"></line>
                        <g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10"><rect x="169" y="178" width="33" height="37" stroke-width="6"></rect>
                        <line x1="170" x2="201" y1="196.5" y2="196.5" stroke-width="7"></line>
                        </g>
                      </svg>

                      <span><strong>5</strong> baths</span>
                    </div> <!-- /.col-md-4 -->
                  </div><!-- /.card-info -->

                  <footer class="mr-t-20 clearfix">
                    <div class="float-left">
                      <a href="javascript:void(0)">
                        <i class="feather feather-share-2 fs-18"></i>
                        Share
                      </a>
                    </div>

                    <div class="float-right text-right">
                      <a href="#" class="btn btn-sm btn-outline-primary ripple">View Property</a>
                    </div>
                  </footer>
                </div><!-- /.listing-card -->

              </div><!-- /.col-md-4 -->

              <div class="col-md-4 d-flex">

                <div class="listing-card">
                  <figure>
                    <a href="#">
                      <img src="assets/demo/real-estate/real-08.jpg" alt="" />
                    </a>

                    <a class="add-to-favourites" href="javascript:void(0);" title="Add to Favourites">
                      <i class="list-icon feather feather-heart"></i>
                    </a>
                  </figure>

                  <header>
                    <div class="clearfix">
                      <h4 class="fw-600 my-0">
                        <a href="#">&dollar;1,689,000</a>
                        <span class="badge bg-color-scheme text-uppercase fs-10 py-2 mx-2 align-middle">Featured</span>
                      </h4>

                    </div>

                    <strong>1688 Pine St</strong>, San Fransisco, CA
                  </header>

                  <div class="card-info row">
                    <div class="col-md-4 card-info-room">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                        <g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"><path d="   M90,264c0,1.657,1.343,3,3,3h114c1.657,0,3-1.343,3-3V36c0-1.657-1.343-3-3-3H93c-1.657,0-3,1.343-3,3V264z"></path>
                        <polyline points="107 135 107 50 193 50 193 250 107 250 107 205"></polyline>
                        <path d="m115 174v15s-0.377 2-6.751 2-7.249-2-7.249-2v-38s2.068-2 7.626-2 6.374 2 6.374 2v5"></path>
                        <line x1="128" x2="111" y1="165" y2="165"></line>
                        </g>
                      </svg>

                      <span><strong>1150</strong> Sqft</span>
                    </div> <!-- /.col-md-4 -->

                    <div class="col-md-4 card-info-beds">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg"><g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"><path d="m225.65 137h-149.92c-16.693 0-31.726 12.269-31.726 28.962v43.525c0 2.003 3.124 4.513 5.127 4.513h203.12c2.004 0 2.755-2.51 2.755-4.513v-43.525c0-16.693-12.661-28.962-29.354-28.962z"></path>
                        <path d="m255 176.63c0-2.003-1.624-3.627-3.627-3.627h-203.75c-2.003 0-3.627 1.624-3.627 3.627v33.746c0 2.003 1.624 3.627 3.627 3.627h203.75c2.003 0 3.627-1.624 3.627-3.627v-33.746z"></path>
                        <path d="   M237,126V71.657c0-2.003-0.887-2.657-2.891-2.657H67.263C65.26,69,63,69.654,63,71.657V126"></path>
                        <line x1="44" x2="44" y1="195" y2="231"></line>
                        <line x1="255" x2="255" y1="195" y2="231"></line>
                        <path d="m199.54 125.91c0-8.987 1.927-18.451 1.927-18.451 0-1.595-1.294-3.046-2.89-3.046 0 0-8.986 1.846-17.812 1.846s-18.774-1.965-18.774-1.965c-1.597 0-2.891 1.273-2.891 2.869 0 0 1.927 9.128 1.927 18.757"></path>
                        <path d="m140.35 125.91c0-8.987 1.926-18.451 1.926-18.451 0-1.595-1.294-3.046-2.889-3.046 0 0-8.987 1.846-17.812 1.846-8.827 0-18.775-1.965-18.775-1.965-1.597 0-2.889 1.273-2.889 2.869 0 0 1.925 9.128 1.925 18.757"></path>
                        </g>
                      </svg>

                      <span><strong>2</strong> beds</span>
                    </div> <!-- /.col-md-4 -->

                    <div class="col-md-4 card-info-baths">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                        <path d="  M203,178.5H50.551c1.053,28.343,24.349,64,52.949,64h92c28.6,0,51.896-35.657,52.949-64H203" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></path>
                        <line x1="39" x2="52" y1="178.5" y2="178.5" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="248" x2="261" y1="178.5" y2="178.5" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="97.958" x2="92.041" y1="244.32" y2="258.68" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="203.04" x2="208.96" y1="244.32" y2="258.68" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <path d="m82 132v-10c0-8.837-7.164-16-16-16s-16 7.163-16 16v57" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"></path>
                        <line x1="71" x2="94" y1="133" y2="133" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"></line>
                        <g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10"><rect x="169" y="178" width="33" height="37" stroke-width="6"></rect>
                        <line x1="170" x2="201" y1="196.5" y2="196.5" stroke-width="7"></line>
                        </g>
                      </svg>

                      <span><strong>2</strong> baths</span>
                    </div> <!-- /.col-md-4 -->
                  </div><!-- /.card-info -->

                  <footer class="mr-t-20 clearfix">
                    <div class="float-left">
                      <a href="javascript:void(0)">
                        <i class="feather feather-share-2 fs-18"></i>
                        Share
                      </a>
                    </div>

                    <div class="float-right text-right">
                      <a href="#" class="btn btn-sm btn-outline-primary ripple">View Property</a>
                    </div>
                  </footer>
                </div><!-- /.listing-card -->

              </div><!-- /.col-md-4 -->
            </div><!-- /.row -->

            <div class="row">
              <div class="col-md-4 d-flex">

                <div class="listing-card">
                  <figure>
                    <a href="#">
                      <img src="assets/demo/real-estate/real-02.jpg" alt="" />
                    </a>

                    <a class="add-to-favourites" href="javascript:void(0);" title="Add to Favourites">
                      <i class="list-icon feather feather-heart"></i>
                    </a>
                  </figure>

                  <header>
                    <div class="clearfix">
                      <h4 class="fw-600 my-0">
                        <a href="#">&dollar;3,495,000</a>
                        <span class="badge bg-color-scheme text-uppercase fs-10 py-2 mx-2 align-middle">Featured</span>
                      </h4>

                    </div>

                    <strong>2121 Webster St</strong>, San Fransisco, CA
                  </header>

                  <div class="card-info row">
                    <div class="col-md-4 card-info-room">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                        <g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"><path d="   M90,264c0,1.657,1.343,3,3,3h114c1.657,0,3-1.343,3-3V36c0-1.657-1.343-3-3-3H93c-1.657,0-3,1.343-3,3V264z"></path>
                        <polyline points="107 135 107 50 193 50 193 250 107 250 107 205"></polyline>
                        <path d="m115 174v15s-0.377 2-6.751 2-7.249-2-7.249-2v-38s2.068-2 7.626-2 6.374 2 6.374 2v5"></path>
                        <line x1="128" x2="111" y1="165" y2="165"></line>
                        </g>
                      </svg>

                      <span><strong>3793</strong> Sqft</span>
                    </div> <!-- /.col-md-4 -->

                    <div class="col-md-4 card-info-beds">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg"><g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"><path d="m225.65 137h-149.92c-16.693 0-31.726 12.269-31.726 28.962v43.525c0 2.003 3.124 4.513 5.127 4.513h203.12c2.004 0 2.755-2.51 2.755-4.513v-43.525c0-16.693-12.661-28.962-29.354-28.962z"></path>
                        <path d="m255 176.63c0-2.003-1.624-3.627-3.627-3.627h-203.75c-2.003 0-3.627 1.624-3.627 3.627v33.746c0 2.003 1.624 3.627 3.627 3.627h203.75c2.003 0 3.627-1.624 3.627-3.627v-33.746z"></path>
                        <path d="   M237,126V71.657c0-2.003-0.887-2.657-2.891-2.657H67.263C65.26,69,63,69.654,63,71.657V126"></path>
                        <line x1="44" x2="44" y1="195" y2="231"></line>
                        <line x1="255" x2="255" y1="195" y2="231"></line>
                        <path d="m199.54 125.91c0-8.987 1.927-18.451 1.927-18.451 0-1.595-1.294-3.046-2.89-3.046 0 0-8.986 1.846-17.812 1.846s-18.774-1.965-18.774-1.965c-1.597 0-2.891 1.273-2.891 2.869 0 0 1.927 9.128 1.927 18.757"></path>
                        <path d="m140.35 125.91c0-8.987 1.926-18.451 1.926-18.451 0-1.595-1.294-3.046-2.889-3.046 0 0-8.987 1.846-17.812 1.846-8.827 0-18.775-1.965-18.775-1.965-1.597 0-2.889 1.273-2.889 2.869 0 0 1.925 9.128 1.925 18.757"></path>
                        </g>
                      </svg>

                      <span><strong>5</strong> beds</span>
                    </div> <!-- /.col-md-4 -->

                    <div class="col-md-4 card-info-baths">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                        <path d="  M203,178.5H50.551c1.053,28.343,24.349,64,52.949,64h92c28.6,0,51.896-35.657,52.949-64H203" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></path>
                        <line x1="39" x2="52" y1="178.5" y2="178.5" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="248" x2="261" y1="178.5" y2="178.5" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="97.958" x2="92.041" y1="244.32" y2="258.68" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="203.04" x2="208.96" y1="244.32" y2="258.68" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <path d="m82 132v-10c0-8.837-7.164-16-16-16s-16 7.163-16 16v57" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"></path>
                        <line x1="71" x2="94" y1="133" y2="133" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"></line>
                        <g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10"><rect x="169" y="178" width="33" height="37" stroke-width="6"></rect>
                        <line x1="170" x2="201" y1="196.5" y2="196.5" stroke-width="7"></line>
                        </g>
                      </svg>

                      <span><strong>4</strong> baths</span>
                    </div> <!-- /.col-md-4 -->
                  </div><!-- /.card-info -->

                  <footer class="mr-t-20 clearfix">
                    <div class="float-left">
                      <a href="javascript:void(0)">
                        <i class="feather feather-share-2 fs-18"></i>
                        Share
                      </a>
                    </div>

                    <div class="float-right text-right">
                      <a href="#" class="btn btn-sm btn-outline-primary ripple">View Property</a>
                    </div>
                  </footer>
                </div><!-- /.listing-card -->

              </div><!-- /.col-md-4 -->

              <div class="col-md-4 d-flex">

                <div class="listing-card">
                  <figure>
                    <a href="#">
                      <img src="assets/demo/real-estate/real-06.jpg" alt="" />
                    </a>

                    <a class="add-to-favourites" href="javascript:void(0);" title="Add to Favourites">
                      <i class="list-icon feather feather-heart"></i>
                    </a>
                  </figure>

                  <header>
                    <div class="clearfix">
                      <h4 class="fw-600 my-0">
                        <a href="#">&dollar;998,000</a>
                        <span class="badge bg-color-scheme text-uppercase fs-10 py-2 mx-2 align-middle">Featured</span>
                      </h4>

                    </div>

                    <strong>2002 Laguna St</strong>, San Fransisco, CA
                  </header>

                  <div class="card-info row">
                    <div class="col-md-4 card-info-room">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                        <g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"><path d="   M90,264c0,1.657,1.343,3,3,3h114c1.657,0,3-1.343,3-3V36c0-1.657-1.343-3-3-3H93c-1.657,0-3,1.343-3,3V264z"></path>
                        <polyline points="107 135 107 50 193 50 193 250 107 250 107 205"></polyline>
                        <path d="m115 174v15s-0.377 2-6.751 2-7.249-2-7.249-2v-38s2.068-2 7.626-2 6.374 2 6.374 2v5"></path>
                        <line x1="128" x2="111" y1="165" y2="165"></line>
                        </g>
                      </svg>

                      <span><strong>1548</strong> Sqft</span>
                    </div> <!-- /.col-md-4 -->

                    <div class="col-md-4 card-info-beds">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg"><g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"><path d="m225.65 137h-149.92c-16.693 0-31.726 12.269-31.726 28.962v43.525c0 2.003 3.124 4.513 5.127 4.513h203.12c2.004 0 2.755-2.51 2.755-4.513v-43.525c0-16.693-12.661-28.962-29.354-28.962z"></path>
                        <path d="m255 176.63c0-2.003-1.624-3.627-3.627-3.627h-203.75c-2.003 0-3.627 1.624-3.627 3.627v33.746c0 2.003 1.624 3.627 3.627 3.627h203.75c2.003 0 3.627-1.624 3.627-3.627v-33.746z"></path>
                        <path d="   M237,126V71.657c0-2.003-0.887-2.657-2.891-2.657H67.263C65.26,69,63,69.654,63,71.657V126"></path>
                        <line x1="44" x2="44" y1="195" y2="231"></line>
                        <line x1="255" x2="255" y1="195" y2="231"></line>
                        <path d="m199.54 125.91c0-8.987 1.927-18.451 1.927-18.451 0-1.595-1.294-3.046-2.89-3.046 0 0-8.986 1.846-17.812 1.846s-18.774-1.965-18.774-1.965c-1.597 0-2.891 1.273-2.891 2.869 0 0 1.927 9.128 1.927 18.757"></path>
                        <path d="m140.35 125.91c0-8.987 1.926-18.451 1.926-18.451 0-1.595-1.294-3.046-2.889-3.046 0 0-8.987 1.846-17.812 1.846-8.827 0-18.775-1.965-18.775-1.965-1.597 0-2.889 1.273-2.889 2.869 0 0 1.925 9.128 1.925 18.757"></path>
                        </g>
                      </svg>

                      <span><strong>2</strong> beds</span>
                    </div> <!-- /.col-md-4 -->

                    <div class="col-md-4 card-info-baths">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                        <path d="  M203,178.5H50.551c1.053,28.343,24.349,64,52.949,64h92c28.6,0,51.896-35.657,52.949-64H203" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></path>
                        <line x1="39" x2="52" y1="178.5" y2="178.5" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="248" x2="261" y1="178.5" y2="178.5" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="97.958" x2="92.041" y1="244.32" y2="258.68" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="203.04" x2="208.96" y1="244.32" y2="258.68" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <path d="m82 132v-10c0-8.837-7.164-16-16-16s-16 7.163-16 16v57" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"></path>
                        <line x1="71" x2="94" y1="133" y2="133" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"></line>
                        <g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10"><rect x="169" y="178" width="33" height="37" stroke-width="6"></rect>
                        <line x1="170" x2="201" y1="196.5" y2="196.5" stroke-width="7"></line>
                        </g>
                      </svg>

                      <span><strong>2</strong> baths</span>
                    </div> <!-- /.col-md-4 -->
                  </div><!-- /.card-info -->

                  <footer class="mr-t-20 clearfix">
                    <div class="float-left">
                      <a href="javascript:void(0)">
                        <i class="feather feather-share-2 fs-18"></i>
                        Share
                      </a>
                    </div>

                    <div class="float-right text-right">
                      <a href="#" class="btn btn-sm btn-outline-primary ripple">View Property</a>
                    </div>
                  </footer>
                </div><!-- /.listing-card -->

              </div><!-- /.col-md-4 -->

              <div class="col-md-4 d-flex">

                <div class="listing-card">
                  <figure>
                    <a href="#">
                      <img src="assets/demo/real-estate/real-07.jpg" alt="" />
                    </a>

                    <a class="add-to-favourites" href="javascript:void(0);" title="Add to Favourites">
                      <i class="list-icon feather feather-heart"></i>
                    </a>
                  </figure>

                  <header>
                    <div class="clearfix">
                      <h4 class="fw-600 my-0">
                        <a href="#">&dollar;1,245,000</a>
                        <span class="badge bg-color-scheme text-uppercase fs-10 py-2 mx-2 align-middle">Featured</span>
                      </h4>
                    </div>

                    <strong>2495 Pacific Ave</strong>, San Fransisco, CA
                  </header>

                  <div class="card-info row">
                    <div class="col-md-4 card-info-room">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                        <g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"><path d="   M90,264c0,1.657,1.343,3,3,3h114c1.657,0,3-1.343,3-3V36c0-1.657-1.343-3-3-3H93c-1.657,0-3,1.343-3,3V264z"></path>
                        <polyline points="107 135 107 50 193 50 193 250 107 250 107 205"></polyline>
                        <path d="m115 174v15s-0.377 2-6.751 2-7.249-2-7.249-2v-38s2.068-2 7.626-2 6.374 2 6.374 2v5"></path>
                        <line x1="128" x2="111" y1="165" y2="165"></line>
                        </g>
                      </svg>

                      <span><strong>1223</strong> Sqft</span>
                    </div> <!-- /.col-md-4 -->

                    <div class="col-md-4 card-info-beds">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg"><g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"><path d="m225.65 137h-149.92c-16.693 0-31.726 12.269-31.726 28.962v43.525c0 2.003 3.124 4.513 5.127 4.513h203.12c2.004 0 2.755-2.51 2.755-4.513v-43.525c0-16.693-12.661-28.962-29.354-28.962z"></path>
                        <path d="m255 176.63c0-2.003-1.624-3.627-3.627-3.627h-203.75c-2.003 0-3.627 1.624-3.627 3.627v33.746c0 2.003 1.624 3.627 3.627 3.627h203.75c2.003 0 3.627-1.624 3.627-3.627v-33.746z"></path>
                        <path d="   M237,126V71.657c0-2.003-0.887-2.657-2.891-2.657H67.263C65.26,69,63,69.654,63,71.657V126"></path>
                        <line x1="44" x2="44" y1="195" y2="231"></line>
                        <line x1="255" x2="255" y1="195" y2="231"></line>
                        <path d="m199.54 125.91c0-8.987 1.927-18.451 1.927-18.451 0-1.595-1.294-3.046-2.89-3.046 0 0-8.986 1.846-17.812 1.846s-18.774-1.965-18.774-1.965c-1.597 0-2.891 1.273-2.891 2.869 0 0 1.927 9.128 1.927 18.757"></path>
                        <path d="m140.35 125.91c0-8.987 1.926-18.451 1.926-18.451 0-1.595-1.294-3.046-2.889-3.046 0 0-8.987 1.846-17.812 1.846-8.827 0-18.775-1.965-18.775-1.965-1.597 0-2.889 1.273-2.889 2.869 0 0 1.925 9.128 1.925 18.757"></path>
                        </g>
                      </svg>

                      <span><strong>1</strong> beds</span>
                    </div> <!-- /.col-md-4 -->

                    <div class="col-md-4 card-info-baths">
                      <svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                        <path d="  M203,178.5H50.551c1.053,28.343,24.349,64,52.949,64h92c28.6,0,51.896-35.657,52.949-64H203" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></path>
                        <line x1="39" x2="52" y1="178.5" y2="178.5" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="248" x2="261" y1="178.5" y2="178.5" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="97.958" x2="92.041" y1="244.32" y2="258.68" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <line x1="203.04" x2="208.96" y1="244.32" y2="258.68" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="7"></line>
                        <path d="m82 132v-10c0-8.837-7.164-16-16-16s-16 7.163-16 16v57" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"></path>
                        <line x1="71" x2="94" y1="133" y2="133" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-width="6"></line>
                        <g fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10"><rect x="169" y="178" width="33" height="37" stroke-width="6"></rect>
                        <line x1="170" x2="201" y1="196.5" y2="196.5" stroke-width="7"></line>
                        </g>
                      </svg>

                      <span><strong>1</strong> baths</span>
                    </div> <!-- /.col-md-4 -->
                  </div><!-- /.card-info -->

                  <footer class="mr-t-20 clearfix">
                    <div class="float-left">
                      <a href="javascript:void(0)">
                        <i class="feather feather-share-2 fs-18"></i>
                        Share
                      </a>
                    </div>

                    <div class="float-right text-right">
                      <a href="#" class="btn btn-sm btn-outline-primary ripple">View Property</a>
                    </div>
                  </footer>
                </div><!-- /.listing-card -->

              </div><!-- /.col-md-4 -->
            </div><!-- /.row -->

          </div><!-- /.widget-body -->
        </div><!-- /.widget-bg-transparent -->
      </div>
    </div>

    <hr class="mr-b-20" />

    <div class="widget-list row">
      <div class="widget-holder widget-full-height widget-flex col-sm-4">
        <div class="widget-bg">
          <div class="widget-heading widget-heading-border">
            <h5 class="widget-title">South Beach Properties</h5>
          </div><!-- /.widget-heading -->

          <div class="widget-body">

            <ul class="row list-unstyled gallery-small">
              <li class="col-md-6">
                <a href="#"><img src="assets/demo/real-estate/real-01.jpg" alt="" /></a>
              </li>

              <li class="col-md-6">
                <a href="#"><img src="assets/demo/real-estate/real-02.jpg" alt="" /></a>
              </li>

              <li class="col-md-6">
                <a href="#"><img src="assets/demo/real-estate/real-03.jpg" alt="" /></a>
              </li>

              <li class="col-md-6 active">
                <a href="#">
                  <img src="assets/demo/real-estate/real-04.jpg" alt="" />
                  <span>40+ <small>more</small></span>
                </a>
              </li>
            </ul><!-- /.thumb-gallery -->

          </div><!-- /.widget-body -->
        </div><!-- /.widget-bg -->
      </div><!-- /.widget-holder -->

      <div class="widget-holder widget-full-height widget-flex col-sm-4">
        <div class="widget-bg">
          <div class="widget-heading widget-heading-border">
            <h5 class="widget-title">Noe Valley Properties</h5>
          </div><!-- /.widget-heading -->

          <div class="widget-body">

            <ul class="row list-unstyled gallery-small">
              <li class="col-md-6">
                <a href="#"><img src="assets/demo/real-estate/real-05.jpg" alt="" /></a>
              </li>

              <li class="col-md-6">
                <a href="#"><img src="assets/demo/real-estate/real-06.jpg" alt="" /></a>
              </li>

              <li class="col-md-6">
                <a href="#"><img src="assets/demo/real-estate/real-07.jpg" alt="" /></a>
              </li>

              <li class="col-md-6 active">
                <a href="#">
                  <img src="assets/demo/real-estate/real-08.jpg" alt="" />
                  <span>73+ <small>more</small></span>
                </a>
              </li>
            </ul><!-- /.thumb-gallery -->

          </div><!-- /.widget-body -->
        </div><!-- /.widget-bg -->
      </div><!-- /.widget-holder -->

      <div class="widget-holder widget-full-height widget-flex col-sm-4">
        <div class="widget-bg bg-color-scheme color-white">
          <div class="widget-heading widget-heading-border">
            <h5 class="widget-title">Real Estate on the go</h5>
          </div><!-- /.widget-heading -->

          <div class="widget-body">
            <div class="row">
              <div class="col-md-6 widget-full-height widget-flex fw-300 fs-13 pd-t-10">
                <p>Never miss out on the best real estate deals around you.Get the best deals for most attractive properties.</p>
                <p>Install your favourite app for free and get all the updates sent right to your phone.</p>
              </div>
              <div class="col-md-6 text-center widget-full-height widget-flex pd-t-20">
                <a href="#" class="fs-10 fw-600 color-white text-uppercase heading-font-family">
                  <i class="linea linea-basic-mail-open opacity-03"></i>
                  <span class="d-block">Download App</span>
                </a>
              </div>
            </div>
          </div><!-- /.widget-body -->
        </div><!-- /.widget-bg -->
      </div><!-- /.widget-holder -->
    </div><!-- /.widget-list -->

  </main><!-- /.main-wrappper -->

  <?php get_template_part('partials/right-sidebar') ?>
</div><!-- /.content-wrapper -->

<?php get_footer();
