<?php
include_once 'lib/init.php';

$config = array(
  'title' => 'Job Board',
	'body_class' => $GLOBALS['body_class'] . '',
	'scripts' => array(
    'countup',
		'moment',
    'jquery-circle-progress',
    'sparkline',
    'slick',
    'mithril',
    'theme-widgets',
    'magnific-popup',
	),
	'styles' => array(
    'slick',
    'slick-theme',
    'magnific-popup',
    'linea-icons',
  ),
);

get_header($config);
?>

<div class="content-wrapper">
	<?php get_template_part( $GLOBALS['sidebar_file'] ) ?>

	<main class="main-wrapper clearfix">
		<!-- =================================== -->
		<!-- Different data widgets ============ -->
		<!-- =================================== -->

    <div class="widget-list widget-list-full-width my-0 pd-t-30 bg-color-scheme row">
      <div class="widget-holder text-inverse text-center col-md-6">
        <div class="widget-bg-transparent">
          <div class="widget-body">
            <h3 class="mt-0 mb-2">Welcome back, <span>Scott</span></h3>
            <p class="fs-15"><span class="opacity-05">Job listings are just $99 for 30 days, for a limited time.</span> <a href="#" class="text-underline">Post a job now</a></p>


            <div class="row">
              <div class="col-sm-6">
                <div class="icon-box icon-box-centered px-2 text-center pt-2">
                  <header>
                    <a href="#"><i class="linea-basic-anchor fs-50 color-primary"></i></a>
                  </header>
                  <section class="mt-0">
                    <h6 class="icon-box-title fs-base fw-700 mt-2">Connect. Find. Be Found.</h6>
                    <p class="text-muted">Build your professional identity online and stay in touch with colleagues.</p>
                  </section>
                </div><!-- /.icon-box -->
              </div><!-- /.col-sm-6 -->

              <div class="col-sm-6">
                <div class="icon-box icon-box-centered px-2 text-center pt-2">
                  <header>
                    <a href="#"><i class="linea-basic-book-pencil fs-50 color-primary"></i></a>
                  </header>
                  <section class="mt-0">
                    <h6 class="icon-box-title fs-base fw-700 mt-2">Learn and Share</h6>
                    <p class="text-muted">Get the latest news, inspirations and insights from the experts.</p>
                  </section>
                </div><!-- /.icon-box -->
              </div><!-- /.col-sm-6 -->
            </div><!-- /.row -->
          </div><!-- /.widget-body -->
        </div><!-- /.widget-bg -->
      </div><!-- /.widget-holder -->

      <div class="widget-holder widget-flex widget-no-padding col-md-6 pr-3">
        <div class="widget-bg-transparent">
          <div class="widget-body">
            <div class="flex-1 d-flex align-items-center">
              <div class="lightbox pos-relative align-self-center">
                <a href="https://www.youtube.com/watch?v=mxxIloURtoU" class="mfp-iframe" data-toggle="lightbox" data-type="iframe">
                  <img src="assets/demo/jobs-map.png" alt="Thumb 1" />
                  <i class="feather feather-play size-icon-50 text-center radius-full border-all bw-2 border-primary pos-absolute absolute-center color-primary fs-20"></i>
                </a>
              </div><!-- /.lightbox -->
            </div><!-- /.d-flex -->
          </div><!-- /.widget-body -->
        </div><!-- /.widget-bg -->
      </div><!-- /.widget-holder -->
    </div><!-- /.widget-list -->

    <div class="tabs tabs-page">
      <ul class="nav nav-tabs d-flex justify-content-center bg-color-scheme neg-wrapper-padding">
        <li class="nav-item"><a href="#jobs-board" class="nav-link active" data-toggle="tab" aria-expanded="true">Job Boards</a></li>
        <li class="nav-item"><a href="#jobs-board" class="nav-link" data-toggle="tab" aria-expanded="false">Pricing</a></li>
        <li class="nav-item"><a href="#jobs-board" class="nav-link" data-toggle="tab" aria-expanded="false">Enterprise</a></li>
      </ul>

      <div class="tab-content px-0 pb-0 pt-4 bg-none">
        <div class="tab-pane active" id="jobs-board" aria-expanded="true">
          <div class="widget-list row">

            <div class="widget-holder widget-sm widget-border-radius col-md-3">
              <div class="widget-bg">
                <div class="widget-heading">
                  <span class="widget-title my-0 fs-12 fw-600">ICT Job in Digital Economy</span>
                  <i class="widget-heading-icon feather feather-box"></i>
                </div><!-- /.widget-heading -->
                <div class="widget-body">

                  <div class="counter-w-info">
                    <div class="counter-title color-color-scheme">
                      <span class="counter">397</span>k
                    </div><!-- /.counter-title -->

                    <div class="counter-info">
                      <span class="badge bg-success-contrast">
                        <i class="feather feather-arrow-up"></i>
                        23% increase
                      </span>
                      in Ontario
                    </div><!-- /.counter-info -->
                  </div><!-- /.counter-w-info -->

                </div><!-- /.widget-body -->
              </div><!-- /.widget-bg -->
            </div><!-- /.widget-holder -->

            <div class="widget-holder widget-sm widget-border-radius col-md-3">
              <div class="widget-bg">
                <div class="widget-heading">
                  <span class="widget-title my-0 fs-12 fw-600">Average Earnings</span>
                  <i class="widget-heading-icon feather feather-briefcase"></i>
                </div><!-- /.widget-heading -->
                <div class="widget-body">

                  <div class="counter-w-info">
                    <div class="counter-title color-color-scheme">
                      &dollar;<span class="counter">76</span>K
                    </div><!-- /.counter-title -->

                    <div class="counter-info">
                      <span class="badge bg-danger-contrast">
                        <i class="feather feather-arrow-down"></i>
                        6% decrease
                      </span>
                      of an ICT worker
                    </div><!-- /.counter-info -->
                  </div><!-- /.counter-w-info -->

                </div><!-- /.widget-body -->
              </div><!-- /.widget-bg -->
            </div><!-- /.widget-holder -->

            <div class="widget-holder widget-sm widget-border-radius col-md-3">
              <div class="widget-bg">
                <div class="widget-heading">
                  <span class="widget-title my-0 fs-12 fw-600">Share in GDP</span>
                  <i class="widget-heading-icon feather feather-anchor"></i>
                </div><!-- /.widget-heading -->
                <div class="widget-body">

                  <div class="counter-w-info">
                    <div class="counter-title">
                      <div class="d-flex justify-content-center align-items-end">
                        <div data-toggle="circle-progress"
                             data-start-angle="30"
                             data-thickness="6"
                             data-size="40"
                             data-value="0.58"
                             data-line-cap="round"
                             data-empty-fill="#E2E2E2"
                             data-fill='{"gradient": ["#40E4C2", "#0087FF"], "gradientAngle": -90}'>
                        </div>
                        <span class="counter ml-3">5.3</span>%
                      </div><!-- /.d-flex -->
                    </div><!-- /.counter-title -->

                    <div class="counter-info">
                      <span class="badge bg-success-contrast">
                        <i class="feather feather-arrow-up"></i>
                        5% increase
                      </span>
                    </div><!-- /.counter-info -->
                  </div><!-- /.counter-w-info -->

                </div><!-- /.widget-body -->
              </div><!-- /.widget-bg -->
            </div><!-- /.widget-holder -->

            <div class="widget-holder widget-sm widget-border-radius col-md-3">
              <div class="widget-bg">
                <div class="widget-heading">
                  <span class="widget-title my-0 fs-12 fw-600">Venture Capital</span>
                  <i class="widget-heading-icon feather feather-zap"></i>
                </div><!-- /.widget-heading -->
                <div class="widget-body">

                  <div class="counter-w-info">
                    <div class="counter-title">
                      <div class="d-flex justify-content-center align-items-baseline">
                        <span data-toggle="sparklines"
                              sparkHeight="25"
                              sparkType="bar"
                              sparkChartRangeMin="0"
                              sparkBarSpacing="3"
                              sparkBarColor="#947AE8"
                              sparkBarColor="red">
                              <!-- 2,4,5,3,2,3,5 -->
                        </span>
                        <span class="align-bottom ml-2 ml-0-rtl mr-2-rtl">
                          $<span class="counter">541</span>m
                        </span>
                      </div><!-- /.d-flex -->
                    </div><!-- /.counter-title -->

                    <div class="counter-info">
                      <span class="badge bg-success-contrast">
                        <i class="feather feather-arrow-up"></i>
                        5% increase
                      </span>
                      in funding
                    </div><!-- /.counter-info -->
                  </div><!-- /.counter-w-info -->

                </div><!-- /.widget-body -->
              </div><!-- /.widget-bg -->
            </div><!-- /.widget-holder -->

          </div><!-- /.widget-list -->

          <hr />

          <div class="widget-list row">
            <div class="widget-holder col-md-8">
              <div class="widget-bg">
                <div class="widget-heading widget-heading-border">
                  <h5 class="widget-title">Featured Jobs</h5>
                  <div class="widget-actions">
                    <a href="#" class="badge bg-info-contrast px-3">See All Jobs</a>
                  </div><!-- /.widget-actions -->
                </div><!-- /.widget-heading -->
                <div class="widget-body">
                  <div class="featured-jobs">
                    <div class="job-single row border-bottom pb-4 hover-parent">
                      <div class="col-sm-9">
                        <div class="media">
                          <figure class="thumb-xs2 mr-4 mr-0-rtl ml-4-rtl">
                            <img src="assets/demo/users/user2.jpg" class="rounded-circle" alt="User 1" />
                          </figure>
                          <div class="media-body">
                            <h6 class="fs-base mt-2 mb-2 fw-semibold">Web Engineer</h6>
                            <ul class="list-unstyled list-inline text-muted fs-13 mb-3">
                              <li class="list-inline-item mr-4 mr-0-rtl ml-4-rtl"><i class="feather feather-user-plus fs-base mr-1"></i> Robinhood</li>
                              <li class="list-inline-item mr-4 mr-0-rtl ml-4-rtl"><i class="feather feather-map-pin fs-base mr-1"></i> San Fransisco, CA</li>
                            </ul>

                            <div>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">ReactJS</a>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">Redux</a>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">Immutable.js</a>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">SCSS</a>
                            </div>
                          </div><!-- /.media-body -->
                        </div><!-- /.media -->
                      </div><!-- /.col-sm-9 -->

                      <div class="col-md-3 d-flex flex-column align-items-center align-items-md-end">
                        <span class="h4 my-3 color-color-scheme">$120K</span>
                        <span class="flex-1"></span>
                        <ul class="list-unstyled list-inline hover-item animated fadeInLeft mb-0">
                          <li class="list-inline-item"><a href="#" class="text-muted color-hover-color-scheme fs-20"><i class="feather feather-external-link"></i></a></li>
                          <li class="list-inline-item"><a href="#" class="text-muted color-hover-color-scheme fs-20"><i class="feather feather-star"></i></a></li>
                          <li class="list-inline-item"><a href="#" class="text-muted color-hover-color-scheme fs-20"><i class="feather feather-thumbs-up"></i></a></li>
                        </ul>
                      </div><!-- /.col-sm-3 -->
                    </div><!-- /.job-single -->

                    <div class="job-single row border-bottom pt-3 pb-4 hover-parent">
                      <div class="col-sm-9">
                        <div class="media">
                          <figure class="thumb-xs2 mr-4 mr-0-rtl ml-4-rtl">
                            <img src="assets/demo/users/user2.jpg" class="rounded-circle" alt="User 1" />
                          </figure>
                          <div class="media-body">
                            <h6 class="fs-base mt-2 mb-2 fw-semibold">Senior Web Applications Engineer</h6>
                            <ul class="list-unstyled list-inline text-muted fs-13 mb-3">
                              <li class="list-inline-item mr-4 mr-0-rtl ml-4-rtl"><i class="feather feather-user-plus fs-base mr-1"></i> Glint</li>
                              <li class="list-inline-item mr-4 mr-0-rtl ml-4-rtl"><i class="feather feather-map-pin fs-base mr-1"></i> Redwood City, CA</li>
                            </ul>

                            <div>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">ReactJS</a>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">Redux</a>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">Immutable.js</a>
                            </div>
                          </div><!-- /.media-body -->
                        </div><!-- /.media -->
                      </div><!-- /.col-sm-9 -->

                      <div class="col-md-3 d-flex flex-column align-items-center align-items-md-end">
                        <span class="h4 my-3 color-color-scheme">$150K</span>
                        <span class="flex-1"></span>
                        <ul class="list-unstyled list-inline hover-item animated fadeInLeft mb-0">
                          <li class="list-inline-item"><a href="#" class="text-muted color-hover-color-scheme fs-20"><i class="feather feather-external-link"></i></a></li>
                          <li class="list-inline-item"><a href="#" class="text-muted color-hover-color-scheme fs-20"><i class="feather feather-star"></i></a></li>
                          <li class="list-inline-item"><a href="#" class="text-muted color-hover-color-scheme fs-20"><i class="feather feather-thumbs-up"></i></a></li>
                        </ul>
                      </div><!-- /.col-sm-3 -->
                    </div><!-- /.job-single -->

                    <div class="job-single row border-bottom pt-3 pb-4 hover-parent">
                      <div class="col-sm-9">
                        <div class="media">
                          <figure class="thumb-xs2 mr-4 mr-0-rtl ml-4-rtl">
                            <img src="assets/demo/users/user2.jpg" class="rounded-circle" alt="User 1" />
                          </figure>
                          <div class="media-body">
                            <h6 class="fs-base mt-2 mb-2 fw-semibold">Front End Web Developer</h6>
                            <ul class="list-unstyled list-inline text-muted fs-13 mb-3">
                              <li class="list-inline-item mr-4 mr-0-rtl ml-4-rtl"><i class="feather feather-user-plus fs-base mr-1"></i> Perfect World Entertainment</li>
                              <li class="list-inline-item mr-4 mr-0-rtl ml-4-rtl"><i class="feather feather-map-pin fs-base mr-1"></i> Redwood City, CA</li>
                            </ul>

                            <div>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">ReactJS</a>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">Redux</a>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">SCSS</a>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">Immutable.js</a>
                            </div>
                          </div><!-- /.media-body -->
                        </div><!-- /.media -->
                      </div><!-- /.col-sm-9 -->

                      <div class="col-md-3 d-flex flex-column align-items-center align-items-md-end">
                        <span class="h4 my-3 color-color-scheme">$93K</span>
                        <span class="flex-1"></span>
                        <ul class="list-unstyled list-inline hover-item animated fadeInLeft mb-0">
                          <li class="list-inline-item"><a href="#" class="text-muted color-hover-color-scheme fs-20"><i class="feather feather-external-link"></i></a></li>
                          <li class="list-inline-item"><a href="#" class="text-muted color-hover-color-scheme fs-20"><i class="feather feather-star"></i></a></li>
                          <li class="list-inline-item"><a href="#" class="text-muted color-hover-color-scheme fs-20"><i class="feather feather-thumbs-up"></i></a></li>
                        </ul>
                      </div><!-- /.col-sm-3 -->
                    </div><!-- /.job-single -->

                    <div class="job-single row border-bottom pt-3 pb-4 hover-parent">
                      <div class="col-sm-9">
                        <div class="media">
                          <figure class="thumb-xs2 mr-4 mr-0-rtl ml-4-rtl">
                            <img src="assets/demo/users/user2.jpg" class="rounded-circle" alt="User 1" />
                          </figure>
                          <div class="media-body">
                            <h6 class="fs-base mt-2 mb-2 fw-semibold">Web Engineer - Web Team</h6>
                            <ul class="list-unstyled list-inline text-muted fs-13 mb-3">
                              <li class="list-inline-item mr-4 mr-0-rtl ml-4-rtl"><i class="feather feather-user-plus fs-base mr-1"></i> Zendesk</li>
                              <li class="list-inline-item mr-4 mr-0-rtl ml-4-rtl"><i class="feather feather-map-pin fs-base mr-1"></i> San Fransisco, CA</li>
                            </ul>

                            <div>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">ReactJS</a>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">SCSS</a>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">Immutable.js</a>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">Photoshop</a>
                            </div>
                          </div><!-- /.media-body -->
                        </div><!-- /.media -->
                      </div><!-- /.col-sm-9 -->

                      <div class="col-md-3 d-flex flex-column align-items-center align-items-md-end">
                        <span class="h4 my-3 color-color-scheme">$130K</span>
                        <span class="flex-1"></span>
                        <ul class="list-unstyled list-inline hover-item animated fadeInLeft mb-0">
                          <li class="list-inline-item"><a href="#" class="text-muted color-hover-color-scheme fs-20"><i class="feather feather-external-link"></i></a></li>
                          <li class="list-inline-item"><a href="#" class="text-muted color-hover-color-scheme fs-20"><i class="feather feather-star"></i></a></li>
                          <li class="list-inline-item"><a href="#" class="text-muted color-hover-color-scheme fs-20"><i class="feather feather-thumbs-up"></i></a></li>
                        </ul>
                      </div><!-- /.col-sm-3 -->
                    </div><!-- /.job-single -->

                    <div class="job-single row pt-3 hover-parent">
                      <div class="col-sm-9">
                        <div class="media">
                          <figure class="thumb-xs2 mr-4 mr-0-rtl ml-4-rtl">
                            <img src="assets/demo/users/user2.jpg" class="rounded-circle" alt="User 1" />
                          </figure>
                          <div class="media-body">
                            <h6 class="fs-base mt-2 mb-2 fw-semibold">Web Developer</h6>
                            <ul class="list-unstyled list-inline text-muted fs-13">
                              <li class="list-inline-item mr-4 mr-0-rtl ml-4-rtl"><i class="feather feather-user-plus fs-base mr-1"></i> Planet</li>
                              <li class="list-inline-item mr-4 mr-0-rtl ml-4-rtl"><i class="feather feather-map-pin fs-base mr-1"></i> San Fransisco, CA</li>
                            </ul>

                            <div>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">ReactJS</a>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">SCSS</a>
                              <a href="#" class="badge bg-success-contrast px-3 py-2 mb-1">Redux</a>
                            </div>
                          </div><!-- /.media-body -->
                        </div><!-- /.media -->
                      </div><!-- /.col-sm-9 -->

                      <div class="col-md-3 d-flex flex-column align-items-center align-items-md-end">
                        <span class="h4 my-3 color-color-scheme">$123K</span>
                        <span class="flex-1"></span>
                        <ul class="list-unstyled list-inline hover-item animated fadeInLeft mb-0">
                          <li class="list-inline-item"><a href="#" class="text-muted color-hover-color-scheme fs-20"><i class="feather feather-external-link"></i></a></li>
                          <li class="list-inline-item"><a href="#" class="text-muted color-hover-color-scheme fs-20"><i class="feather feather-star"></i></a></li>
                          <li class="list-inline-item"><a href="#" class="text-muted color-hover-color-scheme fs-20"><i class="feather feather-thumbs-up"></i></a></li>
                        </ul>
                      </div><!-- /.col-sm-3 -->
                    </div><!-- /.job-single -->
                  </div><!-- /.featured-jobs -->
                </div><!-- /.widget-body -->
              </div><!-- /.widget-bg -->
            </div><!-- /.widget-holder -->

            <div class="col-md-4">
              <div class="widget-holder widget-no-padding">
                <div class="widget-bg">
                  <div class="widget-body">
                    <div class="d-flex flex-column align-items-center text-center">
                      <h5 class="mx-5 mr-t-40 mb-3">Build Your Resume</h5>
                      <p class="headings-font-family text-muted mx-5 mb-4">Use our resume/cv builder to quickly create a resume that stands out and gets you more employers</p>
                      <a href="#" class="btn btn-outline-color-scheme btn-lg btn-rounded px-5 text-uppercase fs-12 fw-700 mb-5">Get Started</a>
                      <figure class="w-100" style="background-image: url(assets/demo/job-board-bg.png); background-size: cover">
                        <img class="opacity-0" src="assets/demo/job-board-bg.png" alt="bg" />
                      </figure>
                    </div><!-- /.d-flex -->
                  </div><!-- /.widget-body -->
                </div><!-- /.widget-bg -->
              </div><!-- /.widget-holder -->

              <div class="widget-holder widget-full-height widget-no-padding widget-flex">
                <div class="widget-bg bg-facebook color-white radius-5">
                  <div class="widget-body">
                    <div class="facebook-widget flex-1" data-plugin-options='{"user": "envato", "limit": 3}'></div>
                  </div><!-- /.widget-body -->
                </div><!-- /.widget-bg -->
              </div><!-- /.widget-holder -->

              <div class="widget-holder widget-full-height widget-no-padding widget-flex">
                <div class="widget-bg bg-twitter color-white radius-5">
                  <div class="widget-body">
                    <div class="twitter-widget flex-1" data-plugin-options='{"screen_name": "elonmusk", "count": 3}'></div>
                  </div><!-- /.widget-body -->
                </div><!-- /.widget-bg -->
              </div><!-- /.widget-holder -->
            </div><!-- /.col-sm-4 -->
          </div><!-- /.widget-list -->

          <div class="title-seperator">
            <span class="h6 fs-15 fw-700 text-uppercase headings-color" style="letter-spacing: .05em;">Top Employers</span>
          </div><!-- /.title-seperator -->

          <div class="widget-list row">
            <div class="widget-holder widget-no-padding col">
              <div class="widget-bg-transparent">
                <div class="widget-body">
                  <div class="carousel row" data-slick='{"slidesToShow": 3, "slidesToScroll": 3, "autoplay": true }'>
                    <?php for( $i = 0; $i < 3; $i++ ): ?>
                    <div class="employer bg-white d-flex flex-column align-items-center text-center border-all bw-4 px-4 py-5 mx-1 col-md-4">
                      <figure class="mb-4">
                        <img src="assets/demo/slack-logo.png" alt="Slack" />
                      </figure>
                      <p class="text-muted headings-font-family">Slack is a cloud-based set of team collaboration tools and services, founded by Stewart Butterfield.</p>
                      <a href="#" class="btn btn-link headings-letter-spacing text-uppercase fw-bold">Read More</a>
                    </div><!-- /.employer -->

                    <div class="employer bg-white d-flex flex-column align-items-center text-center border-all bw-4 px-4 py-5 mx-1 col-md-4">
                      <figure class="mb-4">
                        <img src="assets/demo/xbox-logo.png" alt="XBox One" />
                      </figure>
                      <p class="text-muted headings-font-family">Xbox One is in the line of the eighth generation home video game consoles developed by Microsoft</p>
                      <a href="#" class="btn btn-link headings-letter-spacing text-uppercase fw-bold">Read More</a>
                    </div><!-- /.employer -->

                    <div class="employer bg-white d-flex flex-column align-items-center text-center border-all bw-4 px-4 py-5 mx-1 col-md-4">
                      <figure class="mb-4">
                        <img src="assets/demo/airbnb-logo.png" alt="AirBnb" />
                      </figure>
                      <p class="text-muted headings-font-family">AirBnb is an online marketplace and hospitality service, enabling people to lease or rent short term lodging.</p>
                      <a href="#" class="btn btn-link headings-letter-spacing text-uppercase fw-bold">Read More</a>
                    </div><!-- /.employer -->
                    <?php endfor; ?>
                  </div><!-- /.carousel -->
                </div><!-- /.widget-body -->
              </div><!-- /. widget-bg-transparent -->
            </div><!-- /.widget-holder -->
          </div><!-- /.widget-listings -->
        </div><!-- /.tab-pane -->
        <div class="tab-pane" id="pricing" aria-expanded="false">
          <p>Pricing</p>
        </div><!-- /.tab-pane -->
        <div class="tab-pane" id="enterprises" aria-expanded="false">
          <p>Enterprises</p>
        </div><!-- /.tab-pane -->
      </div><!-- /.tab-content -->
    </div><!-- /.tabs -->
	</main><!-- /.main-wrappper -->

	<?php get_template_part('partials/right-sidebar') ?>
</div><!-- /.content-wrapper -->

<?php get_footer();
