<?php
include_once 'lib/init.php';

$config = array(
	'title' => 'List Groups',
	'body_class' =>  $GLOBALS['body_class'] . '',
  'styles' => array(
    'nestable',
  ),
	'scripts' => array(
    'jqueryui',
    'nestable',
	),
);

get_header($config);
?>

<div class="content-wrapper">
	<?php get_template_part( $GLOBALS['sidebar_file'] ) ?>

	<main class="main-wrapper clearfix">

		<?php get_page_title($config); ?>

		<!-- =================================== -->
		<!-- Different data widgets ============ -->
		<!-- =================================== -->
		<div class="widget-list">
			<div class="row">

				<div class="col-md-12 widget-holder">
					<div class="widget-bg-transparent">
						<div class="widget-body clearfix">
							<h5 class="box-title">Sortable List <small>(drag to sort)</small></h5>

							<ol class="list-group sortable">
	              <li class="list-group-item bg-color-scheme text-inverse d-flex">
                  <div class="mr-auto mr-0-rtl ml-auto-rtl">
										<i class="material-icons list-icon">swap_vert</i>
										Browser compatibility
									</div>

									<div>
										<a href="javascript:void(0);"><i class="material-icons list-icon">add</i></a>
										<a href="javascript:void(0);"><i class="material-icons list-icon">edit</i></a>
										<a href="javascript:void(0);"><i class="material-icons list-icon">close</i></a>
									</div>
	              </li>

								<li class="list-group-item bg-info text-inverse d-flex">
									<div class="mr-auto mr-0-rtl ml-auto-rtl">
										<i class="material-icons list-icon">swap_vert</i>
										Looking for more examples templates
									</div>

									<div>
										<a href="javascript:void(0);"><i class="material-icons list-icon">add</i></a>
										<a href="javascript:void(0);"><i class="material-icons list-icon">edit</i></a>
										<a href="javascript:void(0);"><i class="material-icons list-icon">close</i></a>
									</div>
	              </li>

								<li class="list-group-item d-flex">
									<div class="mr-auto mr-0-rtl ml-auto-rtl">
										<i class="material-icons list-icon">swap_vert</i>
										The fastest way to get started
									</div>

									<div>
										<a href="javascript:void(0);"><i class="material-icons list-icon">add</i></a>
										<a href="javascript:void(0);"><i class="material-icons list-icon">edit</i></a>
										<a href="javascript:void(0);"><i class="material-icons list-icon">close</i></a>
									</div>
	              </li>
							</ol><!-- /.list-group -->

						</div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-12 widget-holder">
					<div class="widget-bg-transparent">
						<div class="widget-body clearfix">
							<h5 class="box-title">Nested Sortable List <small>(drag to sort)</small></h5>

	            <div class="row">
	              <div class="col-md-6">

	                <div class="dd">
	                  <ol class="dd-list">
	                    <li class="dd-item" data-id="13">
	                      <div class="dd-handle">Item 13</div>
	                    </li>
	                    <li class="dd-item" data-id="14">
	                      <div class="dd-handle">Item 14</div>
	                    </li>
	                    <li class="dd-item" data-id="15">
	                      <div class="dd-handle">Item 15</div>
	                      <ol class="dd-list">
	                        <li class="dd-item" data-id="16">
	                          <div class="dd-handle">Item 16</div>
	                        </li>
	                        <li class="dd-item" data-id="17">
	                          <div class="dd-handle">Item 17</div>
	                        </li>
	                        <li class="dd-item" data-id="18">
	                          <div class="dd-handle">Item 18</div>
	                        </li>
	                      </ol>
	                    </li>
	                  </ol>
	                </div><!-- /.div -->

	              </div><!-- /.col-md-6 -->

	              <div class="col-md-6">

	                <div class="dd">
	                  <ol class="dd-list">
	                    <li class="dd-item dd3-item" data-id="13">
	                      <div class="dd-handle dd3-handle"></div>
	                      <div class="dd3-content">Item 13</div>
	                    </li>
	                    <li class="dd-item dd3-item" data-id="14">
	                      <div class="dd-handle dd3-handle"></div>
	                      <div class="dd3-content">Item 14</div>
	                    </li>
	                    <li class="dd-item dd3-item" data-id="15">
	                      <div class="dd-handle dd3-handle"></div>
	                      <div class="dd3-content">Item 15</div>
	                      <ol class="dd-list">
	                        <li class="dd-item dd3-item" data-id="16">
	                          <div class="dd-handle dd3-handle"></div>
	                          <div class="dd3-content">Item 16</div>
	                        </li>
	                        <li class="dd-item dd3-item" data-id="17">
	                          <div class="dd-handle dd3-handle"></div>
	                          <div class="dd3-content">Item 17</div>
	                        </li>
	                        <li class="dd-item dd3-item" data-id="18">
	                          <div class="dd-handle dd3-handle"></div>
	                          <div class="dd3-content">Item 18</div>
	                        </li>
	                      </ol>
	                    </li>
	                  </ol>
	                </div><!-- /.dd -->

	              </div><!-- /.col-md-6 -->
	            </div><!-- /.row -->

						</div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-6 widget-holder">
					<div class="widget-bg-transparent">
	          <div class="widget-body clearfix">
							<h5 class="box-title">Basic List</h5>

							<div class="list-group">
	              <a href="#" class="list-group-item list-group-item-action d-flex justify-content-end">
									<span class="mr-auto mr-0-rtl ml-auto-rtl"><i class="feather feather-mail icon icon-muted mr-2"></i>Inbox</span>
									<span class="badge badge-pill bg-danger-contrast fs-12 mr-1 my-auto">201</span>
	                <i class="feather feather-chevron-right icon icon-muted my-auto"></i>
	              </a>

	              <a href="#" class="list-group-item list-group-item-action d-flex justify-content-end">
									<span class="mr-auto mr-0-rtl ml-auto-rtl"><i class="feather feather-eye icon icon-muted mr-2"></i>Profile visits</span>
									<span class="badge badge-pill bg-info-contrast fs-12 mr-1 my-auto">5021</span>
	                <i class="feather feather-chevron-right icon icon-muted my-auto"></i>
	              </a>

	              <a href="#" class="list-group-item list-group-item-action d-flex justify-content-end">
									<span class="mr-auto mr-0-rtl ml-auto-rtl"><i class="feather feather-phone icon icon-muted mr-2"></i>Call</span>
									<span class="badge badge-pill bg-success-contrast fs-12 mr-1 my-auto">14</span>
	                <i class="feather feather-chevron-right icon icon-muted my-auto"></i>
	              </a>

	              <a href="#" class="list-group-item list-group-item-action d-flex justify-content-end">
									<span class="mr-auto mr-0-rtl ml-auto-rtl"><i class="feather feather-mail icon icon-muted mr-2"></i>Messages</span>
									<span class="badge badge-pill bg-color-scheme-contrast fs-12 mr-1 my-auto">20</span>
	                <i class="feather feather-chevron-right icon icon-muted my-auto"></i>
	              </a>

	              <a href="#" class="list-group-item list-group-item-action d-flex justify-content-end">
									<span class="mr-auto mr-0-rtl ml-auto-rtl"><i class="feather feather-bookmark icon icon-muted mr-2"></i>Bookmarks</span>
									<span class="badge badge-pill bg-warning-contrast fs-12 mr-1 my-auto">14</span>
	                <i class="feather feather-chevron-right icon icon-muted my-auto"></i>
	              </a>

	              <a href="#" class="list-group-item list-group-item-action d-flex justify-content-end">
									<span class="mr-auto mr-0-rtl ml-auto-rtl"><i class="feather feather-alert-circle icon icon-muted mr-2"></i>Notifications</span>
									<span class="badge badge-pill bg-info-contrast fs-12 mr-1 my-auto">30</span>
	                <i class="feather feather-chevron-right icon icon-muted my-auto"></i>
	              </a>

	              <a href="#" class="list-group-item list-group-item-action d-flex justify-content-end">
									<span class="mr-auto mr-0-rtl ml-auto-rtl"><i class="feather feather-watch icon icon-muted mr-2"></i>Watch</span>
									<span class="badge badge-pill bg-danger-contrast fs-12 mr-1 my-auto">10</span>
	                <i class="feather feather-chevron-right icon icon-muted my-auto"></i>
	              </a>
	            </div><!-- /.list-group -->

						</div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-6 widget-holder">
					<div class="widget-bg-transparent">
						<div class="widget-body clearfix">
							<h5 class="box-title">Media Boxes</h5>

							<section class="card">
	              <header class="card-header">
	                <div class="input-group">
	                  <input type="text" class="form-control form-control-md" placeholder="Search">
	                  <div class="input-group-btn">
	                    <button type="button" class="btn btn-default dropdown-toggle fs-12" data-toggle="dropdown">Action <span class="caret"></span></button>
	                    <ul class="dropdown-menu dropdown-menu-right">
	                      <li><a class="dropdown-item" href="#">Action</a></li>
	                      <li><a class="dropdown-item" href="#">Another action</a></li>
	                      <li><a class="dropdown-item" href="#">Something else here</a></li>
	                      <li class="dropdown-divider"></li>
	                      <li><a class="dropdown-item" href="#">Separated link</a></li>
	                    </ul>
	                  </div>
	                </div>
	              </header><!-- /.card-header -->

								<ul class="list-unstyled widget-user-list card-body">
									<li class="media">
										<div class="d-flex mr-3 mr-0-rtl ml-3-rtl">
											<a href="#" class="user--online thumb-xs">
												<img src="assets/demo/users/user1.jpg" class="rounded-circle" alt="">
											</a>
										</div>

										<div class="media-body">
											<a href="#" class="btn btn-outline-default float-left-rtl">Follow</a>
											<h5 class="media-heading">
												<a href="#">Nick Lampard</a>
												<small>@kingnick24</small>
											</h5>
										</div>
									</li>

									<li class="media">
										<div class="d-flex mr-3 mr-0-rtl ml-3-rtl">
											<a href="#" class="user--busy thumb-xs">
												<img src="assets/demo/users/user2.jpg" class="rounded-circle" alt="">
											</a>
										</div>

										<div class="media-body">
											<a href="#" class="btn btn-success float-left-rtl">Following</a>
											<h5 class="media-heading">
												<a href="#">Ashley Wilson</a>
												<small>@AshWilson123</small>
											</h5>
										</div>
									</li>

									<li class="media">
										<div class="d-flex mr-3 mr-0-rtl ml-3-rtl">
											<a href="#" class="user--online thumb-xs">
												<img src="assets/demo/users/user3.jpg" class="rounded-circle" alt="">
											</a>
										</div>

										<div class="media-body">
											<a href="#" class="btn btn-outline-default float-left-rtl">Follow</a>
											<h5 class="media-heading">
												<a href="#">Shannon Wang Lee</a>
												<small>@Shalee_42</small>
											</h5>
										</div>
									</li>
								</ul>
	            </section><!-- /.card -->

						</div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

			</div><!-- /.row -->
		</div><!-- /.widget-list -->
	</main><!-- /.main-wrappper -->

	<?php get_template_part('partials/right-sidebar') ?>
</div><!-- /.content-wrapper -->

<?php get_footer();
