<?php
include_once 'lib/init.php';

$config = array(
	'title' => 'Pricing Table',
	'body_class' => $GLOBALS['body_class'] . ''
);

get_header($config);
?>

<div class="content-wrapper">
	<?php get_template_part( $GLOBALS['sidebar_file'] ) ?>

	<main class="main-wrapper clearfix">

		<?php get_page_title($config); ?>

		<!-- =================================== -->
		<!-- Different data widgets ============ -->
		<!-- =================================== -->
		<div class="widget-list">
			<div class="row">

				<div class="col-md-12 widget-holder">
					<div class="widget-bg-transparent">

			      <div class="widget-body clearfix">

							<div class="row m-0">

								<div class="col-12 col-md-4">
									<div class="pricing-box">
										<header class="text-center">
											<h5 class="sub-heading-font-family mb-4">Basic</h5>
											<span class="h6 heading-basic text-info rounded-circle sub-heading-font-family align-middle">Free</span>
										</header><hr />
										<div class="pricing-box-content px-5">
											<h6 class="text-center pt-2">Groundwork to stay organized</h6>
											<ul class="list-unstyled mt-4">
												<li class="d-flex">
													<i class="material-icons list-icons text-success mr-2 mr-0-rtl ml-2-rtl">check</i>
													<span>Payback and record offline payment</span>
												</li>
												<li class="d-flex">
													<i class="material-icons list-icons text-success mr-2 mr-0-rtl ml-2-rtl">check</i>
													<span>Setup custom payment plans</span>
												</li>
												<li class="d-flex">
													<i class="material-icons list-icons text-success mr-2 mr-0-rtl ml-2-rtl">check</i>
													<span>Weekly collection reports</span>
												</li>
												<li class="d-flex">
													<i class="material-icons list-icons text-success mr-2 mr-0-rtl ml-2-rtl">check</i>
													<span>Export you data anytime</span>
												</li>
												<li class="d-flex">
													<i class="material-icons list-icons text-success mr-2 mr-0-rtl ml-2-rtl">check</i>
													<span>Automatic Payment</span>
												</li>
											</ul>
											<div class="text-center">
												<a href="#" class="btn btn-lg btn-outline-info py-3">Buy Now</a>
											</div>
										</div>
									</div><!-- /.pricing-box -->
				        </div><!-- /.col-md-3 -->

								<div class="col-12 col-md-4">
									<div class="pricing-box featured-pricing-box">
										<header class="text-center">
											<h5 class="mb-4 sub-heading-font-family">Pay As You Go</h5>
											<span class="h2 heading-featured sub-heading-font-family rounded-circle text-success">2%</span>
											<span class="text-success block mt-4">&#43; 30&#8364; per transaction</span>
											<div class="triangle-top-right"></div>
										</header><hr />
										<div class="pricing-box-content px-5">
											<h6 class="text-center pt-4">All the features of the free plan plus:</h6>
											<ul class="list-unstyled mt-4">
												<li class="d-flex">
													<i class="material-icons list-icons text-success mr-2 mr-0-rtl ml-2-rtl">check</i>
													<span>Collect online bank and card payments</span>
												</li>
												<li class="d-flex">
													<i class="material-icons list-icons text-success mr-2 mr-0-rtl ml-2-rtl">check</i>
													<span>Let Parents pay online all upfront or enroll in autopay</span>
												</li>
												<li class="d-flex">
													<i class="material-icons list-icons text-success mr-2 mr-0-rtl ml-2-rtl">check</i>
													<span>Send automatic payment reminders</span>
												</li>
												<li class="d-flex">
													<i class="material-icons list-icons text-success mr-2 mr-0-rtl ml-2-rtl">check</i>
													<span>Send automatic signup reminders</span>
												</li>
											</ul>

											<h6 class="my-4 text-center">All extensions included<br /><small>Save more than 200&#8364;!</small></h6>
											<div class="text-center ">
												<a href="#" class="btn btn-lg btn-success py-3">Buy Now</a>
											</div>
										</div>
									</div><!-- /.pricing-box -->
				        </div><!-- /.col-md-3 -->

								<div class="col-12 col-md-4">
									<div class="pricing-box">
										<header class="text-center">
											<h5 class="sub-heading-font-family mb-4">Custom</h5>
											<span class="h6 heading-custom rounded-circle sub-heading-font-family"><i class="material-icons text-muted">mail_outline</i></span>
										</header><hr />
										<div class="pricing-box-content px-5">
											<h6 class="text-center pt-2">Groundwork to stay organized</h6>
											<ul class="list-unstyled mt-4">
												<li class="d-flex">
													<i class="material-icons list-icons text-success mr-2 mr-0-rtl ml-2-rtl">check</i>
													<span>Payback and record offline payment</span>
												</li>
												<li class="d-flex">
													<i class="material-icons list-icons text-success mr-2 mr-0-rtl ml-2-rtl">check</i>
													<span>Setup custom payment plans</span>
												</li>
												<li class="d-flex">
													<i class="material-icons list-icons text-success mr-2 mr-0-rtl ml-2-rtl">check</i>
													<span>Weekly collection reports</span>
												</li>
												<li class="d-flex">
													<i class="material-icons list-icons text-success mr-2 mr-0-rtl ml-2-rtl">check</i>
													<span>Export you data anytime</span>
												</li>
												<li class="d-flex">
													<i class="material-icons list-icons text-success mr-2 mr-0-rtl ml-2-rtl">check</i>
													<span>Automatic Payment</span>
												</li>
											</ul>
											<div class="text-center">
												<a href="#" class="btn btn-lg btn-outline-default py-3">Buy Now</a>
											</div>
										</div>
									</div><!-- /.pricing-box -->
				        </div><!-- /.col-md-3 -->

								<!-- <div class="col-12 col-md-3">
									<div class="pricing-box featured-pricing-box-2 bg-color-scheme">
										<header>
											<h5>Enterprise</h5>
											<p class="header-text">A solution for<br />professionals</p>
										</header>
										<hr class="bg-white" />
										<div class="pricing-box-content">
											<ul class="list-unstyled text-center">
												<li>Built Prices</li>
												<li>Custom Features</li>
												<li>Include your branding</li>
												<li>Private Developer Accounts</li>
											</ul>
											<a href="#" class="btn btn-lg btn-outline-default">Contact</a>
										</div>
									</div><!-- /.pricing-box -->
				        <!-- </div><!-- /.col-md-3 -->

							</div><!-- /.row -->



			      </div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

			</div><!-- /.row -->
		</div><!-- /.widget-list -->
	</main><!-- /.main-wrappper -->

	<?php get_template_part('partials/right-sidebar') ?>
</div><!-- /.content-wrapper -->

<?php get_footer();
