<?php
include_once 'lib/init.php';

$config = array(
	'title' => 'Learning Management System',
	'body_class' => $GLOBALS['body_class'] . '',
  'styles' => array(
    'mediaelement',
  ),
  'scripts' => array(
    'jquery-circle-progress',
    'mediaelement',
  )
);

get_header($config);
?>

<div class="content-wrapper">
	<?php get_template_part( $GLOBALS['sidebar_file'] ) ?>

	<main class="main-wrapper clearfix">

		<?php get_page_title($config); ?>

		<!-- =================================== -->
		<!-- Different data widgets ============ -->
		<!-- =================================== -->
		<div class="widget-list">
			<div class="row">
        <div class="col-lg-3">

          <div class="widget-holder text-inverse">
            <div class="widget-bg bg-primary">
              <div class="widget-body p-4">
                <h4 class="mt-2 mb-5 pb-3 lh-13">Microsoft MTA: <br/> Security Fundamentals</h4>
                <div class="progress progress-sm inverse radius-5 mb-2">
                  <div class="progress-bar bg-white radius-5" style="width: 60%;" role="progressbar"> <span class="sr-only">60% Complete</span> </div>
                </div><!-- /.progress -->
                <div class="d-flex headings-font-family fs-11 fw-500">
                  <span>7/28 lessons</span>
                  <div class="flex-1"></div>
                  <span><i class="feather feather-star fs-13 align-baseline"></i> 4.5</span>
                </div><!-- /.d-flex -->
              </div><!-- /.widget-body -->
            </div><!-- /.widget-bg -->
          </div><!-- /.widget-holder -->


          <div class="widget-holder">
            <div class="widget-bg-transparent">
              <div class="widget-body p-0">
                <div class="accordion widget-project-index" id="widget-project-index-1">
                  <div class="card">
                    <div class="card-header">
                      <div class="card-title">
                        <a class="d-flex align-items-center" role="button" data-toggle="collapse" data-parent="#widget-project-index-1" href="#getting-started-collapse" aria-expanded-true="true">
                          <span>
                            <span class="d-block headings-font-family headings-color fw-500 lh-1">Getting Started</span>
                            <small><i class="feather feather-clock mr-1"></i> 28 min</small>
                          </span>
                          <span class="flex-1"></span>
                          <div class="pos-relative">
                            <div data-toggle="circle-progress"
                                 data-start-angle="30"
                                 data-thickness="2"
                                 data-size="25"
                                 data-value="0.58"
                                 data-line-cap="round"
                                 data-empty-fill="#E2E2E2"
                                 data-fill='{"color": "#F46149"}' style="height: 20px; width: 20px;">
                            </div>
                            <span class="absolute-center fs-10 headings-color top-0 lh-1">1</span>
                          </div>
                        </a>
                      </div><!-- /.card-title -->
                    </div><!-- /.card-header -->

                    <div id="getting-started-collapse" class="card-collapse collapse show">
                      <div class="list-group">
                        <a href="#" class="list-group-item">
                          <i class="feather feather-video list-icon fs-11"></i>
                          <span class="headings-font-family">Module Intro<small class="fs-11">2 min</small></span>
                          <span class="flex-1"></span>
                          <i class="feather feather-check done-icon bg-primary"></i>
                        </a>

                        <a href="#" class="list-group-item active">
                          <i class="feather feather-video list-icon fs-11"></i>
                          <span class="headings-font-family">Defining threats and Risk Management<small class="fs-11">12 min</small></span>
                          <span class="flex-1"></span>
                          <div data-toggle="circle-progress"
                               data-start-angle="30"
                               data-thickness="3"
                               data-size="25"
                               data-value="0.58"
                               data-line-cap="round"
                               data-empty-fill="#E2E2E2"
                               data-fill='{"color": "#F46149"}' style="width: 25px; height: 25px;">
                          </div>
                        </a>

                        <a href="#" class="list-group-item">
                          <i class="feather feather-video list-icon fs-11"></i>
                          <span class="headings-font-family">What is Security<small class="fs-11">3 min</small></span>
                          <span class="flex-1"></span>
                        </a>

                        <a href="#" class="list-group-item">
                          <i class="feather feather-video list-icon fs-11"></i>
                          <span class="headings-font-family">Classifying Data<small class="fs-11">7 min</small></span>
                          <span class="flex-1"></span>
                        </a>

                        <a href="#" class="list-group-item">
                          <i class="feather feather-video list-icon fs-11"></i>
                          <span class="headings-font-family">Risk Categories<small class="fs-11">3 min</small></span>
                          <span class="flex-1"></span>
                        </a>
                      </div><!-- /.list-group -->
                    </div><!-- /.card-collpase -->
                  </div><!-- /.card -->

                  <div class="card">
                    <div class="card-header">
                      <div class="card-title">
                        <a class="d-flex align-items-center" role="button" data-toggle="collapse" data-parent="#widget-project-index-1" href="#authentication-basics-collapse" aria-expanded-true="false">
                          <span>
                            <span class="d-block headings-font-family headings-color fw-500 lh-1">Authentication Basics</span>
                            <small><i class="feather feather-clock mr-1"></i> 43 min</small>
                          </span>
                          <span class="flex-1"></span>
                          <div class="pos-relative">
                            <span class="count fs-11 fs-500 text-muted bg-transparent bg-none">2</span>
                          </div><!-- /.pos-relative -->
                        </a>
                      </div><!-- /.card-title -->
                    </div><!-- /.card-header -->

                    <div id="authentication-basics-collapse" class="card-collapse collapse">
                      <div class="list-group">
                        <a href="#" class="list-group-item">
                          <i class="feather feather-video list-icon fs-11"></i>
                          <span class="headings-font-family">Module Intro<small class="fs-11">2 min</small></span>
                          <span class="flex-1"></span>
                        </a>

                        <a href="#" class="list-group-item">
                          <i class="feather feather-video list-icon fs-11"></i>
                          <span class="headings-font-family">Defining threats and Risk Management<small class="fs-11">12 min</small></span>
                          <span class="flex-1"></span>
                        </a>
                      </div><!-- /.list-group -->
                    </div><!-- /.card-collpase -->
                  </div><!-- /.card -->

                  <div class="card">
                    <div class="card-header">
                      <div class="card-title">
                        <a class="d-flex align-items-center" role="button" data-toggle="collapse" data-parent="#widget-project-index-1" href="#securing-via-ntfs-collapse" aria-expanded-true="false">
                          <span>
                            <span class="d-block headings-font-family headings-color fw-500 lh-1">Securing files via NTFS</span>
                            <small><i class="feather feather-clock mr-1"></i> 55 min</small>
                          </span>
                          <span class="flex-1"></span>
                          <div class="pos-relative">
                            <span class="count fs-11 fs-500 text-muted bg-transparent bg-none">3</span>
                          </div><!-- /.pos-relative -->
                        </a>
                      </div><!-- /.card-title -->
                    </div><!-- /.card-header -->

                    <div id="securing-via-ntfs-collapse" class="card-collapse collapse">
                      <div class="list-group">
                        <a href="#" class="list-group-item">
                          <i class="feather feather-video list-icon fs-11"></i>
                          <span class="headings-font-family">Module Intro<small class="fs-11">2 min</small></span>
                          <span class="flex-1"></span>
                        </a>

                        <a href="#" class="list-group-item">
                          <i class="feather feather-video list-icon fs-11"></i>
                          <span class="headings-font-family">Defining threats and Risk Management<small class="fs-11">12 min</small></span>
                          <span class="flex-1"></span>
                        </a>

                        <a href="#" class="list-group-item">
                          <i class="feather feather-video list-icon fs-11"></i>
                          <span class="headings-font-family">Risk Categories<small class="fs-11">3 min</small></span>
                          <span class="flex-1"></span>
                        </a>
                      </div><!-- /.list-group -->
                    </div><!-- /.card-collpase -->
                  </div><!-- /.card -->

                  <div class="card">
                    <div class="card-header">
                      <div class="card-title">
                        <a class="d-flex align-items-center" role="button" data-toggle="collapse" data-parent="#widget-project-index-1" href="#sharing-drives-and-folders-collapse" aria-expanded-true="false">
                          <span>
                            <span class="d-block headings-font-family headings-color fw-500 lh-1">Sharing Drives and folders</span>
                            <small><i class="feather feather-clock mr-1"></i> 27 min</small>
                          </span>
                          <span class="flex-1"></span>
                          <div class="pos-relative">
                            <span class="count fs-11 fs-500 text-muted bg-transparent bg-none">4</span>
                          </div><!-- /.pos-relative -->
                        </a>
                      </div><!-- /.card-title -->
                    </div><!-- /.card-header -->

                    <div id="sharing-drives-and-folders-collapse" class="card-collapse collapse">
                      <div class="list-group">
                        <a href="#" class="list-group-item">
                          <i class="feather feather-video list-icon fs-11"></i>
                          <span class="headings-font-family">Module Intro<small class="fs-11">2 min</small></span>
                          <span class="flex-1"></span>
                        </a>

                        <a href="#" class="list-group-item">
                          <i class="feather feather-video list-icon fs-11"></i>
                          <span class="headings-font-family">Defining threats and Risk Management<small class="fs-11">12 min</small></span>
                          <span class="flex-1"></span>
                        </a>
                      </div><!-- /.list-group -->
                    </div><!-- /.card-collpase -->
                  </div><!-- /.card -->

                  <div class="card">
                    <div class="card-header">
                      <div class="card-title">
                        <a class="d-flex align-items-center" role="button" data-toggle="collapse" data-parent="#widget-project-index-1" href="#protecting-servers-collapse" aria-expanded-true="false">
                          <span>
                            <span class="d-block headings-font-family headings-color fw-500 lh-1">Protecting Servers</span>
                            <small><i class="feather feather-clock mr-1"></i> 27 min</small>
                          </span>
                          <span class="flex-1"></span>
                          <div class="pos-relative">
                            <span class="count fs-11 fs-500 text-muted bg-transparent bg-none">5</span>
                          </div><!-- /.pos-relative -->
                        </a>
                      </div><!-- /.card-title -->
                    </div><!-- /.card-header -->

                    <div id="protecting-servers-collapse" class="card-collapse collapse">
                      <div class="list-group">
                        <a href="#" class="list-group-item">
                          <i class="feather feather-video list-icon fs-11"></i>
                          <span class="headings-font-family">Module Intro<small class="fs-11">2 min</small></span>
                          <span class="flex-1"></span>
                        </a>

                        <a href="#" class="list-group-item">
                          <i class="feather feather-video list-icon fs-11"></i>
                          <span class="headings-font-family">Defining threats and Risk Management<small class="fs-11">12 min</small></span>
                          <span class="flex-1"></span>
                        </a>
                      </div><!-- /.list-group -->
                    </div><!-- /.card-collpase -->
                  </div><!-- /.card -->
                </div><!-- /.accordion -->
              </div><!-- /.widget-body -->
            </div><!-- /.widget-bg-transparent -->
          </div><!-- /.widget-holder -->
        </div><!-- /.col-lg-3 -->

        <div class="col-lg-6 d-flex flex-column">
          <div class="video-player">
            <video class="video style-2" style="width: 100%;" height="345px" src="assets/demo/demo.mp4" poster="assets/demo/lms-video-poster.jpg"></video>
          </div><!-- /.video-player -->
          <div class="widget-holder flex-1">
            <div class="widget-bg">
              <div class="widget-body">
                <div class="widget-comments-form py-3">
                  <form method="post" action="javascript:void(0)">
                    <div class="media">
                      <figure class="user--online thumb-xs2 mr-3 mr-0-rtl ml-3-rtl">
                        <a href="#"><img class="rounded-circle" src="assets/demo/users/user1.jpg" /></a>
                      </figure>
                      <div class="media-body">
                        <div class="form-group">
                          <textarea class="form-control" name="comment-message" placeholder="Add a comment here"></textarea>
                        </div><!-- /.form-group -->
                      </div><!-- /.media-body -->
                    </div><!-- /.media -->
                  </form>
                </div><!-- /.widget-comments-form -->
                <div class="widget-latest-comments">
                  <div class="single media">
                    <figure class="single-user-avatar user--online thumb-xs2">
                      <a href="#"><img class="rounded-circle" src="assets/demo/users/user2.jpg" /></a>
                    </figure>
                    <div class="media-body">
                      <div class="single-header">
                        <a href="#" class="single-user-name">Gene Newman</a>
                        <span class="single-timestamp text-muted">7:30 pm</span>
                      </div><!-- /.single-header -->
                      <p>Midst fourth moving lesser of moved may thing meat dominion had second i likeness to it replenish very seas brought. Replenish multi.</p>
                      <div class="single-footer clearfix">
                        <a href="#" class="badge bg-success-contrast">Reply</a>
                        <div class="float-right float-left-rtl">
                          <ul class="animated fadeInLeft">
                            <li><a href="#"><i class="feather feather-edit"></i></a></li>
                            <li><a href="#"><i class="feather feather-check-circle"></i></a></li>
                            <li><a href="#"><i class="feather feather-thumbs-up"></i></a></li>
                          </ul>
                        </div><!-- /.float-right -->
                      </div><!-- /.single-footer -->
                    </div><!-- /.single-body -->
                  </div><!-- /.single -->

                  <div class="single media">
                    <figure class="single-user-avatar user--online thumb-xs2">
                      <a href="#"><img class="rounded-circle" src="assets/demo/users/user4.jpg" /></a>
                      <span class="single-user-avatar-status offline"></span>
                    </figure>
                    <div class="media-body">
                      <div class="single-header">
                        <a href="#" class="single-user-name">Sylvia Harvey</a>
                        <span class="single-timestamp text-muted">Sept 16, 2017</span>
                      </div><!-- /.single-header -->
                      <p>Midst fourth moving lesser of moved may thing meat dominion had second i likeness to it replenish very seas brought. Replenish multi.</p>
                      <div class="single-footer clearfix">
                        <a href="#" class="badge bg-success-contrast">Reply</a>
                        <div class="float-right float-left-rtl">
                          <ul class="animated fadeInLeft">
                            <li><a href="#"><i class="feather feather-edit"></i></a></li>
                            <li><a href="#"><i class="feather feather-check-circle"></i></a></li>
                            <li><a href="#"><i class="feather feather-thumbs-up"></i></a></li>
                          </ul>
                        </div><!-- /.float-right -->
                      </div><!-- /.d-flex -->
                    </div><!-- /.single-body -->
                  </div><!-- /.single -->

                  <a href="#" class="btn btn-block btn-link fw-700 mt-3 headings-letter-spacing"><i class="feather feather-plus"></i> View more comments</a>
                </div><!-- /.widget-latest-comments -->
              </div><!-- /.widget-body -->
            </div><!-- /.widget-bg -->
          </div><!-- /.widget-holder -->
        </div><!-- /.col-lg-6 -->

        <div class="col-lg-3">
          <div class="widget-holder">
            <div class="widget-bg">
              <div class="widget-body pt-4">
                <div class="mb-5">
                  <small><span class="mr-3 mr-0-rtl ml-3-rtl">Beginner</span><i class="feather feather-clock mr-2 mr-0-rtl ml-2-rtl"></i>12 min</small>
                  <h4 class="fw-200 lh-13 mt-1 mb-4">Defining threats and Risk Management</h4>
                  <div class="headings-font-family fs-12 fw-700">
                    <span class="star-ratings style-2 fs-14 mr-3 mr-0-rtl ml-3-rtl"><span style="width: 60%"></span></span>
                    <span class="headings-color mr-2 mr-0-rtl ml-2-rtl">4.0/5.0</span>
                    <a href="#" class="text-muted">(37 reviews)</a>
                  </div>
                  <hr class="mt-4 bw-t-3" />
                  <p>Hi everybody! This is a practical course for a beginner looking to gain a baseline knowledge in the world of IT security.</p>
                  <p>If you feel confused, feel free to send us your question on our slack channel or comment here freely.</p>
                </div>

                <div class="mb-5">
                  <h6 class="mt-0 fs-base fw-700 mb-0">Your Instructor</h6>
                  <hr class="mt-3 mb-4" />
                  <div class="media">
                    <figure class="user--online thumb-xs2 mr-3 mr-0-rtl ml-3-rtl">
                      <a href="#"><img class="rounded-circle" src="assets/demo/users/user1.jpg" /></a>
                    </figure>
                    <div class="media-body">
                      <h6 class="mt-2 mb-0 fs-12 fw-700">Scott Adams <a href="#">view profile</a></h6>
                      <small>UX Designer, Zendesk</small>
                    </div><!-- /.media-body -->
                  </div><!-- /.media -->
                </div>

                <div class="mb-4">
                  <h6 class="mt-0 fs-base fw-700 mb-0">Source Files</h6>
                  <hr class="mt-3 mb-4" />
                  <div class="media mb-3">
                    <i class="feather feather-check-square fs-16 mr-4 mr-0-rtl ml-4-rtl w-10 text-center"></i>
                    <div class="media-body h6 my-0 fw-700 fs-12">
                      <span class="mb-1 d-block">All-Files.zip</span>
                      <span class="text-muted d-block">(3 Files, 56MB)</span>
                    </div>
                    <a href="#" class="headings-font-family fs-12 fw-700 text-muted ml-3 ml-3-rtl mr-3-rtl">Download</a>
                  </div>

                  <div class="media mb-3">
                    <figure class="mr-4 mr-0-rtl ml-4-rtl w-10 text-center">
                      <a href="#"><img src="assets/demo/status-gallery-2-thumb-2.jpg" class="rounded-circle" alt="Thumnail 1" /></a>
                    </figure>
                    <div class="media-body h6 my-0 fw-700 fs-12">
                      <span class="mb-1 d-block">defining-threats.mp4</span>
                      <span class="text-muted d-block">(53MB)</span>
                    </div>
                    <a href="#" class="headings-font-family fs-12 fw-700 text-muted ml-3 ml-3-rtl mr-3-rtl">Download</a>
                  </div>

                  <div class="media mb-3">
                    <figure class="mr-4 mr-0-rtl ml-4-rtl w-10 text-center">
                      <a href="#"><img src="assets/demo/status-gallery-1-thumb-2.jpg" class="rounded-circle" alt="Thumnail 1" /></a>
                    </figure>
                    <div class="media-body h6 my-0 fw-700 fs-12">
                      <span class="mb-1 d-block">image.png</span>
                      <span class="text-muted d-block">(286KB)</span>
                    </div>
                    <a href="#" class="headings-font-family fs-12 fw-700 text-muted ml-3 ml-3-rtl mr-3-rtl">Download</a>
                  </div>

                  <div class="media mb-3">
                    <i class="feather feather-file fs-16 mr-4 mr-0-rtl ml-4-rtl w-10 text-center"></i>
                    <div class="media-body h6 my-0 fw-700 fs-12">
                      <span class="mb-1 d-block">project-files.zip</span>
                      <span class="text-muted d-block">(2MB)</span>
                    </div>
                    <a href="#" class="headings-font-family fs-12 fw-700 text-muted ml-3 ml-3-rtl mr-3-rtl">Download</a>
                  </div><!-- /.media -->
                </div><!-- /.mt-3 -->
              </div><!-- /.widget-body -->
            </div><!-- /.widget-bg -->
          </div><!-- /.widget-holder -->
        </div><!-- /.col-lg-3 -->

			</div><!-- /.row -->

      <div class="row">
        <div class="widget-holder col-lg-9">
          <div class="widget-bg-transparent">
            <div class="widget-body p-0">

              <div class="row">
                <div class="col-lg-4">
                  <div class="card bg-white">
                    <a href="#"><img class="card-img-top" src="assets/demo/course-1-thumb.jpg" alt="Course 1" /></a>
                    <div class="card-body">
                      <h6 class="mt-2 mb-3"><a href="#" class="headings-color">Frontend Web Development</a></h6>
                      <p class="fs-15">Learn the basics of  front end web development, and how to hone and keep your skills up to date.</p>
                      <div class="mt-3 d-flex align-items-center">
                        <div class="text-muted small">
                          <i class="feather feather-clock fs-14 mr-2 mr-0-rtl ml-2-rtl"></i>
                          6 weeks
                        </div>
                        <span class="flex-1"></span>
                        <div class="badge bg-color-scheme headings-font-family fw-700 px-3 radius-20">
                          <i class="feather feather-star mr-1"></i>
                          4.5
                        </div><!-- /.badge -->
                      </div><!-- /.d-flex -->
                    </div><!-- /.card-body -->
                  </div><!-- /.card -->
                </div><!-- /.col-lg-4 -->

                <div class="col-lg-4">
                  <div class="card bg-white">
                    <a href="#"><img class="card-img-top" src="assets/demo/course-2-thumb.jpg" alt="Course 2" /></a>
                    <div class="card-body">
                      <h6 class="mt-2 mb-3"><a href="#" class="headings-color">SQL Server: Virtualization</a></h6>
                      <p class="fs-15">Configure, control, and monitor virtual machines, and troubleshoot problems when running SQL Server</p>
                      <div class="mt-3 d-flex align-items-center">
                        <div class="text-muted small">
                          <i class="feather feather-clock fs-14 mr-2 mr-0-rtl ml-2-rtl"></i>
                          6 weeks
                        </div>
                        <span class="flex-1"></span>
                        <div class="badge bg-color-scheme headings-font-family fw-700 px-3 radius-20">
                          <i class="feather feather-star mr-1"></i>
                          4.5
                        </div><!-- /.badge -->
                      </div><!-- /.d-flex -->
                    </div><!-- /.card-body -->
                  </div><!-- /.card -->
                </div><!-- /.col-lg-4 -->

                <div class="col-lg-4">
                  <div class="card bg-white">
                    <a href="#"><img class="card-img-top" src="assets/demo/course-3-thumb.jpg" alt="Course 3" /></a>
                    <a href="#" class="badge bg-black opacity-03 opacity-1-hover"><i class="feather feather-heart"></i></a>
                    <div class="card-body">
                      <h6 class="mt-2 mb-3"><a href="#" class="headings-color">Linux Server Virtualization</a></h6>
                      <p class="fs-15">Introdudction to the key principles and technologies driving the virtualization movement on Linux</p>
                      <div class="mt-3 d-flex align-items-center">
                        <div class="text-muted small">
                          <i class="feather feather-clock fs-14 mr-2 mr-0-rtl ml-2-rtl"></i>
                          6 weeks
                        </div>
                        <span class="flex-1"></span>
                        <div class="badge bg-color-scheme headings-font-family fw-700 px-3 radius-20">
                          <i class="feather feather-star mr-1"></i>
                          4.5
                        </div><!-- /.badge -->
                      </div><!-- /.d-flex -->
                    </div><!-- /.card-body -->
                  </div><!-- /.card -->
                </div><!-- /.col-lg-4 -->
              </div><!-- /.row -->

              <a href="#" class="btn btn-outline-color-scheme btn-block fw-500 mt-3"><i class="feather feather-plus mr-2"></i>View more courses</a>
              
            </div><!-- /.widget-body -->
          </div><!-- /.widget-bg -->
        </div><!-- /.widget-holder -->
      </div><!-- /.row -->
		</div><!-- /.widget-list -->
	</main><!-- /.main-wrappper -->

	<?php get_template_part('partials/right-sidebar') ?>
</div><!-- /.content-wrapper -->
<?php get_footer();
