<?php
include_once 'lib/init.php';

$config = array(
	'title' => 'Form Validation',
	'body_class' => $GLOBALS['body_class'] . '',
  'scripts' => array(
    'validator',
		'maskedinput',
  ),
);

get_header($config);
?>

<div class="content-wrapper">
	<?php get_template_part( $GLOBALS['sidebar_file'] ) ?>

	<main class="main-wrapper clearfix">

		<?php get_page_title($config); ?>

		<!-- =================================== -->
		<!-- Different data widgets ============ -->
		<!-- =================================== -->
		<div class="widget-list">
			<div class="row">

				<div class="col-md-6 widget-holder">
					<div class="widget-bg">

						<div class="widget-body clearfix">
							<h5 class="box-title mr-b-0">Input Masks</h5>
	            <p class="text-muted">Use the attribute <code>data-masked-input</code> to the input element.</p>

	            <form action="javascript:void(0);">
	              <div class="form-group row">
	                <label class="col-form-label col-sm-3 mb-0 text-left text-sm-right" for="samplePhone">Phone</label>
	                <div class="col-sm-9">
	                  <input type="text" id="samplePhone" name="samplePhone" class="form-control mb-0" data-masked-input="999-999-9999" placeholder="XXX-XXX-XXXX" maxlength="12">
	                </div><!-- /.col-sm-9 -->
	              </div><!-- /.form-group -->

	              <div class="form-group row">
	                <label class="col-form-label col-sm-3 mb-0 text-left text-sm-right" for="samplePhoneExt">Phone Ext.</label>
	                <div class="col-sm-9">
	                  <input type="text" id="samplePhoneExt" name="samplePhoneExt" class="form-control mb-0" data-masked-input="+40 999-999-9999" placeholder="XXX-XXX-XXXX" maxlength="12">
	                </div><!-- /.col-sm-9 -->
	              </div><!-- /.form-group -->

	              <div class="form-group row">
	                <label class="col-form-label col-sm-3 mb-0 text-left text-sm-right" for="sampleCellPhone">Cell Phone</label>
	                <div class="col-sm-9">
	                  <input type="text" id="sampleCellPhone" name="sampleCellPhone" class="form-control mb-0" data-masked-input="(999) 999-9999" placeholder="(XXX) XXX-XXXX" maxlength="14">
	                </div><!-- /.col-sm-9 -->
	              </div><!-- /.form-group -->

	              <div class="form-group row">
	                <label class="col-form-label col-sm-3 mb-0 text-left text-sm-right" for="sampleDoB">Date Of Birth</label>
	                <div class="col-sm-9">
	                  <input type="text" id="sampleDoB" name="sampleDoB" class="form-control mb-0" data-masked-input="99/99/9999" placeholder="MM/DD/YYYY" maxlength="10">
	                </div><!-- /.col-sm-9 -->
	              </div><!-- /.form-group -->

	              <div class="form-group row">
	                <label class="col-form-label col-sm-3 mb-0 text-left text-sm-right" for="sampleExpiryDate">Expiry Date</label>
	                <div class="col-sm-9">
	                  <input type="text" id="sampleExpiryDate" name="sampleExpiryDate" class="form-control mb-0" data-masked-input="99/99" placeholder="MM/YY" maxlength="5">
	                </div><!-- /.col-sm-9 -->
	              </div><!-- /.form-group -->

	              <div class="form-group row">
	                <label class="col-form-label col-sm-3 mb-0 text-left text-sm-right" for="sampleSSNField">SSN Field</label>
	                <div class="col-sm-9">
	                  <input type="text" id="sampleSSNField" name="sampleSSNField" class="form-control mb-0" data-masked-input="999-99-9999" placeholder="XXX-XX-XXXX" maxlength="11">
	                </div><!-- /.col-sm-9 -->
	              </div><!-- /.form-group -->

	              <div class="form-group row">
	                <label class="col-form-label col-sm-3 mb-0 text-left text-sm-right" for="sampleProductKey">Product Key</label>
	                <div class="col-sm-9">
	                  <input type="text" id="sampleProductKey" name="sampleProductKey" class="form-control mb-0" data-masked-input="a*-999-a999" placeholder="a*-999-a999" maxlength="11">
	                </div><!-- /.col-sm-9 -->
	              </div><!-- /.form-group -->

	              <div class="form-group row">
	                <label class="col-form-label col-sm-3 mb-0 text-left text-sm-right" for="sampleCurrency">Currency</label>
	                <div class="col-sm-9">
	                  <input type="text" id="sampleCurrency" name="sampleCurrency" class="form-control mb-0" data-masked-input="$ 999,999,999.99" placeholder="$ 999,999,999.99" maxlength="19">
	                </div><!-- /.col-sm-9 -->
	              </div><!-- /.form-group -->

	              <div class="form-group row">
	                <label class="col-form-label col-sm-3 mb-0 text-left text-sm-right" for="sampleDate2">Date 2</label>
	                <div class="col-sm-9">
	                  <input type="text" id="sampleDate2" name="sampleDate2" class="form-control mb-0" data-masked-input="99-99-9999" placeholder="dd-mm-yyyy" maxlength="10">
	                </div><!-- /.col-sm-9 -->
	              </div><!-- /.form-group -->

	              <div class="form-group row">
	                <label class="col-form-label col-sm-3 mb-0 text-left text-sm-right" for="sampleColor">Color Input</label>
	                <div class="col-sm-9">
	                  <input type="text" id="sampleColor" name="sampleColor" class="form-control mb-0" data-masked-input="#hhhhhh" placeholder="#hhhhhh" maxlength="7">
	                </div><!-- /.col-sm-9 -->
	              </div><!-- /.form-group -->
	            </form>
			      </div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-6 widget-holder">
					<div class="widget-bg">
						<div class="widget-body clearfix">
							<h5 class="box-title mr-b-0">Input Masks</h5>
	            <p class="text-muted">Use the attribute <code>data-masked-input</code> to the input element.</p>

							<form action="">
								<div class="form-group row">
									<label class="text-left text-sm-right col-form-label col-sm-3">Email</label>
									<div class="col-sm-9">
										<input type="email" name="email" class="form-control" required="" data-validation="email">
									</div><!-- /.col-sm-9 -->
								</div><!-- /.form-group -->

								<div class="form-group row">
									<label class="text-left text-sm-right col-form-label col-sm-3">Username</label>
									<div class="col-sm-9">
										<input name="user" class="form-control" required="" data-validation="length alphanumeric" data-validation-length="3-12"
		 data-validation-error-msg="User name has to be an alphanumeric value (3-12 chars)"	>
									</div><!-- /.col-sm-9 -->
								</div><!-- /.form-group -->

								<div class="form-group row">
									<label class="text-left text-sm-right col-form-label col-sm-3">Password</label>
									<div class="col-sm-9">
										<input type="password" name="pass_confirmation" class="form-control" data-validation="strength" data-validation-strength="2">
									</div><!-- /.col-sm-10 -->
								</div><!-- /.form-group -->

								<div class="form-group row">
									<label class="text-left text-sm-right col-form-label col-sm-3">Repeat Password</label>
									<div class="col-sm-9">
										<input type="password" name="pass" class="form-control" data-validation="confirmation" required>
									</div><!-- /.col-sm-9 -->
								</div><!-- /.form-group -->

								<div class="form-group row">
									<label class="text-left text-sm-right col-form-label col-sm-3">Birth Date</label>
									<div class="col-sm-9">
										<input type="date" class="form-control" name="birth" data-validation="birthdate">
									</div><!-- /.col-sm-9 -->
								</div><!-- /.form-group -->

								<div class="form-group row">
									<label class="text-left text-sm-right col-form-label col-sm-3">Message</label>
									<div class="col-sm-9">
										<textarea class="form-control" name="presentation" id="presentation" required></textarea>
										<small class="field-length-indicator" data-length-target="#presentation"><span class="indicator">160</span> chars left</small>
									</div><!-- /.col-sm-9 -->
								</div><!-- /.form-group -->

								<div class="ml-auto col-sm-9 no-padding">
									<button class="btn btn-primary" type="submit">Submit</button>
									<button class="btn btn-default" type="reset">Reset</button>
								</div><!-- /.col-sm-9 -->
							</form>
						</div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

			</div><!-- /.row -->
		</div><!-- /.widget-list -->
	</main><!-- /.main-wrappper -->

	<?php get_template_part('partials/right-sidebar') ?>
</div><!-- /.content-wrapper -->

<?php get_footer();
