<?php
include_once 'lib/init.php';

$config = array(
	'title' => 'Charts Js Page',
	'body_class' => $GLOBALS['body_class'] . '',
	'scripts' => array(
		'charts-js',
		'chart-js-bundle',
		'chart-js-utility',
    'countup',
		'waypoints',
	)
);

get_header($config);
?>

<div class="content-wrapper">
	<?php get_template_part( $GLOBALS['sidebar_file'] ) ?>

	<main class="main-wrapper clearfix">

		<?php get_page_title($config); ?>

		<!-- =================================== -->
		<!-- Different data widgets ============ -->
		<!-- =================================== -->
		<div class="widget-list">
			<div class="row">

				<div class="col-md-4 widget-holder">
					<div class="widget-bg p-0">
						<div class="widget-body chart-widget clearfix">
							<div class="card border-0">
								<div class="card-header border-0">
									<h5 class="sub-heading-font-family mt-3">Report Statistics</h5>
									<span class="sub-heading-font-family mb-3">Period: 22 - 29 May 2016</span>
									<div style="height: 200px;" class="my-4 pr-4">
										<canvas id="chartJsHorizontalBar"></canvas>
									</div>
								</div>
								<div class="card-footer py-4 d-flex">
									<h5 class="sub-heading-font-family mr-auto my-auto">Stacked Bar Chart</h5>
									<a href="javascript:void(0);" class="btn btn-sm px-3 fs-14 btn-rounded btn-outline-info">View Demo</a>
								</div>
							</div><!-- /.card -->
						</div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-4 widget-holder">
					<div class="widget-bg p-0">
						<div class="widget-body chart-widget clearfix">
							<div class="card border-0">
								<div class="card-header border-0">
									<h5 class="sub-heading-font-family mt-3">Report Statistics</h5>
									<span class="sub-heading-font-family mb-3">Period: 22 - 29 May 2016</span>
									<div style="height: 200px;" class="my-4 pr-3">
										<canvas id="chartJsBar"></canvas>
									</div>
								</div>
								<div class="card-footer py-4 d-flex">
									<h5 class="sub-heading-font-family mr-auto my-auto">Bar Chart</h5>
									<a href="javascript:void(0);" class="btn btn-sm px-3 fs-14 btn-rounded btn-outline-info">View Demo</a>
								</div>
							</div><!-- /.card -->
						</div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-4 widget-holder">
					<div class="widget-bg p-0">
						<div class="widget-body chart-widget clearfix">
							<div class="card border-0">
								<div class="card-header border-0">
									<h5 class="sub-heading-font-family mt-3">Report Statistics</h5>
									<span class="sub-heading-font-family mb-3">Period: 22 - 29 May 2016</span>
									<div style="height: 200px;" class="my-4">
										<canvas id="chartJsLineSingle"></canvas>
									</div>
								</div>
								<div class="card-footer py-4 d-flex">
									<h5 class="sub-heading-font-family mr-auto my-auto">Area Chart</h5>
									<a href="javascript:void(0);" class="btn btn-sm px-3 fs-14 btn-rounded btn-outline-info">View Demo</a>
								</div>
							</div><!-- /.card -->
			      </div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-4 widget-holder">
					<div class="widget-bg p-0">
						<div class="widget-body chart-widget clearfix">
							<div class="card border-0">
								<div class="card-header border-0">
									<h5 class="sub-heading-font-family mt-3">Report Statistics</h5>
									<span class="sub-heading-font-family mb-3">Period: 22 - 29 May 2016</span>
									<div style="height: 200px;" class="my-4 pr-3">
										<canvas id="chartJsLineMulti"></canvas>
									</div>
								</div>
								<div class="card-footer py-4 d-flex">
									<h5 class="sub-heading-font-family mr-auto my-auto">Area Chart</h5>
									<a href="javascript:void(0);" class="btn btn-sm px-3 fs-14 btn-rounded btn-outline-info">View Demo</a>
								</div>
							</div><!-- /.card -->
			      </div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-4 widget-holder">
					<div class="widget-bg p-0">
						<div class="widget-body chart-widget clearfix">
							<div class="card border-0">
								<div class="card-header border-0">
									<h5 class="sub-heading-font-family mt-3">Report Statistics</h5>
									<span class="sub-heading-font-family mb-3">Period: 22 - 29 May 2016</span>
									<div style="height: 200px;" class="my-4 pr-3 pie-chart">
										<canvas id="chartJsDoughnutSlim"></canvas>
										<section>
											<span class="counter display-4">75</span><span class="display-4">&#37;</span>
										</section>
									</div>
								</div>
								<div class="card-footer py-4 d-flex">
									<h5 class="sub-heading-font-family mr-auto my-auto">Pie Chart</h5>
									<a href="javascript:void(0);" class="btn btn-sm px-3 fs-14 btn-rounded btn-outline-info">View Demo</a>
								</div>
							</div><!-- /.card -->
						</div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-4 widget-holder">
					<div class="widget-bg p-0">
						<div class="widget-body chart-widget clearfix">
							<div class="card border-0">
								<div class="card-header d-flex border-0 pt-4" style="background-color: #474b5e;">
									<div class="card-header-left">
										<span class="sub-heading-font-family">Report</span>
										<h4 class="sub-heading-font-family my-2 text-inverse">90.2</h4>
										<div class="progress mb-2">
		                  <div class="progress-bar bg-warning" style="width: 60%;" role="progressbar"> <span class="sr-only">60% Complete</span> </div>
		                </div>
										<small class="sub-heading-font-family">Lorem ipsum dolor sit amet, consectetur adipisicing elit.</small>
									</div>
									<div class="card-header-right my-auto pl-2" style="height: 100px; width: 120px;">
										<canvas id="chartJsDoughnutSmall"></canvas>
									</div>
								</div>
								<div class="card-body p-0 pt-3" style="background-color: #474b5e;">
									<canvas id="chartJsAreaMultiSmall"></canvas>
								</div>
								<div class="card-footer py-4 d-flex">
									<h5 class="sub-heading-font-family mr-auto my-auto">Report Statistics</h5>
									<a href="javascript:void(0);" class="btn btn-sm px-3 fs-14 btn-rounded btn-outline-info">View Demo</a>
								</div>
							</div><!-- /.card -->
						</div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-6 widget-holder">
					<div class="widget-bg">
						<div class="widget-body clearfix">
							<h5 class="box-title">Gradient Area Chart</h5>
							<div style="height: 230px;">
								<canvas id="chartJsLineSingleGradient"></canvas>
							</div>
			      </div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-6 widget-holder">
					<div class="widget-bg">
						<div class="widget-body clearfix">
							<h5 class="box-title">Top 6 hashtags used</h5>
							<div class="chart-widget d-flex">
								<div style="height: 200px;" class="my-3 pie-chart">
									<canvas id="chartJsDoughnutLegend"></canvas>
									<section>
										<span class="counter display-4">75</span><span class="display-4">&#37;</span>
									</section>
								</div>
								<ul class="list-unstyled sub-heading-font-family my-auto">
									<li class="py-1">
										<i class="material-icons fs-18 mr-2" style="color: #6acbf8;">fiber_manual_record</i>
										<span><strong>06&#37;</strong> Outdoor</span>
									</li>
									<li class="py-1">
										<i class="material-icons fs-18 mr-2" style="color: #a88cd6;">fiber_manual_record</i>
										<span><strong>32&#37;</strong> Indoor</span>
									</li>
									<li class="py-1">
										<i class="material-icons fs-18 mr-2" style="color: #fe81a9;">fiber_manual_record</i>
										<span><strong>24&#37;</strong> Adventure</span>
									</li>
									<li class="py-1">
										<i class="material-icons fs-18 mr-2" style="color: #fcda6c;">fiber_manual_record</i>
										<span><strong>26&#37;</strong> Chill</span>
									</li>
									<li class="py-1">
										<i class="material-icons fs-18 mr-2" style="color: #81c685;">fiber_manual_record</i>
										<span><strong>12&#37;</strong> Park</span>
									</li>
									<li class="py-1">
										<i class="material-icons fs-18 mr-2" style="color: #b6fad5;">fiber_manual_record</i>
										<span><strong>06&#37;</strong> Travel</span>
									</li>
								</ul>
							</div>
						</div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-6 widget-holder">
					<div class="widget-bg">
						<div class="widget-body clearfix">
							<h5 class="box-title">Bar Chart</h5>

							<div class="" style="height: 240px;">
								<canvas id="chartJsBarMiddleAxes"></canvas>
							</div>
						</div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-6 widget-holder">
					<div class="widget-bg">
						<div class="widget-body clearfix">
							<h5 class="box-title">Area Chart</h5>

							<div class="chart-js padded-reverse" style="margin-bottom:-20px;">
								<canvas id="chartJsAreaMulti"></canvas>
							</div>
			      </div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-6 widget-holder">
					<div class="widget-bg">
						<div class="widget-body clearfix">
							<h5 class="box-title">Line Chart</h5>

							<div class="" style="height: 240px;">
								<canvas id="chartJsLine"></canvas>
							</div>
			      </div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-6 widget-holder">
					<div class="widget-bg">
						<div class="widget-body clearfix">
							<h5 class="box-title">Area Chart</h5>

			        <canvas id="chartJsArea" height="150"></canvas>
			      </div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-6 widget-holder">
					<div class="widget-bg">
						<div class="widget-body clearfix">
							<h5 class="box-title">Pie Chart</h5>
							<div class="" style="height: 240px;">
								<canvas id="chartJsPie"></canvas>
							</div>
						</div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-6 widget-holder">
					<div class="widget-bg">
						<div class="widget-body clearfix">
							<h5 class="box-title">Doughnut Chart</h5>

							<canvas id="chartJsDoughnut" height="150"></canvas>
						</div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-6 widget-holder">
					<div class="widget-bg">
						<div class="widget-body clearfix">
							<h5 class="box-title">Polar Area Chart</h5>

							<canvas id="chartJsPolarArea" height="150"></canvas>
						</div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

				<div class="col-md-6 widget-holder">
					<div class="widget-bg">
						<div class="widget-body clearfix">
							<h5 class="box-title">Radar Chart</h5>
							<canvas id="chartJsRadar" height="150"></canvas>
						</div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

			</div><!-- /.row -->
		</div><!-- /.widget-list -->
	</main><!-- /.main-wrappper -->

	<?php get_template_part('partials/right-sidebar') ?>
</div><!-- /.content-wrapper -->

<?php get_footer();
