<?php
include_once 'lib/init.php';

$config = array(
	'title' => 'Inbox Compose',
	'body_class' => $GLOBALS['body_class'] . '',
  'styles' => array(
    'bootstrap-wysiwyg',
    'dropzone',
    'selectpicker',
    'fontawesome-icons',
  ),
  'scripts' => array(
    'tinymce',
    'tinymce.theme',
    'tinymce.jquery',
    'bootstrap-wysiwyg',
    'selectpicker',
    'dropzone',
  )
);

get_header($config);
?>

<div class="content-wrapper">
	<?php get_template_part( $GLOBALS['sidebar_file'] ) ?>

	<main class="main-wrapper clearfix">

		<?php get_page_title($config); ?>

		<!-- =================================== -->
		<!-- Different data widgets ============ -->
		<!-- =================================== -->
		<div class="widget-list">
			<div class="row">

				<div class="col-md-12 widget-holder widget-full-content mb-5">
					<div class="widget-bg">
						<div class="widget-body clearfix">

							<div class="mail-inbox border-all row no-gutters" style="height: 70vh; min-height: 500px;">

								<!-- Mail Sidebar -->
								<div class="col-md-4 d-none d-md-flex flex-column mail-sidebar h-100">
                  <div class="mail-inbox-header">
										<div class="mail-inbox-tools flex-1 d-flex align-items-center">

											<span class="checkbox checkbox-primary bw-3 heading-font-family fs-14 fw-semibold headings-color mail-inbox-select-all">
			                  <label>
			                    <input type="checkbox" />
			                    <span class="label-text">Select all</span>
			                  </label>
			                </span>

                      <div class="flex-1"></div>

											<div class="btn-group">
	                      <a href="javascript:void(0)" class="btn btn-sm btn-link mr-2 text-muted"><i class="list-icon fs-18 feather feather-refresh-cw"></i></a>
	                      <a href="javascript:void(0)" class="btn btn-sm btn-link mr-2 text-muted"><i class="list-icon fs-18 feather feather-trash-2"></i></a>
                        <div class="dropdown">
                          <a href="javascript:void(0)" data-toggle="dropdown" class="btn btn-sm fs-14 fw-semibold btn-link dropdown-toggle headings-color">
                            <i class="feather feather-more-vertical text-muted fs-18 mr-2"></i>
                            More
                          </a>

                          <div role="menu" class="dropdown-menu animated fadeIn">
                            <a class="dropdown-item" href="javascript:void(0)">First Task</a>
                            <a class="dropdown-item" href="javascript:void(0)">Second Task</a>
                            <a class="dropdown-item" href="javascript:void(0)">Tird Task</a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item" href="javascript:void(0)">Grand Task</a>
                          </div>
                        </div><!-- /.dropdown -->
                      </div><!-- /.btn-group -->
										</div><!-- /.mail-inbox-tools -->
                  </div><!-- /.mail-inbox-header -->

                  <div class="mail-list flex-1 scrollbar-enabled pr-0">
                    <div class="mail-list-item unread media">
                      <a href="#" class="pos-absolute pos-0 zi-0"></a>
                      <div class="checkbox checkbox-primary bw-3 mail-select-checkbox">
                        <label>
                          <input type="checkbox" />
                          <span class="label-text"></span>
                        </label>
                      </div><!-- /.checkbox -->
                      <div class="media-body">
                        <div class="d-flex">
                          <div class="headings-font-family">
                            <span class="mail-title headings-color d-block zi-3">Chilling in Hawai!</span>
                            <small class="text-muted fw-semibold">Jerome Sallee</small>
                          </div>
                          <div class="flex-1"></div>
                          <div class="checkbox checkbox-star fs-18">
                            <label>
                              <input type="checkbox" checked />
                              <span class="label-text"></span>
                            </label>
                          </div>
                        </div><!-- /.d-flex -->
                        <div class="d-flex align-items-center mt-3">
                          <a href="#" class="zi-2"><i class="feather feather-message-circle fs-16 align-middle mr-1"></i> <span class="text-muted fs-12">Quick Reply</span></a>
                          <div class="flex-1"></div>
                          <span class="text-muted fs-12">Today, 12:30 am</span>
                        </div><!-- /.d-flex -->
                      </div><!-- /.media-body -->
                    </div><!-- /.mail-list-item -->

                    <div class="mail-list-item unread media">
                      <a href="#" class="pos-absolute pos-0 zi-0"></a>
                      <div class="checkbox checkbox-primary bw-3 mail-select-checkbox">
                        <label>
                          <input type="checkbox" />
                          <span class="label-text"></span>
                        </label>
                      </div><!-- /.checkbox -->
                      <div class="media-body">
                        <div class="d-flex">
                          <div class="headings-font-family">
                            <span class="mail-title headings-color d-block zi-3">What you've learnt about ...</span>
                            <small class="text-muted fw-semibold">Jacob Hubertus</small>
                          </div>
                          <div class="flex-1"></div>
                          <div class="checkbox checkbox-star fs-18">
                            <label>
                              <input type="checkbox" />
                              <span class="label-text"></span>
                            </label>
                          </div>
                        </div><!-- /.d-flex -->
                        <div class="d-flex align-items-center mt-3">
                          <a href="#" class="zi-2"><i class="feather feather-message-circle fs-16 align-middle mr-1"></i> <span class="text-muted fs-12">Quick Reply</span></a>
                          <div class="flex-1"></div>
                          <span class="text-muted fs-12">Today, 7:22 am</span>
                        </div><!-- /.d-flex -->
                      </div><!-- /.media-body -->
                    </div><!-- /.mail-list-item -->

                    <div class="mail-list-item read media">
                      <a href="#" class="pos-absolute pos-0 zi-0"></a>
                      <div class="checkbox checkbox-primary bw-3 mail-select-checkbox">
                        <label>
                          <input type="checkbox" />
                          <span class="label-text"></span>
                        </label>
                      </div><!-- /.checkbox -->
                      <div class="media-body">
                        <div class="d-flex">
                          <div class="headings-font-family">
                            <span class="mail-title headings-color d-block zi-3">Street Photography Competition</span>
                            <small class="text-muted fw-semibold">Jerome Sallee</small>
                          </div>
                          <div class="flex-1"></div>
                          <div class="checkbox checkbox-star fs-18">
                            <label>
                              <input type="checkbox" checked />
                              <span class="label-text"></span>
                            </label>
                          </div>
                        </div><!-- /.d-flex -->
                        <div class="d-flex align-items-center mt-3">
                          <a href="#" class="zi-2"><i class="feather feather-message-circle fs-16 align-middle mr-1"></i> <span class="text-muted fs-12">Quick Reply</span></a>
                          <div class="flex-1"></div>
                          <span class="text-muted fs-12">Oct 16</span>
                        </div><!-- /.d-flex -->
                      </div><!-- /.media-body -->
                    </div><!-- /.mail-list-item -->

                    <div class="mail-list-item read media">
                      <a href="#" class="pos-absolute pos-0 zi-0"></a>
                      <div class="checkbox checkbox-primary bw-3 mail-select-checkbox">
                        <label>
                          <input type="checkbox" />
                          <span class="label-text"></span>
                        </label>
                      </div><!-- /.checkbox -->
                      <div class="media-body">
                        <div class="d-flex">
                          <div class="headings-font-family">
                            <span class="mail-title headings-color d-block zi-3">Playstation this weekend?</span>
                            <small class="text-muted fw-semibold">Gustav Butlex</small>
                          </div>
                          <div class="flex-1"></div>
                          <div class="checkbox checkbox-star fs-18">
                            <label>
                              <input type="checkbox" />
                              <span class="label-text"></span>
                            </label>
                          </div>
                        </div><!-- /.d-flex -->
                        <div class="d-flex align-items-center mt-3">
                          <a href="#" class="zi-2"><i class="feather feather-message-circle fs-16 align-middle mr-1"></i> <span class="text-muted fs-12">Quick Reply</span></a>
                          <div class="flex-1"></div>
                          <span class="text-muted fs-12">Oct 16</span>
                        </div><!-- /.d-flex -->
                      </div><!-- /.media-body -->
                    </div><!-- /.mail-list-item -->

                    <div class="mail-list-item read media">
                      <a href="#" class="pos-absolute pos-0 zi-0"></a>
                      <div class="checkbox checkbox-primary bw-3 mail-select-checkbox">
                        <label>
                          <input type="checkbox" />
                          <span class="label-text"></span>
                        </label>
                      </div><!-- /.checkbox -->
                      <div class="media-body">
                        <div class="d-flex">
                          <div class="headings-font-family">
                            <span class="mail-title headings-color d-block zi-3">[Dribbble] work enquiry ...</span>
                            <small class="text-muted fw-semibold">Gustav Butlex</small>
                          </div>
                          <div class="flex-1"></div>
                          <div class="checkbox checkbox-star fs-18">
                            <label>
                              <input type="checkbox" />
                              <span class="label-text"></span>
                            </label>
                          </div>
                        </div><!-- /.d-flex -->
                        <div class="d-flex align-items-center mt-3">
                          <a href="#" class="zi-2"><i class="feather feather-message-circle fs-16 align-middle mr-1"></i> <span class="text-muted fs-12">Quick Reply</span></a>
                          <div class="flex-1"></div>
                          <span class="text-muted fs-12">Oct 16</span>
                        </div><!-- /.d-flex -->
                      </div><!-- /.media-body -->
                    </div><!-- /.mail-list-item -->
                  </div><!-- /.mail-inbox -->

								</div><!-- /.mail-sidebar -->

								<div class="col-md-8 col-12 d-flex flex-column">
                  <div class="mail-inbox-header">
                    <ul class="mail-inbox-categories list-unstyled list-inline headings-font-family fw-semibold mb-0">
                      <li class="list-inline-item active"><a href="#">Inbox <span class="badge bg-success-contrast px-3">246</span></a></li>
                      <li class="list-inline-item"><a href="#">Sent Mail</a></li>
                      <li class="list-inline-item"><a href="#">Starred</a></li>
                      <li class="list-inline-item"><a href="#">Drafts</a></li>
                      <li class="list-inline-item"><a href="#">Spam</a></li>
                    </ul>
                    <div class="flex-1"></div>
										<div class="d-none d-sm-block text-right">
                      <a href="#" class="btn btn-color-scheme btn-xl px-4 h6 my-0 fs-16 fw-500">Compose</a>
										</div>
                  </div><!-- /.mail-inbox-header -->

                  <div class="mail-compose d-flex flex-column flex-1">
                    <form class="d-flex flex-column flex-1">
                      <div class="mail-compose-header px-3 py-3 d-flex align-items-center">
                        <div class="icon-box icon-box-side icon-box-circle icon-box-circle-bg my-0 align-items-center">
                          <header class="mx-2">
                            <a href="#" class="bg-color-scheme"><i class="feather feather-mail"></i></a>
                          </header>
                        </div><!-- /.icon-box -->

                        <div class="form-group flex-1 mr-3 mb-0">
                          <input type="text" class="form-control subject-field" placeholder="Subject" />
                        </div><!-- /.form-group -->
                      </div><!-- /.mail-compose-header -->

                      <div class="form-group d-flex flex-column flex-1 mb-0">
                        <textarea class="mb-0" data-toggle="wysiwyg"></textarea>
                      </div><!-- /.form-group -->

                      <div class="mail-compose-footer py-3 px-3 d-flex align-items-md-center flex-column flex-md-row">
                        <div class="form-group mr-3 mb-0 mr-0-rtl ml-3-rtl">
                          <input type="email" class="form-control send-to-field" placeholder="Send To:">
                        </div><!-- /.form-group -->

                        <div class="form-group mr-3 mb-0 mr-0-rtl ml-3-rtl">
                          <select class="selectpicker form-control" data-width="200px" data-live-search="true" title="CC: Nothing Selected" multiple>
                            <option>John Doe</option>
                            <option>Scott Adams</option>
                            <option>Steve Smith</option>
                            <option>Emily Lee</option>
                            <option>Christopher Palmer</option>
                          </select>
                        </div><!-- /.form-group -->

                        <button class="btn btn-default align-self-start align-self-md-stretch"><i class="feather feather-paperclip"></i></button>

                        <div class="modal">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-body">

                              </div><!-- /.modal-body -->
                            </div><!-- /.modal-content -->
                          </div><!-- /.modal-dialog -->
                        </div><!-- /.modal -->

                        <div class="flex-1"></div>
                        
                        <div>
                          <button type="reset" class="btn btn-secondary">Clear</button>
                          <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                      </div><!-- /.mail-compose-footer -->

                    </form>
                  </div><!-- /.mail-compose -->
                </div><!-- /.col-lg-9 -->

							</div><!-- /.mailbox -->

			      </div><!-- /.widget-body -->
					</div><!-- /.widget-bg -->
				</div><!-- /.widget-holder -->

			</div><!-- /.row -->
		</div><!-- /.widget-list -->
	</main><!-- /.main-wrappper -->

	<?php get_template_part('partials/right-sidebar') ?>
</div><!-- /.content-wrapper -->

<?php get_footer();
