<?php
include_once 'lib/init.php';

$config = array(
  'title' => 'Full Calender',
  'body_class' => $GLOBALS['body_class'] . '',
  'styles' => array(
    'fullcalendar',
  ),
  'scripts' => array(
    'moment',
    'fullcalendar',
    'jqueryui',
  )
);
get_header($config);
?>

<div class="content-wrapper">
	<?php get_template_part( $GLOBALS['sidebar_file'] ) ?>

	<main class="main-wrapper clearfix">

      <?php get_page_title($config); ?>

      <!-- =================================== -->
      <!-- Different data widgets ============ -->
      <!-- =================================== -->
      <div class="widget-list">
        <div class="row">
          <!-- Events List -->
          <div class="col-md-12 widget-holder widget-full-content border-all px-0">
            <div class="widget-bg">
              <div class="widget-body">
                <div class="row no-gutters">
                    <!-- Calender Sidebar -->
                    <div class="col-md-3 custom-fullcalendar-sidebar pos-absolute pos-left d-none d-md-block">
                      <div class="fullcalendar-events" data-toggle="fullcalendar-events" data-target="#fullcalendar-1">
                          <div class="inbox-categories inbox-labels px-3">
                            <h5 class="pl-3 pl-0-rtl pr-3-rtl mt-4">Month Planner</h5>

                            <div class="fc-events">
                              <div class="fc-event bg-persian-blue"><i class="feather feather-check color-white bg-persian-blue"></i><span class="fc-event-text">Meetings</span></div>
                              <div class="fc-event bg-cerize-red"><i class="feather feather-check color-white bg-cerize-red"></i> <span class="fc-event-text">Callbacks</span></div>
                              <div class="fc-event bg-mustard"><i class="feather feather-check color-white bg-mustard"></i><span class="fc-event-text">Tasks Pending</span></div>
                              <div class="fc-event bg-gray-light"><i class="feather feather-check color-white bg-gray-light"></i> <span class="fc-event-text">Travel</span></div>
                              </div><!-- /.fc-events -->
                            </div>

                          <div class="m-3 mr-t-40">
                            <button class="btn btn-color-scheme btn-block btn-xl px-4 my-0 fs-16 ripple fc-add-event fw-500">
                              <span>Add Event</span>
                            </button>
                          </div>
                      </div><!-- /.fullcalendar-events -->
                    </div><!-- /.col-md-3 -->

                    <!-- Calender App -->
                    <div class="col-12 mb-0">
                      <div class="custom-fullcalendar fullcalendar" id="fullcalendar-1" data-toggle="fullcalendar" data-plugin-options='{ "events" : "assets/js/events-sample.json"}'></div><!-- /.fullcalendar -->
                    </div><!-- /.col-md-9 -->
                </div><!-- /.row -->
              </div><!-- /.widget-body -->
            </div><!-- /.widget-bg -->
          </div><!-- /.widget-holder -->
        </div><!-- /.row -->
    </div><!-- /.widget-list -->
  </main><!-- /.main-wrapper -->

  <?php get_template_part('partials/right-sidebar') ?>
</div><!-- /.content-wrapper -->

<?php get_footer();
