<?php
require_once '../database/config.php';

$month = $_POST['payroll_month'] ?? '';
$dept = $_POST['department'] ?? '';
$ids = $_POST['employee_ids'] ?? [];

if (!$month || !$dept || empty($ids)) {
    http_response_code(400);
    echo "Invalid data.";
    exit;
}

// Save one-by-one
foreach ($ids as $id) {
    $base = floatval($_POST["base_$id"]);
    $allow = floatval($_POST["allow_$id"]);
    $deduct = floatval($_POST["deduct_$id"]);
    $net = floatval($_POST["net_$id"]);

    // Check if already exists
    $check = $pdo->prepare("SELECT id, status FROM payrolls WHERE employee_id = ? AND payroll_month = ?");
    $check->execute([$id, $month]);
    $existing = $check->fetch(PDO::FETCH_ASSOC);

    if ($existing && $existing['status'] != 'Pending') {
        continue; // Skip non-pending
    }

    if ($existing) {
        // Update
        $stmt = $pdo->prepare("UPDATE payrolls SET base_salary=?, total_allowance=?, total_deduction=?, net_salary=?, department=? WHERE id=?");
        $stmt->execute([$base, $allow, $deduct, $net, $dept, $existing['id']]);
    } else {
        // Insert
        $stmt = $pdo->prepare("INSERT INTO payrolls (employee_id, department, payroll_month, base_salary, total_allowance, total_deduction, net_salary)
                               VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$id, $dept, $month, $base, $allow, $deduct, $net]);
    }
}

echo "Payroll saved successfully.";
