<?php
session_start();
require_once '../database/config.php';

// Handle CSV Upload
if (isset($_POST['upload_csv']) && isset($_FILES['csv_file'])) {
    $file = $_FILES['csv_file']['tmp_name'];
    $handle = fopen($file, 'r');
    $header = fgetcsv($handle); // skip header

    $stmt = $pdo->prepare("INSERT INTO salary_structures (scheme, employee_type, grade_level, step, basic, hazard, rural_post, shift_duty, teaching, total) 
                           VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
                           ON DUPLICATE KEY UPDATE 
                               basic=VALUES(basic), hazard=VALUES(hazard), rural_post=VALUES(rural_post),
                               shift_duty=VALUES(shift_duty), 
                               teaching=VALUES(teaching), total=VALUES(total)");

    while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
        if (count($data) < 10) continue;
        $stmt->execute([
            $data[0], // scheme
            $data[1], // employee_type
            intval($data[2]), // grade_level
            intval($data[3]), // step
            floatval($data[4]), // basic
            floatval($data[5]), // hazard
            floatval($data[6]), // rural_post
            floatval($data[7]), // shift_duty
            floatval($data[8]), // teaching
            floatval($data[9])  // total
        ]);
    }

    fclose($handle);

    if ($rowCount > 0) {
        $_SESSION['flash'] = "$rowCount row(s) imported successfully.";
    }

    if ($skippedRows > 0) {
        $_SESSION['flash'] .= " $skippedRows row(s) skipped due to missing or invalid data.";
    }

    if (!empty($errors)) {
        $_SESSION['flash'] .= "<br>Errors: <ul><li>" . implode("</li><li>", $errors) . "</li></ul>";
    }

    echo "<script>window.location.href='salary_structure.php';</script>";
}

// Handle Add/Edit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $scheme = $_POST['scheme'];
    $employee_type = $_POST['employee_type'];
    $grade_level = intval($_POST['grade_level']);
    $step = intval($_POST['step']);
    $basic = floatval($_POST['basic']);
    $hazard = floatval($_POST['hazard']);
    $rural_post = floatval($_POST['rural_post']);
    $shift_duty = floatval($_POST['shift_duty']);
    $teaching = floatval($_POST['teaching']);
    $total = floatval($_POST['total']);
    $edit_id = isset($_POST['edit_id']) ? intval($_POST['edit_id']) : 0;

    if ($edit_id > 0) {
        $stmt = $pdo->prepare("UPDATE salary_structures SET scheme=?, employee_type=?, grade_level=?, step=?, basic=?, hazard=?, rural_post=?, shift_duty=?, teaching=?, total=? WHERE id=?");
        $stmt->execute([$scheme, $employee_type, $grade_level, $step, $basic, $hazard, $rural_post, $shift_duty, $teaching, $total, $edit_id]);
    } else {
        $stmt = $pdo->prepare("INSERT INTO salary_structures (scheme, employee_type, grade_level, step, basic, hazard, rural_post, shift_duty, teaching, total) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE basic=VALUES(basic), hazard=VALUES(hazard), rural_post=VALUES(rural_post), shift_duty=VALUES(shift_duty), teaching=VALUES(teaching), total=VALUES(total)");
        $stmt->execute([$scheme, $employee_type, $grade_level, $step, $basic, $hazard, $rural_post, $shift_duty, $teaching, $total]);
    }
    $_SESSION['flash'] = $edit_id > 0 ? "Salary row updated." : "Salary row added.";
    
    echo "<script>window.location.href='salary_structure.php';</script>";
}

// Handle Delete
if (isset($_GET['delete_id'])) {
    $stmt = $pdo->prepare("DELETE FROM salary_structures WHERE id = ?");
    $stmt->execute([intval($_GET['delete_id'])]);
    $_SESSION['flash'] = "Salary row deleted.";
    
    echo "<script>window.location.href='salary_structure.php';</script>";
}

// Fetch and group all salary structures
$stmt = $pdo->query("SELECT * FROM salary_structures ORDER BY scheme, employee_type, grade_level, step");
$data = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Group data
$structures = [];
foreach ($data as $row) {
    $key = "{$row['scheme']} - {$row['employee_type']}";
    $structures[$key][] = $row;
}
?>




<?php include 'header.php'?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">

<div class="container py-4">
    <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($_SESSION['flash']) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['flash']); ?>
<?php endif; ?>

    <div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0">Salary Structures</h4>
    <div>
        <form method="post" enctype="multipart/form-data" class="d-inline" id="csvForm">
            <input type="hidden" name="form_type" value="csv_upload">
            <input type="file" name="csv_file" accept=".csv" required>
            <button class="btn btn-success btn-sm" type="submit" name="upload_csv">Upload CSV</button>
        </form>
        <button class="btn btn-secondary btn-sm"><a class="text-white" href="salary_structure_sample.csv">DOWNLOAD SAMPLE</a></button>
        <button class="btn btn-primary btn-sm" onclick="openAddModal()">Add Salary Row</button>
    </div>

    </div>

    <?php foreach ($structures as $key => $rows): ?>
        <div class="card mb-4 shadow">
            <div class="card-header bg-secondary text-white">
                <?= htmlspecialchars($key) ?>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-bordered table-striped salaryTable">
                    <thead>
                        <tr>
                            <th>Scheme</th>
                            <th>Type</th>
                            <th>Grade Level</th>
                            <th>Step</th>
                            <th>Basic</th>
                            <th>Hazard</th>
                            <th>Rural Post</th>
                            <th>Shift Duty</th>
                            <th>Teaching</th>
                            <th>Total</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($rows as $row): ?>
                            <tr>
                                <td><?= $row['scheme'] ?></td>
                                <td><?= $row['employee_type'] ?></td>
                                <td><?= $row['grade_level'] ?></td>
                                <td><?= $row['step'] ?></td>
                                <td><?= number_format($row['basic'], 2) ?></td>
                                <td><?= number_format($row['hazard'], 2) ?></td>
                                <td><?= number_format($row['rural_post'], 2) ?></td>
                                <td><?= number_format($row['shift_duty'], 2) ?></td>
                                <td><?= number_format($row['teaching'], 2) ?></td>
                                <td><?= number_format($row['total'], 2) ?></td>
                                <td>
                                    <button class="btn btn-sm btn-warning" onclick='openEditModal(<?= json_encode($row) ?>)'>Edit</button>
                                    <a href="?delete_id=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this row?')">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<!-- Modal -->
<div class="modal fade" id="salaryModal" tabindex="-1" aria-labelledby="salaryModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="post" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="salaryModalLabel">Add/Edit Salary Row</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
          <input type="hidden" name="edit_id" id="edit_id">
          <div class="mb-3">
              <label>Scheme</label>
              <input type="text" name="scheme" id="scheme" class="form-control" required>
          </div>
          <div class="mb-3">
              <label>Employee Type</label>
              <input type="text" name="employee_type" id="employee_type" class="form-control" required>
          </div>
          <div class="mb-3">
              <label>Grade Level</label>
              <input type="number" name="grade_level" id="grade_level" class="form-control" required>
          </div>
          <div class="mb-3">
              <label>Step</label>
              <input type="number" name="step" id="step" class="form-control" required>
          </div>
          <div class="mb-3">
              <label>Basic</label>
              <input type="number" step="0.01" name="basic" id="basic" class="form-control" required>
          </div>
          <div class="mb-3">
              <label>Hazard</label>
              <input type="number" step="0.01" name="hazard" id="hazard" class="form-control" required>
          </div>
          <div class="mb-3">
              <label>Rural Post</label>
              <input type="number" step="0.01" name="rural_post" id="rural_post" class="form-control" required>
          </div>
          <div class="mb-3">
              <label>Shift Duty</label>
              <input type="number" step="0.01" name="shift_duty" id="shift_duty" class="form-control" required>
          </div>
          <div class="mb-3">
              <label>Teaching</label>
              <input type="number" step="0.01" name="teaching" id="teaching" class="form-control" required>
          </div>
          <div class="mb-3">
              <label>Total</label>
              <input type="number" step="0.01" name="total" id="total" class="form-control" required>
          </div>
      </div>

      <div class="modal-footer">
        <button class="btn btn-success" type="submit">Save</button>
        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Cancel</button>
      </div>
    </form>
  </div>
</div>

<?php include 'footer.php'?>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>

<script>
$(document).ready(function () {
    $('.salaryTable').DataTable({
        dom: 'Bfrtip',
        buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
    });
});

function openAddModal() {
    $('#salaryModalLabel').text('Add Salary Row');
    $('#edit_id').val('');
    $('#scheme').val('');
    $('#employee_type').val('');
    $('#grade_level').val('');
    $('#step').val('');
    $('#basic').val('');
    $('#hazard').val('');
    $('#rural_post').val('');
    $('#shift_duty').val('');
    $('#teaching').val('');
    $('#total').val('');
    new bootstrap.Modal(document.getElementById('salaryModal')).show();
}

function openEditModal(data) {
    $('#salaryModalLabel').text('Edit Salary Row');
    $('#edit_id').val(data.id);
    $('#scheme').val(data.scheme);
    $('#employee_type').val(data.employee_type);
    $('#grade_level').val(data.grade_level);
    $('#step').val(data.step);
    $('#basic').val(data.basic);
    $('#hazard').val(data.hazard);
    $('#rural_post').val(data.rural_post);
    $('#shift_duty').val(data.shift_duty);
    $('#teaching').val(data.teaching);
    $('#total').val(data.total);
    new bootstrap.Modal(document.getElementById('salaryModal')).show();
}
</script>