<?php
require_once '../database/config.php';
require_once '../mpdf/vendor/autoload.php';

use Mpdf\Mpdf;

error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

if (!isset($_GET['payroll_id'], $_GET['employee_id'])) {
    die("Missing parameters.");
}

$payroll_id = intval($_GET['payroll_id']);
$employee_id = intval($_GET['employee_id']);

// Fetch payroll & employee info
$stmt = $pdo->prepare("
    SELECT pr.*, d.*, e.full_name, e.employee_no, e.department, e.grade_level, e.step, e.job_title AS designation
    FROM payrolls pr
    JOIN payroll_details d ON d.payroll_id = pr.id
    JOIN employees e ON d.employee_id = e.id
    WHERE pr.id = ? AND d.employee_id = ?
");
$stmt->execute([$payroll_id, $employee_id]);
$payroll = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$payroll) die("Payroll not found.");

// Fetch allowances
$allowStmt = $pdo->prepare("SELECT type, amount FROM allowances WHERE employee_id = ? AND (recurring = 1 OR (MONTH(allowance_date) = MONTH(?) AND YEAR(allowance_date) = YEAR(?)))");
$allowStmt->execute([$employee_id, $payroll['payroll_month'], $payroll['payroll_month']]);
$allowList = $allowStmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch deductions
$deductStmt = $pdo->prepare("SELECT type, amount FROM deductions WHERE employee_id = ? AND (recurring = 1 OR (MONTH(deduction_date) = MONTH(?) AND YEAR(deduction_date) = YEAR(?)))");
$deductStmt->execute([$employee_id, $payroll['payroll_month'], $payroll['payroll_month']]);
$deductList = $deductStmt->fetchAll(PDO::FETCH_ASSOC);

// Totals
$total_allowance = array_sum(array_column($allowList, 'amount'));
$total_deduction = array_sum(array_column($deductList, 'amount'));
$gross = $payroll['base_salary'] + $total_allowance;
$net = $gross - $total_deduction;

// Build HTML string
$html = '
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <style>
    @page { size: A4; margin: 12mm 18mm; }
    body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
    .center { text-align: center; }
    .title { font-weight: bold; text-transform: uppercase; font-size: 14px; }
    .subtitle { font-size: 12px; }
    .section-title {
      font-weight: bold;
      text-transform: uppercase;
      font-size: 11px;
      margin-top: 20px;
      margin-bottom: 5px;
      border-bottom: 1px solid #ccc;
      padding-bottom: 3px;
    }
    .row { display: flex; justify-content: space-between; margin-top: 10px; }
    .col-50 { width: 48%; }
    .col-100 { width: 100%; }
    table { width: 100%; border-collapse: collapse; margin-bottom: 10px; }
    th, td { padding: 4px 6px; font-size: 12px; }
    .text-right { text-align: right; }
    .text-left { text-align: left; }
    .bordered td, .bordered th { border: 1px solid #000; }
    .signature { margin-top: 40px; display: flex; justify-content: space-between; }
    .signature-block { width: 40%; text-align: center; }
    .signature-line { border-bottom: 1px solid #000; margin-bottom: 5px; height: 40px; }
    .note { font-size: 11px; color: #666; text-align: center; margin-top: 20px; }
    .logo { height: 60px; margin-bottom: 10px; }
  </style>
</head>
<body>

  <div class="center">
    <img src="../img/uth-logo.png" class="logo" alt="UTH Logo"><br>
    <div class="title">UNIOSUN TEACHING HOSPITAL</div>
    <div class="subtitle">P.M.B. 4499, OSOGBO, OSUN STATE</div>
    <div class="subtitle"><strong>MONTHLY PAY SLIP – ' . strtoupper(date('F Y', strtotime($payroll['payroll_month']))) . '</strong></div>
    <hr style="margin: 10px 0;">
  </div>

  <div class="section-title">Employee Information</div>
  <table>
    <tr>
      <td><strong>Name:</strong> ' . htmlspecialchars($payroll['full_name']) . '</td>
      <td><strong>Staff No:</strong> ' . htmlspecialchars($payroll['employee_no']) . '</td>
    </tr>
    <tr>
      <td><strong>Designation:</strong> ' . htmlspecialchars($payroll['designation']) . '</td>
      <td><strong>Department:</strong> ' . htmlspecialchars($payroll['department']) . '</td>
    </tr>
    <tr>
      <td><strong>Grade Level:</strong> ' . htmlspecialchars($payroll['grade_level']) . '</td>
      <td><strong>Step:</strong> ' . htmlspecialchars($payroll['step']) . '</td>
    </tr>
  </table>

  <div class="row">
    <div class="col-50">
      <div class="section-title">Earnings</div>
      <table class="bordered">
        <thead>
          <tr><th>Description</th><th class="text-right">Amount (₦)</th></tr>
        </thead>
        <tbody>
          <tr><td>Base Salary</td><td class="text-right">' . number_format($payroll['base_salary'], 2) . '</td></tr>';

foreach ($allowList as $row) {
  $html .= '<tr><td>' . htmlspecialchars($row['type']) . '</td><td class="text-right">' . number_format($row['amount'], 2) . '</td></tr>';
}

$html .= '
        </tbody>
      </table>
    </div>

    <div class="col-50">
      <div class="section-title">Deductions</div>
      <table class="bordered">
        <thead>
          <tr><th>Description</th><th class="text-right">Amount (₦)</th></tr>
        </thead>
        <tbody>';

foreach ($deductList as $row) {
  $html .= '<tr><td>' . htmlspecialchars($row['type']) . '</td><td class="text-right">' . number_format($row['amount'], 2) . '</td></tr>';
}

$html .= '
        </tbody>
      </table>
    </div>
  </div>

  <div class="section-title">Summary</div>
  <table class="col-100">
    <tr>
      <td><strong>Gross Pay:</strong></td>
      <td class="text-right">' . number_format($gross, 2) . '</td>
    </tr>
    <tr>
      <td><strong>Total Deductions:</strong></td>
      <td class="text-right">' . number_format($total_deduction, 2) . '</td>
    </tr>
    <tr>
      <td><strong>Net Pay:</strong></td>
      <td class="text-right">' . number_format($net, 2) . '</td>
    </tr>
  </table>

  <div class="signature">
    <div class="signature-block">
      <div class="signature-line"></div>
      <p>HEAD OF HR</p>
    </div>
    <div class="signature-block">
      <div class="signature-line"></div>
      <p>DIRECTOR OF FINANCE</p>
    </div>
  </div>

  <div class="note">
    <p>This payslip is system-generated and does not require a physical signature.</p>
  </div>

</body>
</html>';

// Output PDF
$mpdf = new Mpdf([
  'format' => 'A4',
  'margin_top' => 10,
  'margin_bottom' => 10
]);

$filename = 'Payslip_' . $payroll['employee_no'] . '_' . date('F_Y', strtotime($payroll['payroll_month'])) . '.pdf';
$mpdf->WriteHTML($html);
$mpdf->Output($filename, 'I');
