<?php
require_once '../database/config.php';
session_start();

if (!isset($_GET['id'])) {
    $_SESSION['flash'] = "Payroll batch ID missing.";
    header("Location: payroll_batches.php");
    exit;
}

$payroll_id = intval($_GET['id']);

// Fetch payroll
$stmt = $pdo->prepare("SELECT * FROM payrolls WHERE id = ?");
$stmt->execute([$payroll_id]);
$payroll = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$payroll) {
    $_SESSION['flash'] = "Payroll batch not found.";
    header("Location: payroll_batches.php");
    exit;
}

// Handle Approve / Reject actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'];

    if ($_SESSION['role'] === 'finance' && $payroll['status'] === 'pending') {
        if ($action === 'approve') {
            $stmt = $pdo->prepare("UPDATE payrolls SET status='approved_by_dof', approved_by_dof=?, approved_at_dof=NOW() WHERE id=?");
            $stmt->execute([$_SESSION['admin_id'], $payroll_id]);
            $_SESSION['flash'] = "Payroll approved by Finance.";
        } elseif ($action === 'reject') {
            $stmt = $pdo->prepare("UPDATE payrolls SET status='rejected' WHERE id=?");
            $stmt->execute([$payroll_id]);
            $_SESSION['flash'] = "Payroll rejected.";
        }
    }

    if ($_SESSION['role'] === 'cmd' && $payroll['status'] === 'approved_by_dof') {
        if ($action === 'approve') {
            $stmt = $pdo->prepare("UPDATE payrolls SET status='approved_by_cmd', approved_by_cmd=?, approved_at_cmd=NOW() WHERE id=?");
            $stmt->execute([$_SESSION['admin_id'], $payroll_id]);
            $_SESSION['flash'] = "Payroll approved by CMD.";
        } elseif ($action === 'reject') {
            $stmt = $pdo->prepare("UPDATE payrolls SET status='rejected' WHERE id=?");
            $stmt->execute([$payroll_id]);
            $_SESSION['flash'] = "Payroll rejected by CMD.";
        }
    }

    header("Location: payroll_view.php?id=$payroll_id");
    exit;
}

// Fetch payroll details
$stmt = $pdo->prepare("
    SELECT p.*, e.full_name, e.employee_no
    FROM payroll_details p 
    JOIN employees e ON p.employee_id = e.id 
    WHERE payroll_id = ?
");
$stmt->execute([$payroll_id]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<?php include 'header.php'; ?>
<div class="container py-4">

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-info alert-dismissible fade show" role="alert">
        <?= $_SESSION['flash']; unset($_SESSION['flash']); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php endif; ?>

  <div class="mb-3">
    <h5>Payroll for <?= htmlspecialchars($payroll['department']) ?> - <?= date('F Y', strtotime($payroll['payroll_month'])) ?></h5>
    <div class="d-flex align-items-center gap-3 flex-wrap mb-2">
  <span class="badge 
    <?= $payroll['status'] === 'pending' ? 'bg-warning text-dark' : 
        ($payroll['status'] === 'approved_by_dof' ? 'bg-primary' : 
        ($payroll['status'] === 'approved_by_cmd' ? 'bg-success' : 'bg-danger')) ?>">
    <?= ucwords(str_replace('_', ' ', $payroll['status'])) ?>
  </span>

  <?php if (!empty($payroll['approved_at_dof'])): ?>
    <span class="badge bg-info text-dark">Finance Approved: <?= date('d M Y H:i', strtotime($payroll['approved_at_dof'])) ?></span>
  <?php endif; ?>

  <?php if (!empty($payroll['approved_at_cmd'])): ?>
    <span class="badge bg-secondary text-light">CMD Approved: <?= date('d M Y H:i', strtotime($payroll['approved_at_cmd'])) ?></span>
  <?php endif; ?>
</div>

  </div>

  <table class="table table-bordered table-striped">
    <thead>
      <tr>
        <th>#</th>
        <th>Employee</th>
        <th>Code</th>
        <th>Base Salary</th>
        <th>Allowance</th>
        <th>Deduction</th>
        <th>Net Pay</th>
      </tr>
    </thead>
    <tbody>
      <?php 
      $i = 1;
      $total_net = 0;
      foreach ($rows as $row): 
        $total_net += $row['net_pay'];
      ?>
        <tr>
          <td><?= $i++ ?></td>
          <td><?= htmlspecialchars($row['full_name']) ?><a href="payslip.php?payroll_id=<?= $payroll['id'] ?>&employee_id=<?= $row['employee_id'] ?>" class="btn btn-sm btn-outline-primary" target="_blank">PAYSLIP</a></td>
          <td><?= $row['employee_no'] ?></td>
          <td><?= number_format($row['base_salary'], 2) ?></td>
          <td><?= number_format($row['total_allowance'], 2) ?></td>
          <td><?= number_format($row['total_deduction'], 2) ?></td>
          <td><?= number_format($row['net_pay'], 2) ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
    <tfoot>
      <tr>
        <th colspan="6" class="text-end">Total Payroll</th>
        <th><?= number_format($total_net, 2) ?></th>
      </tr>
    </tfoot>
  </table>

  <?php if ($_SESSION['role'] === 'finance' && $payroll['status'] === 'pending'): ?>
    <form method="post" class="mt-3">
      <button name="action" value="approve" class="btn btn-success">Approve (Finance)</button>
      <button name="action" value="reject" class="btn btn-danger" onclick="return confirm('Reject this payroll?')">Reject</button>
    </form>
  <?php elseif ($_SESSION['role'] === 'cmd' && $payroll['status'] === 'approved_by_dof'): ?>
    <form method="post" class="mt-3">
      <button name="action" value="approve" class="btn btn-success">Approve (CMD)</button>
      <button name="action" value="reject" class="btn btn-danger" onclick="return confirm('Reject this payroll?')">Reject</button>
    </form>
  <?php endif; ?>

</div>
<?php include 'footer.php'; ?>
