<?php
require_once '../database/config.php';
include 'header.php';

// Filters
$month = $_GET['month'] ?? date('Y-m');
$department = $_GET['department'] ?? '';

// Prepare filter clauses
$where = "DATE_FORMAT(pr.payroll_month, '%Y-%m') = ?";
$params = [$month];

if ($department) {
    $where .= " AND e.department = ?";
    $params[] = $department;
}

// Department list
$departments = $pdo->query("SELECT DISTINCT department FROM employees WHERE department IS NOT NULL ORDER BY department")->fetchAll(PDO::FETCH_COLUMN);

// Summary counts and totals per status
$summaryStmt = $pdo->prepare("
    SELECT 
        pr.status,
        COUNT(*) as count,
        SUM(d.base_salary) as base_salary,
        SUM(d.total_allowance) as total_allowance,
        SUM(d.base_salary + IFNULL(d.total_allowance, 0)) as gross_total,
        SUM(d.total_deduction) as total_deduction,
        SUM(d.net_pay) as net_total
    FROM payrolls pr
    JOIN payroll_details d ON d.payroll_id = pr.id
    JOIN employees e ON e.id = d.employee_id
    WHERE $where
    GROUP BY pr.status
");
$summaryStmt->execute($params);
$summaryData = $summaryStmt->fetchAll(PDO::FETCH_ASSOC);

// Flatten to associative
$summary = [];
foreach ($summaryData as $row) {
    $summary[$row['status']] = $row;
}

// Get overall totals for selected month/department
$overallStmt = $pdo->prepare("
    SELECT 
        COUNT(*) as payrolls,
        SUM(d.base_salary) as base_salary,
        SUM(d.total_allowance) as total_allowance,
        SUM(d.base_salary + IFNULL(d.total_allowance,0)) as gross_total,
        SUM(d.total_deduction) as total_deduction,
        SUM(d.net_pay) as net_total
    FROM payrolls pr
    JOIN payroll_details d ON d.payroll_id = pr.id
    JOIN employees e ON e.id = d.employee_id
    WHERE $where
");
$overallStmt->execute($params);
$overall = $overallStmt->fetch(PDO::FETCH_ASSOC);

?>
<main class="main-wrapper clearfix">
  <div class="container py-4">
    <h4 class="mb-4">Payroll Summary Report</h4>

    <form class="form-inline mb-3" method="get">
      <div class="form-group mr-3">
        <label class="mr-2">Month:</label>
        <input type="month" name="month" class="form-control" value="<?= htmlspecialchars($month) ?>">
      </div>
      <div class="form-group mr-3">
        <label class="mr-2">Department:</label>
        <select name="department" class="form-control">
          <option value="">All</option>
          <?php foreach ($departments as $dept): ?>
            <option value="<?= htmlspecialchars($dept) ?>" <?= $dept === $department ? 'selected' : '' ?>>
              <?= htmlspecialchars($dept) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <button class="btn btn-primary btn-sm ml-2">Filter</button>
    </form>

    <!-- Overall summary -->
    <div class="card mb-4">
      <div class="card-header bg-dark text-white">Overall Summary</div>
      <div class="card-body p-0">
        <table class="table table-bordered mb-0">
          <tr>
            <th>Total Payrolls</th>
            <td><?= number_format($overall['payrolls'] ?? 0) ?></td>
            <th>Total Basic Salary</th>
            <td>₦<?= number_format($overall['base_salary'] ?? 0, 2) ?></td>
          </tr>
          <tr>
            <th>Total Allowances</th>
            <td>₦<?= number_format($overall['total_allowance'] ?? 0, 2) ?></td>
            <th>Gross Total</th>
            <td>₦<?= number_format($overall['gross_total'] ?? 0, 2) ?></td>
          </tr>
          <tr>
            <th>Total Deductions</th>
            <td>₦<?= number_format($overall['total_deduction'] ?? 0, 2) ?></td>
            <th>Net Total</th>
            <td>₦<?= number_format($overall['net_total'] ?? 0, 2) ?></td>
          </tr>
        </table>
      </div>
    </div>

    <div class="row">
      <?php
      $statuses = [
        'pending' => 'Pending',
        'approved_by_dof' => 'Approved by DoF',
        'approved_by_cmd' => 'Approved by CMD',
        'rejected' => 'Rejected'
      ];
      ?>
      <?php foreach ($statuses as $key => $label): ?>
        <?php
          $data = $summary[$key] ?? [
            'count'=>0,
            'base_salary'=>0,
            'total_allowance'=>0,
            'gross_total'=>0,
            'total_deduction'=>0,
            'net_total'=>0
          ];
        ?>
        <div class="col-md-6 mb-3">
          <div class="card border-left-<?= $key === 'rejected' ? 'danger' : ($key === 'pending' ? 'warning' : 'success') ?>">
            <div class="card-body">
              <h6 class="card-title"><?= $label ?></h6>
              <p class="mb-1">Payrolls: <strong><?= $data['count'] ?></strong></p>
              <p class="mb-1">Basic Salary: <strong>₦<?= number_format($data['base_salary'], 2) ?></strong></p>
              <p class="mb-1">Allowances: <strong>₦<?= number_format($data['total_allowance'], 2) ?></strong></p>
              <p class="mb-1">Gross Total: <strong>₦<?= number_format($data['gross_total'], 2) ?></strong></p>
              <p class="mb-1">Deductions: <strong>₦<?= number_format($data['total_deduction'], 2) ?></strong></p>
              <p class="mb-0">Net Total: <strong>₦<?= number_format($data['net_total'], 2) ?></strong></p>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</main>

<?php include 'footer.php'; ?>
