<?php
require_once '../database/config.php';

$department = $_POST['department'] ?? '';
$month = $_POST['month'] ?? '';

if (!$department || !$month) {
    echo "<div class='alert alert-warning'>Invalid request.</div>";
    exit;
}

$payrollDate = date('Y-m-01', strtotime($month));

// Fetch employees in department
$stmt = $pdo->prepare("SELECT * FROM employees WHERE department = ?");
$stmt->execute([$department]);
$employees = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($employees)) {
    echo "<div class='alert alert-info'>No employees found in selected department.</div>";
    exit;
}

echo "<form id='savePayrollForm'><input type='hidden' name='department' value='" . htmlspecialchars($department) . "'>";
echo "<input type='hidden' name='payroll_month' value='$payrollDate'>";
echo "<div class='table-responsive'><table class='table table-bordered table-striped'>";
echo "<thead><tr>
        <th>Name</th><th>Emp No</th><th>Grade</th><th>Step</th>
        <th>Base</th><th>Allowances</th><th>Deductions</th><th>Net Pay</th>
      </tr></thead><tbody>";

foreach ($employees as $emp) {
    // Get salary structure
    $salary = $pdo->prepare("SELECT total FROM salary_structures WHERE scheme = ? AND employee_type = ? AND grade_level = ? AND step = ?");
    $salary->execute([$emp['scheme'] ?? 'CONHESS', $emp['employee_type'] ?? 'Nurse', $emp['grade_level'], $emp['step']]);
    $base = $salary->fetchColumn() ?: 0;

    // Allowances (recurring or within month)
    $aStmt = $pdo->prepare("
        SELECT SUM(amount) FROM allowances 
        WHERE employee_id = ? AND 
        (recurring = 1 OR (MONTH(allowance_date) = MONTH(?) AND YEAR(allowance_date) = YEAR(?)))
    ");
    $aStmt->execute([$emp['id'], $payrollDate, $payrollDate]);
    $allow = $aStmt->fetchColumn() ?: 0;

    // Deductions (recurring or within month)
    $dStmt = $pdo->prepare("
        SELECT SUM(amount) FROM deductions 
        WHERE employee_id = ? AND 
        (recurring = 1 OR (MONTH(deduction_date) = MONTH(?) AND YEAR(deduction_date) = YEAR(?)))
    ");
    $dStmt->execute([$emp['id'], $payrollDate, $payrollDate]);
    $deduct = $dStmt->fetchColumn() ?: 0;

    $net = $base + $allow - $deduct;

    echo "<tr>
        <td>{$emp['full_name']}</td>
        <td>{$emp['employee_no']}</td>
        <td>{$emp['grade_level']}</td>
        <td>{$emp['step']}</td>
        <td>" . number_format($base, 2) . "</td>
        <td>" . number_format($allow, 2) . "</td>
        <td>" . number_format($deduct, 2) . "</td>
        <td>" . number_format($net, 2) . "</td>
      </tr>";

    // Hidden fields for submission
    echo "<input type='hidden' name='employee_ids[]' value='{$emp['id']}'>";
    echo "<input type='hidden' name='base_{$emp['id']}' value='{$base}'>";
    echo "<input type='hidden' name='allow_{$emp['id']}' value='{$allow}'>";
    echo "<input type='hidden' name='deduct_{$emp['id']}' value='{$deduct}'>";
    echo "<input type='hidden' name='net_{$emp['id']}' value='{$net}'>";
}

echo "</tbody></table></div>";
echo "<div class='text-end'><button type='submit' class='btn btn-success'>Save Payroll</button></div>";
echo "</form>";
?>

<script>
$('#savePayrollForm').on('submit', function(e) {
    e.preventDefault();
    $.ajax({
        url: 'save_payroll.php',
        method: 'POST',
        data: $(this).serialize(),
        success: function(res) {
            alert(res);
        },
        error: function() {
            alert("Error saving payroll.");
        }
    });
});
</script>
