<?php
require_once '../database/config.php';
session_start();

// Ensure ID is passed
if (!isset($_GET['id'])) {
    $_SESSION['flash'] = "Payroll ID missing.";
    header("Location: payroll_batches.php");
    exit;
}

$payroll_id = intval($_GET['id']);

// Fetch payroll
$stmt = $pdo->prepare("SELECT * FROM payrolls WHERE id = ?");
$stmt->execute([$payroll_id]);
$payroll = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$payroll) {
    $_SESSION['flash'] = "Payroll not found.";
    header("Location: payroll_batches.php");
    exit;
}

// Prevent deletion if already approved by CMD
if ($payroll['status'] === 'approved_by_cmd') {
    $_SESSION['flash'] = "Cannot delete. This payroll is already approved by CMD.";
    log_audit($pdo, $_SESSION['user_id'], "ADMIN: Attempt to delete Payroll ID: $payroll_id failed. Reason: Already approved by CMD");
    header("Location: payroll_batches.php");
    exit;
}

// Delete related payroll details
$stmt = $pdo->prepare("DELETE FROM payroll_details WHERE payroll_id = ?");
$stmt->execute([$payroll_id]);

// Delete payroll record
$stmt = $pdo->prepare("DELETE FROM payrolls WHERE id = ?");
$stmt->execute([$payroll_id]);

$_SESSION['flash'] = "Payroll batch deleted successfully.";
log_audit($pdo, $_SESSION['user_id'], "ADMIN: Deleted Payroll ID: $payroll_id successfully.");
header("Location: payroll_batches.php");
exit;
