<?php
require_once '../database/config.php';
session_start();

// Fetch unique departments
$departments = $pdo->query("SELECT DISTINCT department FROM employees WHERE department IS NOT NULL")->fetchAll(PDO::FETCH_COLUMN);
?>

<?php include 'header.php'; ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">

<div class="container mt-4">
    <h4>Payroll Computation</h4>
    
    <form id="payrollForm" class="row g-3 mb-4">
        <div class="col-md-4">
            <label class="form-label">Department</label>
            <select name="department" id="department" class="form-select" required>
                <option value="">Select Department</option>
                <?php foreach ($departments as $dept): ?>
                    <option value="<?= htmlspecialchars($dept) ?>"><?= htmlspecialchars($dept) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-4">
            <label class="form-label">Payroll Month</label>
            <input type="month" name="month" id="month" class="form-control" required>
        </div>
        <div class="col-md-4 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">Preview Payroll</button>
        </div>
    </form>

    <div id="payrollPreviewArea"></div>
</div>

<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script>
$(document).ready(function () {
    $('#payrollForm').on('submit', function (e) {
        e.preventDefault();
        const dept = $('#department').val();
        const month = $('#month').val();
        if (!dept || !month) return;

        $('#payrollPreviewArea').html('<div class="text-center">Loading...</div>');

        $.post('payroll_preview.php', { department: dept, month: month }, function (data) {
            $('#payrollPreviewArea').html(data);
        });
    });
});
</script>

<?php include 'footer.php'; ?>
