<?php
// === loader.php (PHP 5.6 compatible) ===

/**
 * Get the domain name this script is running under.
 * Falls back to the machine hostname if SERVER_NAME isn't available.
 */
function get_domain_name() {
    if (!empty($_SERVER['SERVER_NAME'])) {
        return strtolower($_SERVER['SERVER_NAME']);
    }
    // CLI or unusual setup fallback
    return strtolower(gethostname());
}

// Derive the same key used at encryption time
$domain = get_domain_name();
$key    = hash('sha256', $domain);

// Load the encrypted payload
$raw = file_get_contents(__DIR__ . '/pb.php');
$parts = explode('::', $raw, 2);
if (count($parts) !== 2) {
    die('Corrupted encrypted file.');
}

$encrypted = $parts[0];
$checksum  = $parts[1];

// Verify integrity
if (hash('sha256', $encrypted) !== $checksum) {
    die('Tampering detected: integrity check failed.');
}

// Decode and XOR-decrypt
$decoded   = base64_decode($encrypted);
$decrypted = '';
for ($i = 0, $len = strlen($decoded); $i < $len; $i++) {
    $decrypted .= $decoded[$i] ^ $key[$i % strlen($key)];
}

// Execute
eval('?>' . $decrypted);
