<?php
require_once '../database/config.php';
session_start();

if (!isset($_SESSION['user_id'], $_SESSION['role']) || !in_array($_SESSION['role'], ['DoF', 'CMD'])) {
    die("Access denied.");
}

$role = $_SESSION['role'];

// Filter input
$filterMonth = $_GET['month'] ?? '';
$filterDept = $_GET['dept'] ?? '';

// Build query based on role
$where = [];
$params = [];

if ($role === 'DoF') {
    $where[] = "status = 'pending'";
} elseif ($role === 'CMD') {
    $where[] = "status = 'approved_by_dof'";
}

if ($filterMonth) {
    $where[] = "payroll_month = ?";
    $params[] = date('Y-m-01', strtotime($filterMonth));
}

if ($filterDept) {
    $where[] = "department = ?";
    $params[] = $filterDept;
}

$whereSQL = count($where) ? "WHERE " . implode(" AND ", $where) : "";

$sql = "SELECT * FROM payrolls $whereSQL ORDER BY payroll_month DESC, department";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$payrolls = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get department list
$departments = $pdo->query("SELECT DISTINCT department FROM employees WHERE department IS NOT NULL ORDER BY department")->fetchAll(PDO::FETCH_COLUMN);
?>

<?php include 'header.php'; ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap4.min.css" />

<main class="main-wrapper clearfix">
  <div class="container py-4">

    <h4>Payroll Approvals (<?= ucfirst($role) ?>)</h4>

    <form method="get" class="form-inline mb-3">
      <div class="form-group mr-2">
        <label class="mr-2">Month</label>
        <input type="month" name="month" value="<?= htmlspecialchars($filterMonth) ?>" class="form-control">
      </div>
      <div class="form-group mr-2">
        <label class="mr-2">Department</label>
        <select name="dept" class="form-control">
          <option value="">All</option>
          <?php foreach ($departments as $d): ?>
            <option value="<?= $d ?>" <?= $filterDept == $d ? 'selected' : '' ?>><?= $d ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <button class="btn btn-primary">Filter</button>
    </form>

    <div class="table-responsive">
      <table class="table table-bordered table-striped" id="approvalTable">
        <thead class="thead-light">
          <tr>
            <th>Department</th>
            <th>Month</th>
            <th>Status</th>
            <th>Created</th>
            <th>Approved by</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($payrolls as $p): ?>
            <tr>
              <td><?= htmlspecialchars($p['department']) ?></td>
              <td><?= date('F Y', strtotime($p['payroll_month'])) ?></td>
              <td>
                <?php
                  if ($p['status'] == 'pending') echo "<span class='badge badge-warning'>Pending</span>";
                  elseif ($p['status'] == 'approved_by_dof') echo "<span class='badge badge-info'>Finance Approved</span>";
                  elseif ($p['status'] == 'approved_by_cmd') echo "<span class='badge badge-success'>CMD Approved</span>";
                  else echo "<span class='badge badge-danger'>Rejected</span>";
                ?>
              </td>
              <td><?= date('d M Y H:i', strtotime($p['created_at'])) ?></td>
              <td>
                <?php
                  if ($p['approved_by_dof']) echo "DoF at " . date('d M H:i', strtotime($p['approved_at_dof'])) . "<br>";
                  if ($p['approved_by_cmd']) echo "CMD at " . date('d M H:i', strtotime($p['approved_at_cmd']));
                ?>
              </td>
              <td>
                <a href="payroll_view.php?id=<?= $p['id'] ?>" class="btn btn-info btn-sm mb-1">View</a>
                <form method="post" action="payroll_action.php" class="d-inline">
                  <input type="hidden" name="payroll_id" value="<?= $p['id'] ?>">
                  <?php if ($role === 'DoF' && $p['status'] === 'pending'): ?>
                    <button name="action" value="approve" class="btn btn-success btn-sm">Approve</button>
                    <button name="action" value="reject" class="btn btn-danger btn-sm" onclick="return confirm('Reject this payroll?')">Reject</button>
                  <?php elseif ($role === 'CMD' && $p['status'] === 'approved_by_dof'): ?>
                    <button name="action" value="approve" class="btn btn-success btn-sm">Approve</button>
                    <button name="action" value="reject" class="btn btn-danger btn-sm" onclick="return confirm('Reject this payroll?')">Reject</button>
                  <?php endif; ?>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>

  </div>
</main>

<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap4.min.js"></script>
<script>
$(document).ready(function () {
  $('#approvalTable').DataTable({
    pageLength: 25
  });
});
</script>

<?php include 'footer.php'; ?>