<?php
require_once '../database/config.php';
session_start();

if (!isset($_SESSION['user_id'], $_SESSION['role']) || !in_array($_SESSION['role'], ['DoF', 'CMD'])) {
    die("Unauthorized access.");
}

$role = $_SESSION['role'];
$admin_id = $_SESSION['user_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['payroll_id'], $_POST['action'])) {
    $payroll_id = intval($_POST['payroll_id']);
    $action = $_POST['action'];

    // Fetch payroll
    $stmt = $pdo->prepare("SELECT * FROM payrolls WHERE id = ?");
    $stmt->execute([$payroll_id]);
    $payroll = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$payroll) {
        die("Payroll record not found.");
    }

    if ($role === 'DoF' && $payroll['status'] === 'pending') {
        if ($action === 'approve') {
            $pdo->prepare("UPDATE payrolls SET status = 'approved_by_dof', approved_by_dof = ?, approved_at_dof = NOW() WHERE id = ?")
                ->execute([$admin_id, $payroll_id]);
    log_audit($pdo, $_SESSION['user_id'], "DoF: Payroll ID $payroll_id approved");
        } elseif ($action === 'reject') {
            $pdo->prepare("UPDATE payrolls SET status = 'rejected', rejected_by = ?, rejected_at = NOW() WHERE id = ?")
                ->execute([$admin_id, $payroll_id]);
    log_audit($pdo, $_SESSION['user_id'], "DoF: Rejected Payroll ID: $payroll_id successfully");
        }
    } elseif ($role === 'CMD' && $payroll['status'] === 'approved_by_dof') {
        if ($action === 'approve') {
            $pdo->prepare("UPDATE payrolls SET status = 'approved_by_cmd', approved_by_cmd = ?, approved_at_cmd = NOW() WHERE id = ?")
                ->execute([$admin_id, $payroll_id]);
    log_audit($pdo, $_SESSION['user_id'], "CMD: Payroll ID $payroll_id approved");
        } elseif ($action === 'reject') {
            $pdo->prepare("UPDATE payrolls SET status = 'rejected', rejected_by = ?, rejected_at = NOW() WHERE id = ?")
                ->execute([$admin_id, $payroll_id]);
    log_audit($pdo, $_SESSION['user_id'], "CMD: Rejected Payroll ID: $payroll_id successfully");
        }
    }

    header("Location: payroll_approvals.php");
    exit;
} else {
    die("Invalid request.");
}
