<?php
include 'header.php';
require_once '../database/config.php';

// Handle Add/Edit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id       = $_POST['id'] ?? 0;
    $username = trim($_POST['username']);
    $role     = $_POST['role'];
    $employee_id = !empty($_POST['employee_id']) ? intval($_POST['employee_id']) : null;
    $password = $_POST['password'];

    if ($id) {
        // Update
        if ($password) {
            $hashed = password_hash($password, PASSWORD_DEFAULT);
            $sql = "UPDATE users SET username=?, role=?, employee_id=?, password=? WHERE id=?";
            $pdo->prepare($sql)->execute([$username, $role, $employee_id, $hashed, $id]);
        } else {
            $sql = "UPDATE users SET username=?, role=?, employee_id=? WHERE id=?";
            $pdo->prepare($sql)->execute([$username, $role, $employee_id, $id]);
            
    log_audit($pdo, $_SESSION['user_id'], "Updated $username successfully");
        }
    } else {
        // New user
        $hashed = password_hash($password, PASSWORD_DEFAULT);
        $sql = "INSERT INTO users (username, role, employee_id, password) VALUES (?, ?, ?, ?)";
        $pdo->prepare($sql)->execute([$username, $role, $employee_id, $hashed]);
    log_audit($pdo, $_SESSION['user_id'], "Added $username successfully");
    }
    header("Location: manage_users.php");
    exit;
}

// Handle Delete
if (isset($_GET['delete_id'])) {
    $pdo->prepare("DELETE FROM users WHERE id=?")->execute([$_GET['delete_id']]);
    
    log_audit($pdo, $_SESSION['user_id'], "Deleted a user");
    header("Location: manage_users.php");
    exit;
}

// Fetch employees for dropdown
$employees = $pdo->query("SELECT id, full_name, employee_no FROM employees ORDER BY full_name")->fetchAll(PDO::FETCH_ASSOC);

// Fetch all users
$users = $pdo->query("SELECT u.*, e.full_name FROM users u LEFT JOIN employees e ON u.employee_id = e.id")->fetchAll(PDO::FETCH_ASSOC);

?>

<main class="main-wrapper clearfix">
  <div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h4>User Management</h4>
      <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#userModal" onclick="openAddUser()">Add User</button>
    </div>
    <table class="table table-bordered table-striped" id="userTable">
      <thead>
        <tr>
          <th>#</th>
          <th>Username</th>
          <th>Role</th>
          <th>Linked Employee</th>
          <th>Last Login</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($users as $i => $u): ?>
          <tr>
            <td><?= $i+1 ?></td>
            <td><?= htmlspecialchars($u['username']) ?></td>
            <td><?= htmlspecialchars($u['role']) ?></td>
            <td><?= htmlspecialchars($u['full_name']) ?></td>
            <td><?= $u['last_login'] ?></td>
            <td>
              <button class="btn btn-warning btn-sm" onclick='openEditUser(<?= json_encode($u) ?>)'>Edit</button>
              <a href="?delete_id=<?= $u['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Delete?')">Delete</a>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</main>

<!-- Modal -->
<div class="modal fade" id="userModal" tabindex="-1">
  <div class="modal-dialog">
    <form method="post" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="userModalTitle">Add/Edit User</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        <input type="hidden" name="id" id="user_id">
        <div class="form-group">
          <label>Username</label>
          <input name="username" id="username" class="form-control" required>
        </div>
        <div class="form-group">
          <label>Role</label>
          <select name="role" id="role" class="form-control" required>
            <option value="Admin">Admin</option>
            <option value="DoF">Finance</option>
            <option value="CMD">CMD</option>
            <option value="Staff">Staff</option>
          </select>
        </div>
        <div class="form-group">
          <label>Link to Employee (optional)</label>
          <select name="employee_id" id="employee_id" class="form-control">
            <option value="">-- None --</option>
            <?php foreach ($employees as $emp): ?>
              <option value="<?= $emp['id'] ?>">
                <?= htmlspecialchars($emp['full_name']) ?> (<?= $emp['employee_no'] ?>)
              </option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="form-group">
          <label>Password <?= isset($_POST['id']) && $_POST['id'] ? '(leave blank to keep current)' : '' ?></label>
          <input name="password" id="password" type="password" class="form-control" <?= isset($_POST['id']) && $_POST['id'] ? '' : 'required' ?>>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-success">Save</button>
        <button class="btn btn-secondary" data-dismiss="modal" type="button">Cancel</button>
      </div>
    </form>
  </div>
</div>

<script>
$(document).ready(function() {
    $('#userTable').DataTable();
});
function openAddUser() {
    $('#userModalTitle').text('Add User');
    $('#user_id').val('');
    $('#username').val('');
    $('#role').val('Staff');
    $('#employee_id').val('');
    $('#password').val('');
    $('#userModal').modal('show');
}
function openEditUser(u) {
    $('#userModalTitle').text('Edit User');
    $('#user_id').val(u.id);
    $('#username').val(u.username);
    $('#role').val(u.role);
    $('#employee_id').val(u.employee_id || '');
    $('#password').val('');
    $('#userModal').modal('show');
}
</script>

<?php include 'footer.php'; ?>