<?php
session_start();
require_once '../database/config.php'; 

// Handle Add/Edit Department
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['dept_name'])) {
    $dept_name = trim($_POST['dept_name']);
    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
    if ($id > 0) {
        // Edit
        $stmt = $pdo->prepare("UPDATE departments SET name=? WHERE id=?");
        $stmt->execute([$dept_name, $id]);
        $_SESSION['flash'] = "Department updated!";
    } else {
        // Add (no duplicate)
        try {
            $stmt = $pdo->prepare("INSERT INTO departments (name) VALUES (?)");
            $stmt->execute([$dept_name]);
            $_SESSION['flash'] = "Department added!";
        } catch (PDOException $e) {
            $_SESSION['flash'] = "Error: Department may already exist.";
        }
    }
    echo "<script>window.location='department_management.php';</script>";
    exit;
}

// Delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $pdo->prepare("DELETE FROM departments WHERE id=?")->execute([$id]);
    $_SESSION['flash'] = "Department deleted!";
    echo "<script>window.location='department_management.php';</script>";
    exit;
}

// Fetch all departments
$departments = $pdo->query("SELECT * FROM departments ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

include 'header.php';
?>

<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4>Manage Departments</h4>
        <button class="btn btn-primary" onclick="openDeptModal()">Add Department</button>
    </div>
    <?php if (!empty($_SESSION['flash'])): ?>
        <div class="alert alert-info"><?= $_SESSION['flash']; unset($_SESSION['flash']); ?></div>
    <?php endif; ?>

    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>S/N</th>
                <th>Department Name</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($departments as $i => $d): ?>
            <tr>
                <td><?= $i + 1 ?></td>
                <td><?= htmlspecialchars($d['name']) ?></td>
                <td>
                    <button class="btn btn-sm btn-warning" onclick='openDeptModal(<?= json_encode($d) ?>)'>Edit</button>
                    <a href="?delete=<?= $d['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this department?')">Delete</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Modal -->
<div class="modal fade" id="deptModal" tabindex="-1" aria-labelledby="deptModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="post" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="deptModalLabel">Add Department</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" name="id" id="dept_id">
        <div class="mb-3">
          <label>Department Name</label>
          <input type="text" name="dept_name" id="dept_name" class="form-control" required>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-success" type="submit">Save</button>
        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Cancel</button>
      </div>
    </form>
  </div>
</div>

<script>
function openDeptModal(dept = null) {
    if (dept) {
        $('#deptModalLabel').text('Edit Department');
        $('#dept_id').val(dept.id);
        $('#dept_name').val(dept.name);
    } else {
        $('#deptModalLabel').text('Add Department');
        $('#dept_id').val('');
        $('#dept_name').val('');
    }
    new bootstrap.Modal(document.getElementById('deptModal')).show();
}
</script>

<?php include 'footer.php'; ?>
