<?php
require_once '../database/config.php';
include 'header.php';

$role = $_SESSION['role'] ?? 'Employee';
$name = $_SESSION['full_name'] ?? $role;

// Fetch some sample summary counts for Admin
$totalEmployees = $pdo->query("SELECT COUNT(*) FROM employees")->fetchColumn();
$totalPayrolls  = $pdo->query("SELECT COUNT(*) FROM payrolls")->fetchColumn();
$totalBankReqs  = $pdo->query("SELECT COUNT(*) FROM bank_update_requests WHERE status='pending'")->fetchColumn();

// For Finance/CMD – pending payrolls
$pendingPayrolls = $pdo->query("SELECT COUNT(*) FROM payrolls WHERE status='pending'")->fetchColumn();

// For Employee: just a greeting
?>

<main class="main-wrapper clearfix">
    <div class="container py-4">
        <h3 class="mb-4">Welcome, <?= htmlspecialchars($name) ?></h3>

        <?php if ($role === 'Admin'): ?>
        <div class="row">
            <div class="col-md-4 mb-3">
                <div class="card shadow-sm border-left-primary">
                    <div class="card-body">
                        <h6>Total Employees</h6>
                        <div class="display-4"><?= $totalEmployees ?></div>
                        <a href="employee_list.php" class="btn btn-link btn-sm p-0">View Employees</a>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card shadow-sm border-left-success">
                    <div class="card-body">
                        <h6>Total Payrolls</h6>
                        <div class="display-4"><?= $totalPayrolls ?></div>
                        <a href="payroll_batches.php" class="btn btn-link btn-sm p-0">View Payrolls</a>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card shadow-sm border-left-warning">
                    <div class="card-body">
                        <h6>Pending Bank Updates</h6>
                        <div class="display-4"><?= $totalBankReqs ?></div>
                        <a href="bank_requests.php" class="btn btn-link btn-sm p-0">View Requests</a>
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <!-- Quick links -->
            <div class="col-md-12">
                <a href="manage_users.php" class="btn btn-primary m-1">Manage Users</a>
                <a href="allowances.php" class="btn btn-success m-1">Allowances</a>
                <a href="deductions.php" class="btn btn-warning m-1">Deductions</a>
                <a href="payroll_summary.php" class="btn btn-info m-1">Payroll Summary</a>
            </div>
        </div>
        <?php elseif ($role === 'DoF' || $role === 'CMD'): ?>
        <div class="row">
            <div class="col-md-6 mb-3">
                <div class="card shadow-sm border-left-primary">
                    <div class="card-body">
                        <h6>Pending Payrolls</h6>
                        <div class="display-4"><?= $pendingPayrolls ?></div>
                        <a href="payroll_approvals.php" class="btn btn-link btn-sm p-0">Approve Payrolls</a>
                    </div>
                </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="card shadow-sm border-left-success">
                    <div class="card-body">
                        <h6>Payroll Summary</h6>
                        <a href="payroll_summary.php" class="btn btn-info btn-block">View Summary</a>
                    </div>
                </div>
            </div>
        </div>
        <?php elseif ($role === 'Employee'): ?>
        <div class="row">
            <div class="col-md-6 mb-3">
                <div class="card shadow-sm border-left-success">
                    <div class="card-body">
                        <h6>View Your Payslips</h6>
                        <a href="essp_payslips.php" class="btn btn-success btn-block">My Payslips</a>
                    </div>
                </div>
            </div>
            <div class="col-md-6 mb-3">
                <div class="card shadow-sm border-left-info">
                    <div class="card-body">
                        <h6>My Earnings & Deductions</h6>
                        <a href="essp_earnings.php" class="btn btn-info btn-block">Earnings</a>
                        <a href="essp_deductions.php" class="btn btn-warning btn-block">Deductions</a>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</main>

<?php include 'footer.php'; ?>
