<?php
include 'header.php';
require_once '../database/config.php';

// Get logged-in user's details
$user_id = $_SESSION['user_id'] ?? 0;
$role = $_SESSION['role'] ?? 'Employee';

// Handle Add/Edit request (Employee)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_bank_update'])) {
    $employee_id = $user_id; // Employee can only update their own record
    $bank_name = trim($_POST['bank_name']);
    $account_number = trim($_POST['account_number']);

    // Only allow 1 pending request at a time
    $existing = $pdo->prepare("SELECT id FROM bank_update_requests WHERE employee_id=? AND status='pending'");
    $existing->execute([$employee_id]);
    if ($existing->fetchColumn()) {
        $_SESSION['flash'] = "You already have a pending request.";
    } else {
        $stmt = $pdo->prepare("INSERT INTO bank_update_requests (employee_id, bank_name, account_number, status) VALUES (?, ?, ?, 'pending')");
        $stmt->execute([$employee_id, $bank_name, $account_number]);
        $_SESSION['flash'] = "Bank update request submitted.";
    }
    echo "<script>window.location='bank_requests.php';</script>";
    exit;
}

// Handle Approve/Reject (Admin/Finance/CMD)
if (($role === 'Admin' || $role === 'Finance' || $role === 'CMD') && isset($_POST['action']) && isset($_POST['req_id'])) {
    $req_id = intval($_POST['req_id']);
    $action = $_POST['action'];
    $reason = trim($_POST['reason'] ?? '');

    if ($action === 'approve') {
        $stmt = $pdo->prepare("UPDATE bank_update_requests SET status='approved', approved_at=NOW(), approved_by=? WHERE id=?");
        $stmt->execute([$user_id, $req_id]);
        $_SESSION['flash'] = "Request approved.";
    log_audit($pdo, $_SESSION['user_id'], $_SESSION['flash']);
    } elseif ($action === 'reject') {
        $stmt = $pdo->prepare("UPDATE bank_update_requests SET status='rejected', reason=?, approved_at=NOW(), approved_by=? WHERE id=?");
        $stmt->execute([$reason, $user_id, $req_id]);
        $_SESSION['flash'] = "Request rejected.";
    log_audit($pdo, $_SESSION['user_id'], $_SESSION['flash']);
    }
    echo "<script>window.location='bank_requests.php';</script>";
    exit;
}

// Fetch requests for listing
$where = "1=1";
$params = [];
if ($role === 'Employee') {
    $where .= " AND r.employee_id = ?";
    $params[] = $user_id;
}
if (!empty($_GET['status'])) {
    $where .= " AND r.status = ?";
    $params[] = $_GET['status'];
}
if (!empty($_GET['department'])) {
    $where .= " AND e.department = ?";
    $params[] = $_GET['department'];
}

$departments = $pdo->query("SELECT DISTINCT department FROM employees WHERE department IS NOT NULL ORDER BY department")->fetchAll(PDO::FETCH_COLUMN);

$stmt = $pdo->prepare("SELECT r.*, e.full_name, e.employee_no, e.department FROM bank_update_requests r JOIN employees e ON r.employee_id = e.id WHERE $where ORDER BY r.submitted_at DESC");
$stmt->execute($params);
$requests = $stmt->fetchAll(PDO::FETCH_ASSOC);

// For employee's modal (only one open pending request)
$user_pending = null;
if ($role === 'Employee') {
    $user_pending = $pdo->prepare("SELECT * FROM bank_update_requests WHERE employee_id=? AND status='pending' ORDER BY submitted_at DESC LIMIT 1");
    $user_pending->execute([$user_id]);
    $user_pending = $user_pending->fetch(PDO::FETCH_ASSOC);
}
?>

<div class="container py-4">
    <?php if (!empty($_SESSION['flash'])): ?>
        <div class="alert alert-info alert-dismissible fade show"><?= $_SESSION['flash']; unset($_SESSION['flash']); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4>Bank Account Update Requests</h4>
        <?php if ($role === 'Employee'): ?>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#bankUpdateModal" <?= $user_pending ? 'disabled' : '' ?>>
                <?= $user_pending ? 'Pending Request Exists' : 'New Request' ?>
            </button>
        <?php endif; ?>
    </div>

    <!-- Filters -->
    <form class="row g-2 mb-3" method="get">
        <div class="col-md-3">
            <select name="department" class="form-select" onchange="this.form.submit()">
                <option value="">All Departments</option>
                <?php foreach ($departments as $d): ?>
                <option value="<?= htmlspecialchars($d) ?>" <?= (isset($_GET['department']) && $_GET['department'] === $d) ? 'selected' : '' ?>><?= htmlspecialchars($d) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3">
            <select name="status" class="form-select" onchange="this.form.submit()">
                <option value="">All Status</option>
                <option value="pending" <?= ($_GET['status'] ?? '') === 'pending' ? 'selected' : '' ?>>Pending</option>
                <option value="approved" <?= ($_GET['status'] ?? '') === 'approved' ? 'selected' : '' ?>>Approved</option>
                <option value="rejected" <?= ($_GET['status'] ?? '') === 'rejected' ? 'selected' : '' ?>>Rejected</option>
            </select>
        </div>
        <div class="col-auto">
            <button class="btn btn-outline-secondary" type="submit">Filter</button>
        </div>
    </form>

    <table id="bankTable" class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>S/N</th>
                <th>Employee</th>
                <th>Emp No</th>
                <th>Department</th>
                <th>Bank Name</th>
                <th>Account No</th>
                <th>Status</th>
                <th>Requested At</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($requests as $i => $r): ?>
            <tr>
                <td><?= $i+1 ?></td>
                <td><?= htmlspecialchars($r['full_name']) ?></td>
                <td><?= htmlspecialchars($r['employee_no']) ?></td>
                <td><?= htmlspecialchars($r['department']) ?></td>
                <td><?= htmlspecialchars($r['bank_name']) ?></td>
                <td><?= htmlspecialchars($r['account_number']) ?></td>
                <td>
                    <?php if ($r['status'] === 'pending'): ?>
                        <span class="badge bg-warning text-dark">Pending</span>
                    <?php elseif ($r['status'] === 'approved'): ?>
                        <span class="badge bg-success">Approved</span>
                    <?php else: ?>
                        <span class="badge bg-danger">Rejected</span>
                    <?php endif; ?>
                </td>
                <td><?= date('Y-m-d H:i', strtotime($r['submitted_at'])) ?></td>
                <td>
                    <?php if (($role === 'Admin' || $role === 'Finance' || $role === 'CMD') && $r['status'] === 'pending'): ?>
                        <!-- Approve/Reject buttons trigger modals -->
                        <button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#approveModal<?= $r['id'] ?>">Approve</button>
                        <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#rejectModal<?= $r['id'] ?>">Reject</button>
                    <?php elseif ($role === 'Employee' && $r['employee_id'] == $user_id && $r['status'] === 'pending'): ?>
                        <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#bankUpdateModal">Edit</button>
                    <?php else: ?>
                        <span>-</span>
                    <?php endif; ?>
                </td>
            </tr>

            <!-- Approve Modal -->
            <div class="modal fade" id="approveModal<?= $r['id'] ?>" tabindex="-1" aria-labelledby="approveModalLabel<?= $r['id'] ?>" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
    <form method="post" class="p3">
      <input type="hidden" name="req_id" value="<?= $r['id'] ?>">
      <input type="hidden" name="action" value="approve">
      <div class="modal-header">
        <h5 class="modal-title" id="approveModalLabel<?= $r['id'] ?>">Approve Request</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <p>Approve this bank update request for <strong><?= htmlspecialchars($r['full_name']) ?></strong>?</p>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-success">Approve</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
      </div>
    </form>
  </div>
  </div>
</div>


            <!-- Reject Modal -->
            <div class="modal fade" id="rejectModal<?= $r['id'] ?>" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
    <form method="post" class="p3">
                  <input type="hidden" name="req_id" value="<?= $r['id'] ?>">
                  <input type="hidden" name="action" value="reject">
                  <div class="modal-header"><h5 class="modal-title">Reject Request</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                  </div>
                  <div class="modal-body">
                    <div class="mb-3">
                      <label class="form-label">Reason for rejection (optional):</label>
                      <textarea name="reason" class="form-control" rows="2"></textarea>
                    </div>
                    <p>Reject this bank update request for <strong><?= htmlspecialchars($r['full_name']) ?></strong>?</p>
                  </div>
                  <div class="modal-footer">
                    <button type="submit" class="btn btn-danger">Reject</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                  </div>
                </form>
              </div>
              </div>
            </div>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Employee Modal: Add/Edit Request -->
<?php if ($role === 'Employee'): ?>
<div class="modal fade" id="bankUpdateModal" tabindex="-1">
  <div class="modal-dialog">
    <form method="post" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title"><?= $user_pending ? 'Edit Bank Update Request' : 'New Bank Update Request' ?></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" name="submit_bank_update" value="1">
        <div class="mb-3">
          <label>Bank Name</label>
          <input type="text" name="bank_name" class="form-control" required value="<?= htmlspecialchars($user_pending['bank_name'] ?? '') ?>">
        </div>
        <div class="mb-3">
          <label>Account Number</label>
          <input type="text" name="account_number" class="form-control" required value="<?= htmlspecialchars($user_pending['account_number'] ?? '') ?>">
        </div>
        <?php if ($user_pending): ?>
          <div class="mb-3"><small class="text-warning">You can only edit this request while it is pending.</small></div>
        <?php endif; ?>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-success"><?= $user_pending ? 'Update' : 'Submit' ?></button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
      </div>
    </form>
  </div>
</div>
<?php endif; ?>

<!-- DataTables -->
<script>
$(document).ready(function() {
    $('#bankTable').DataTable({responsive: true});
});
</script>

<?php include 'footer.php'; ?>
