<?php
require_once '../database/config.php';
include 'header.php';

// Fetch logs with user info
$stmt = $pdo->query("
    SELECT al.*, u.username 
    FROM audit_logs al 
    LEFT JOIN users u ON al.user_id = u.id 
    ORDER BY al.log_time DESC 
    LIMIT 200
");
$logs = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="container py-4">
    <h4 class="mb-3">Audit Logs</h4>
    <div class="table-responsive">
        <table class="table table-striped table-bordered" id="auditLogTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>User</th>
                    <th>Action</th>
                    <th>Date/Time</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($logs as $i => $row): ?>
                    <tr>
                        <td><?= $i+1 ?></td>
                        <td><?= htmlspecialchars($row['username'] ?? 'System') ?></td>
                        <td><?= htmlspecialchars($row['action']) ?></td>
                        <td><?= date('Y-m-d H:i:s', strtotime($row['log_time'])) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<script>
$(document).ready(function() {
    $('#auditLogTable').DataTable();
});
</script>
<?php include 'footer.php'; ?>
