<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>UNIOSUNTH PayNexus - Modern Payroll Solution</title>
    <!-- Tailwind CSS CDN for fast prototyping -->
    <script src="https://cdn.tailwindcss.com"></script>
    <meta name="description" content="Next-generation payroll solution for Osun State Government institutions with automated calculations, compliance management, and employee self-service." />
    <style>
      /* Smooth sections for static HTML (no JS) */
      html { scroll-behavior: smooth; }
      .section-title { @apply text-3xl md:text-4xl font-bold mb-4; }
    </style>
  </head>
  <body class="bg-white text-gray-900">
    <!-- HEADER -->
    <header class="bg-white py-4 sticky top-0 shadow-sm z-50">
      <div class="container mx-auto px-4 flex items-center justify-between">
        <!-- Logo -->
        <div class="flex items-center">
          <span class="text-2xl font-bold text-blue-700">UNIOSUNTH Pay<span class="text-blue-400">Nexus</span></span>
        </div>
        <!-- Desktop Navigation -->
        <nav class="hidden md:flex items-center space-x-8">
          <a href="#features" class="text-gray-700 hover:text-blue-600 transition duration-150">Features</a>
          <a href="#security" class="text-gray-700 hover:text-blue-600 transition duration-150">Security</a>
          <a href="#support" class="text-gray-700 hover:text-blue-600 transition duration-150">Support</a>
          <button class="border border-blue-400 text-blue-600 hover:bg-blue-50 rounded px-4 py-2 transition font-semibold">Login</button>
          <button class="bg-blue-600 hover:bg-blue-700 text-white rounded px-4 py-2 font-semibold transition">Get Started</button>
        </nav>
      </div>
    </header>

    <!-- HERO SECTION -->
    <section class="relative bg-gradient-to-r from-blue-900 via-blue-800 to-blue-700 text-white py-20">
      <div class="container mx-auto px-4 relative z-10">
        <div class="flex flex-col md:flex-row items-center">
          <div class="md:w-1/2 mb-10 md:mb-0">
            <h1 class="text-4xl md:text-5xl lg:text-6xl font-bold mb-6">
              Next-Gen Payroll Solution for UNIOSUNTH
            </h1>
            <p class="text-xl mb-8 text-gray-100 max-w-lg">
              Seamless payroll processing, compliance management, and employee self-service in one powerful platform.
            </p>
            <div class="flex flex-col sm:flex-row gap-4">
              <button class="bg-white text-blue-800 hover:bg-gray-100 rounded px-6 py-3 font-semibold text-lg">Get Started</button>
              <!-- <button class="border border-white text-white hover:bg-white/10 rounded px-6 py-3 text-lg font-semibold">Learn More</button> -->
            </div>
          </div>
          <div class="md:w-1/2">
            <div class="bg-white/10 backdrop-blur-sm p-6 rounded-lg shadow-2xl border border-white/20">
              <div class="grid grid-cols-2 gap-4 mb-4">
                <div class="bg-white/20 p-4 rounded">
                  <div class="font-bold text-3xl">99.9%</div>
                  <div class="text-sm">Uptime</div>
                </div>
                <div class="bg-white/20 p-4 rounded">
                  <div class="font-bold text-3xl">100%</div>
                  <div class="text-sm">Compliance</div>
                </div>
                <div class="bg-white/20 p-4 rounded">
                  <div class="font-bold text-3xl">5min</div>
                  <div class="text-sm">Processing</div>
                </div>
                <div class="bg-white/20 p-4 rounded">
                  <div class="font-bold text-3xl">24/7</div>
                  <div class="text-sm">Support</div>
                </div>
              </div>
              <div class="text-center text-sm font-medium">
                Powered by UNIOSUNTH
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- FEATURE SECTION -->
    <section id="features" class="py-20 bg-gray-50">
      <div class="container mx-auto px-4">
        <div class="text-center mb-16">
          <h2 class="text-3xl md:text-4xl font-bold mb-4">Comprehensive Payroll Management</h2>
          <p class="text-xl text-gray-600 max-w-3xl mx-auto">
            UNIOSUNTH PayNexus delivers end-to-end payroll processing with advanced features designed for government institutions.
          </p>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
          <!-- Repeat for each feature -->
          <div class="bg-white rounded-lg p-6 shadow-md border border-gray-100 hover:shadow-lg transition-shadow duration-300">
            <div class="text-blue-600 mb-4"><span>🧮</span></div>
            <h3 class="text-lg font-semibold mb-2">Automated Payroll Calculation</h3>
            <p class="text-gray-600">Accurate computation of salaries with working hours, leave days, and statutory deductions.</p>
          </div>
          <div class="bg-white rounded-lg p-6 shadow-md border border-gray-100 hover:shadow-lg transition-shadow duration-300">
            <div class="text-blue-600 mb-4"><span>💼</span></div>
            <h3 class="text-lg font-semibold mb-2">Multi-Tier Processing</h3>
            <p class="text-gray-600">Support for full-time, contract staff, interns, and ad-hoc workers.</p>
          </div>
          <div class="bg-white rounded-lg p-6 shadow-md border border-gray-100 hover:shadow-lg transition-shadow duration-300">
            <div class="text-blue-600 mb-4"><span>💸</span></div>
            <h3 class="text-lg font-semibold mb-2">Advanced Deductions</h3>
            <p class="text-gray-600">Automated PAYE, pension, NHIS, loans, union dues & more.</p>
          </div>
          <div class="bg-white rounded-lg p-6 shadow-md border border-gray-100 hover:shadow-lg transition-shadow duration-300">
            <div class="text-blue-600 mb-4"><span>🪙</span></div>
            <h3 class="text-lg font-semibold mb-2">Allowance & Bonus Processing</h3>
            <p class="text-gray-600">Handle hazard pay, shift, overtime, and customizable bonuses.</p>
          </div>
          <div class="bg-white rounded-lg p-6 shadow-md border border-gray-100 hover:shadow-lg transition-shadow duration-300">
            <div class="text-blue-600 mb-4"><span>🧑‍💼</span></div>
            <h3 class="text-lg font-semibold mb-2">Employee Self-Service Portal</h3>
            <p class="text-gray-600">Secure access to payslips, digital requests, and tax records.</p>
          </div>
          <div class="bg-white rounded-lg p-6 shadow-md border border-gray-100 hover:shadow-lg transition-shadow duration-300">
            <div class="text-blue-600 mb-4"><span>📊</span></div>
            <h3 class="text-lg font-semibold mb-2">Compliance & Reporting</h3>
            <p class="text-gray-600">Auto statutory reports and audit logs for transparency.</p>
          </div>
          <div class="bg-white rounded-lg p-6 shadow-md border border-gray-100 hover:shadow-lg transition-shadow duration-300">
            <div class="text-blue-600 mb-4"><span>🛡️</span></div>
            <h3 class="text-lg font-semibold mb-2">Enterprise Security</h3>
            <p class="text-gray-600">Data encryption and MFA to protect sensitive data.</p>
          </div>
          <div class="bg-white rounded-lg p-6 shadow-md border border-gray-100 hover:shadow-lg transition-shadow duration-300">
            <div class="text-blue-600 mb-4"><span>📈</span></div>
            <h3 class="text-lg font-semibold mb-2">Budget Forecasting</h3>
            <p class="text-gray-600">Predictive analytics for efficient salary budget planning.</p>
          </div>
          <div class="bg-white rounded-lg p-6 shadow-md border border-gray-100 hover:shadow-lg transition-shadow duration-300">
            <div class="text-blue-600 mb-4"><span>⏱️</span></div>
            <h3 class="text-lg font-semibold mb-2">99.99% Uptime</h3>
            <p class="text-gray-600">Reliable cloud infrastructure for continuous payroll service.</p>
          </div>
        </div>
      </div>
    </section>

    <!-- COMPLIANCE SECTION -->
    <section class="py-20 bg-white">
      <div class="container mx-auto px-4">
        <div class="md:flex items-center">
          <!-- Report Card -->
          <div class="md:w-1/2 mb-10 md:mb-0">
            <div class="relative bg-blue-100 p-1 rounded-lg shadow-xl">
              <div class="bg-white rounded-lg p-6">
                <div class="mb-4 text-blue-700 font-semibold">STATUTORY COMPLIANCE REPORT</div>
                <div class="space-y-3">
                  <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">PAYE Tax Remittance</span>
                    <span class="text-green-600 font-semibold">COMPLETE</span>
                  </div>
                  <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">Pension Contributions</span>
                    <span class="text-green-600 font-semibold">COMPLETE</span>
                  </div>
                  <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">NHIS Deductions</span>
                    <span class="text-green-600 font-semibold">COMPLETE</span>
                  </div>
                  <div class="flex justify-between border-b pb-2">
                    <span class="text-gray-600">Union Dues</span>
                    <span class="text-green-600 font-semibold">COMPLETE</span>
                  </div>
                  <div class="flex justify-between">
                    <span class="text-gray-600">Cooperative Contributions</span>
                    <span class="text-green-600 font-semibold">COMPLETE</span>
                  </div>
                </div>
                <div class="mt-4 text-sm text-gray-500">Generated: April 2025 • Compliant with FIRS & OIRS regulations</div>
              </div>
            </div>
          </div>
          <!-- Compliance Content -->
          <div class="md:w-1/2 md:pl-12">
            <h2 class="text-3xl font-bold mb-6">Advanced Deductions & Compliance Management</h2>
            <p class="text-gray-600 mb-8">
              The system computes and remits all deductions, ensuring compliance with regulations while saving admin time.
            </p>
            <ul class="space-y-4 mb-8">
              <li class="flex items-start">
                <span class="text-blue-600 mr-3 mt-1">✔️</span>
                <div>
                  <h3 class="font-semibold">PAYE Tax Compliance</h3>
                  <p class="text-gray-600 text-sm">Automated in line with FIRS and OIRS.</p>
                </div>
              </li>
              <li class="flex items-start">
                <span class="text-blue-600 mr-3 mt-1">✔️</span>
                <div>
                  <h3 class="font-semibold">Pension & Health Insurance</h3>
                  <p class="text-gray-600 text-sm">Automated remittance to pension funds and NHIS/OHIS.</p>
                </div>
              </li>
              <li class="flex items-start">
                <span class="text-blue-600 mr-3 mt-1">✔️</span>
                <div>
                  <h3 class="font-semibold">Custom Deductions</h3>
                  <p class="text-gray-600 text-sm">Configure cooperative dues, loans & union contributions.</p>
                </div>
              </li>
              <li class="flex items-start">
                <span class="text-blue-600 mr-3 mt-1">✔️</span>
                <div>
                  <h3 class="font-semibold">Retirement Benefits</h3>
                  <p class="text-gray-600 text-sm">Smooth gratuity and benefits calculation.</p>
                </div>
              </li>
            </ul>
            <button class="bg-blue-600 hover:bg-blue-700 text-white rounded px-6 py-3 font-semibold">
              Learn About Compliance
            </button>
          </div>
        </div>
      </div>
    </section>

    <!-- SELF SERVICE SECTION -->
    <section class="py-20 bg-gray-50">
      <div class="container mx-auto px-4">
        <div class="md:flex items-center">
          <div class="md:w-1/2 md:pr-12 mb-10 md:mb-0">
            <h2 class="text-3xl font-bold mb-6">Employee Self-Service Portal</h2>
            <p class="text-gray-600 mb-8">
              Empower employees with a secure, easy-to-use portal for payroll insight and streamlined admin.
            </p>
            <ul class="space-y-6">
              <li class="flex">
                <span class="bg-blue-100 p-2 rounded-lg text-blue-700 mr-4">📄</span>
                <div>
                  <h3 class="font-semibold text-lg mb-1">Digital Payslips</h3>
                  <p class="text-gray-600">View current and historical payslips with downloadable PDFs.</p>
                </div>
              </li>
              <li class="flex">
                <span class="bg-blue-100 p-2 rounded-lg text-blue-700 mr-4">📈</span>
                <div>
                  <h3 class="font-semibold text-lg mb-1">Tax & Pension Dashboard</h3>
                  <p class="text-gray-600">Visual breakdowns with monthly and annual views.</p>
                </div>
              </li>
              <li class="flex">
                <span class="bg-blue-100 p-2 rounded-lg text-blue-700 mr-4">📅</span>
                <div>
                  <h3 class="font-semibold text-lg mb-1">Leave & Overtime Mgt</h3>
                  <p class="text-gray-600">Request and track leave, overtime, approvals through workflows.</p>
                </div>
              </li>
              <li class="flex">
                <span class="bg-blue-100 p-2 rounded-lg text-blue-700 mr-4">👤</span>
                <div>
                  <h3 class="font-semibold text-lg mb-1">Profile Management</h3>
                  <p class="text-gray-600">Update personal info and manage notifications easily.</p>
                </div>
              </li>
            </ul>
            <div class="mt-8">
              <button class="bg-blue-600 hover:bg-blue-700 text-white rounded px-6 py-3 font-semibold">See Portal Demo</button>
            </div>
          </div>
          <div class="md:w-1/2">
            <div class="bg-white rounded-lg shadow-xl overflow-hidden border border-gray-200">
              <!-- Portal Header -->
              <div class="bg-blue-700 p-4 text-white">
                <div class="flex items-center justify-between">
                  <div class="flex items-center">
                    <div class="h-8 w-8 bg-white rounded-full text-blue-700 flex items-center justify-center font-bold mr-3">E</div>
                    <div>
                      <div class="font-medium">Employee Portal</div>
                      <div class="text-xs text-blue-200">Logged in as John Doe</div>
                    </div>
                  </div>
                  <div class="text-xs text-blue-200">Last login: Today, 10:45 AM</div>
                </div>
              </div>
              <!-- Portal Navigation -->
              <div class="bg-gray-50 py-2 px-4 border-b border-gray-200">
                <div class="flex space-x-4">
                  <div class="px-3 py-1 bg-white rounded text-sm font-medium text-blue-700 shadow-sm">Dashboard</div>
                  <div class="px-3 py-1 text-sm font-medium text-gray-600">Payslips</div>
                  <div class="px-3 py-1 text-sm font-medium text-gray-600">Leave</div>
                  <div class="px-3 py-1 text-sm font-medium text-gray-600">Benefits</div>
                </div>
              </div>
              <!-- Portal Content -->
              <div class="p-6">
                <div class="mb-6">
                  <h3 class="text-lg font-semibold mb-4">Salary Overview</h3>
                  <div class="bg-gray-50 rounded-lg p-4 border border-gray-100">
                    <div class="grid grid-cols-2 gap-4">
                      <div>
                        <div class="text-sm text-gray-500">Gross Salary</div>
                        <div class="font-semibold">₦350,000.00</div>
                      </div>
                      <div>
                        <div class="text-sm text-gray-500">Net Salary</div>
                        <div class="font-semibold">₦295,750.00</div>
                      </div>
                      <div>
                        <div class="text-sm text-gray-500">Total Deductions</div>
                        <div class="font-semibold">₦54,250.00</div>
                      </div>
                      <div>
                        <div class="text-sm text-gray-500">Payment Date</div>
                        <div class="font-semibold">25th April, 2025</div>
                      </div>
                    </div>
                  </div>
                </div>
                <div>
                  <h3 class="text-lg font-semibold mb-4">Recent Payslips</h3>
                  <div class="space-y-3">
                    <div class="flex items-center justify-between bg-white p-3 rounded border border-gray-200">
                      <div>
                        <div class="font-medium">April 2025</div>
                        <div class="text-sm text-gray-500">Processed: 20/04/2025</div>
                      </div>
                      <button class="border border-blue-300 text-blue-700 hover:bg-blue-50 rounded px-4 py-1 text-sm">View</button>
                    </div>
                    <div class="flex items-center justify-between bg-white p-3 rounded border border-gray-200">
                      <div>
                        <div class="font-medium">March 2025</div>
                        <div class="text-sm text-gray-500">Processed: 20/03/2025</div>
                      </div>
                      <button class="border border-blue-300 text-blue-700 hover:bg-blue-50 rounded px-4 py-1 text-sm">View</button>
                    </div>
                    <div class="flex items-center justify-between bg-white p-3 rounded border border-gray-200">
                      <div>
                        <div class="font-medium">February 2025</div>
                        <div class="text-sm text-gray-500">Processed: 20/02/2025</div>
                      </div>
                      <button class="border border-blue-300 text-blue-700 hover:bg-blue-50 rounded px-4 py-1 text-sm">View</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- SECURITY SECTION -->
    <section id="security" class="py-20 bg-gradient-to-br from-blue-900 via-blue-800 to-blue-700 text-white">
      <div class="container mx-auto px-4">
        <div class="text-center mb-16">
          <h2 class="text-3xl md:text-4xl font-bold mb-4">Enterprise-Grade Security & Infrastructure</h2>
          <p class="text-xl text-gray-100 max-w-3xl mx-auto">
            Built on cloud-based dedicated servers with advanced security measures to protect your sensitive payroll data.
          </p>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-10">
          <div class="bg-white/10 backdrop-blur-sm p-8 rounded-lg border border-white/20">
            <div class="flex items-center mb-6">
              <div class="p-3 bg-white/20 rounded-full mr-4">
                <span>🖥️</span>
              </div>
              <h3 class="text-xl font-semibold">Cloud-Based Infrastructure</h3>
            </div>
            <ul class="space-y-4">
              <li class="flex"><span class="text-blue-300 mr-3 mt-1">✔️</span> <span>99.99% Uptime & Performance Optimization</span></li>
              <li class="flex"><span class="text-blue-300 mr-3 mt-1">✔️</span> <span>Disaster Recovery & Auto-Backup Systems</span></li>
              <li class="flex"><span class="text-blue-300 mr-3 mt-1">✔️</span> <span>Integration with Government Systems</span></li>
              <li class="flex"><span class="text-blue-300 mr-3 mt-1">✔️</span> <span>Scalable Architecture for Institutions</span></li>
            </ul>
          </div>
          <div class="bg-white/10 backdrop-blur-sm p-8 rounded-lg border border-white/20">
            <div class="flex items-center mb-6">
              <div class="p-3 bg-white/20 rounded-full mr-4">
                <span>🛡️</span>
              </div>
              <h3 class="text-xl font-semibold">Advanced Security Features</h3>
            </div>
            <ul class="space-y-4">
              <li class="flex"><span class="text-blue-300 mr-3 mt-1">✔️</span> <span>End-to-End Data Encryption</span></li>
              <li class="flex"><span class="text-blue-300 mr-3 mt-1">✔️</span> <span>Multi-Factor Authentication (MFA)</span></li>
              <li class="flex"><span class="text-blue-300 mr-3 mt-1">✔️</span> <span>Audit Logs & Fraud Prevention</span></li>
              <li class="flex"><span class="text-blue-300 mr-3 mt-1">✔️</span> <span>Role-Based Access Controls</span></li>
            </ul>
          </div>
        </div>
        <div class="mt-16 bg-white/10 backdrop-blur-sm p-6 rounded-lg border border-white/20">
          <div class="grid grid-cols-1 md:grid-cols-4 gap-6 text-center">
            <div class="p-4">
              <span class="text-3xl mb-2 block">⏰</span>
              <h4 class="font-semibold text-lg">24/7 Monitoring</h4>
              <p class="text-gray-200 text-sm">Continuous oversight by MIS team</p>
            </div>
            <div class="p-4">
              <span class="text-3xl mb-2 block">🔑</span>
              <h4 class="font-semibold text-lg">Zero Trust Security</h4>
              <p class="text-gray-200 text-sm">Verify-always model for data access</p>
            </div>
            <div class="p-4">
              <span class="text-3xl mb-2 block">💾</span>
              <h4 class="font-semibold text-lg">Daily Backups</h4>
              <p class="text-gray-200 text-sm">Automated system for data protection</p>
            </div>
            <div class="p-4">
              <span class="text-3xl mb-2 block">🛡️</span>
              <h4 class="font-semibold text-lg">Compliance Certified</h4>
              <p class="text-gray-200 text-sm">Meets all data protection regulations</p>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- SUPPORT SECTION -->
    <section id="support" class="py-20 bg-white">
      <div class="container mx-auto px-4">
        <div class="text-center mb-16">
          <h2 class="text-3xl md:text-4xl font-bold mb-4">Dedicated MIS Team Support</h2>
          <p class="text-xl text-gray-600 max-w-3xl mx-auto">
            The Management Information System (MIS) team provides continuous support and system maintenance for uninterrupted payroll operations.
          </p>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 mb-16">
          <div class="bg-gray-50 p-6 rounded-lg border border-gray-100 text-center">
            <span class="text-3xl text-blue-600 mx-auto mb-4 block">🖥️</span>
            <h3 class="text-lg font-semibold mb-2">System Monitoring</h3>
            <p class="text-gray-600">Continuous performance and uptime monitoring for service.</p>
          </div>
          <div class="bg-gray-50 p-6 rounded-lg border border-gray-100 text-center">
            <span class="text-3xl text-blue-600 mx-auto mb-4 block">💾</span>
            <h3 class="text-lg font-semibold mb-2">Data Security</h3>
            <p class="text-gray-600">Encryption, backup management, and intrusion prevention.</p>
          </div>
          <div class="bg-gray-50 p-6 rounded-lg border border-gray-100 text-center">
            <span class="text-3xl text-blue-600 mx-auto mb-4 block">⚙️</span>
            <h3 class="text-lg font-semibold mb-2">System Updates</h3>
            <p class="text-gray-600">Regular updates for compliance and security standards.</p>
          </div>
          <div class="bg-gray-50 p-6 rounded-lg border border-gray-100 text-center">
            <span class="text-3xl text-blue-600 mx-auto mb-4 block">🎧</span>
            <h3 class="text-lg font-semibold mb-2">Technical Support</h3>
            <p class="text-gray-600">Responsive assistance for users of the system.</p>
          </div>
        </div>
        <div class="bg-blue-50 rounded-lg p-8 border border-blue-100">
          <div class="md:flex items-center">
            <div class="md:w-2/3 mb-6 md:mb-0">
              <h3 class="text-2xl font-bold mb-2">Ready to Modernize Your Payroll System?</h3>
              <p class="text-gray-600">
                Get started with UNIOSUNTH PayNexus for streamlined payroll processing, enhanced compliance, and superior employee experience.
              </p>
            </div>
            <div class="md:w-1/3 md:text-right">
              <button class="bg-blue-600 hover:bg-blue-700 text-white rounded px-8 py-4 font-semibold text-lg">
                Request Implementation
              </button>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- FOOTER -->
    <footer class="bg-gray-900 text-white py-16">
      <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-8 mb-12">
          <div>
            <div class="text-2xl font-bold mb-4">OsunPay<span class="text-blue-400">Nexus</span></div>
            <p class="text-gray-400 mb-4">
              Next-generation payroll solution for Osun State Government institutions, delivering accuracy, compliance, and efficiency.
            </p>
            <div class="flex space-x-4">
              <a href="#" class="text-gray-400 hover:text-white">🌐</a>
              <a href="#" class="text-gray-400 hover:text-white">🐦</a>
              <a href="#" class="text-gray-400 hover:text-white">📸</a>
            </div>
          </div>
          <div>
            <h3 class="font-semibold text-lg mb-4">Features</h3>
            <ul class="space-y-2">
              <li><a href="#" class="text-gray-400 hover:text-white">Payroll Processing</a></li>
              <li><a href="#" class="text-gray-400 hover:text-white">Deductions Management</a></li>
              <li><a href="#" class="text-gray-400 hover:text-white">Compliance Reporting</a></li>
              <li><a href="#" class="text-gray-400 hover:text-white">Employee Self-Service</a></li>
              <li><a href="#" class="text-gray-400 hover:text-white">Budget Forecasting</a></li>
            </ul>
          </div>
          <div>
            <h3 class="font-semibold text-lg mb-4">Resources</h3>
            <ul class="space-y-2">
              <li><a href="#" class="text-gray-400 hover:text-white">Support Center</a></li>
            </ul>
          </div>
          <div>
            <h3 class="font-semibold text-lg mb-4">Contact</h3>
            <ul class="space-y-2">
              <li class="flex items-center text-gray-400">
                <span class="mr-2">✉️</span> support@uth-osogbo.org.ng
              </li>
              <li class="flex items-center text-gray-400">
                <span class="mr-2">📞</span> +234 800 123 4567
              </li>
              <li class="flex items-center text-gray-400">
                <span class="mr-2">📍</span> UniOsun Teaching Hospital, Osogbo, Osun State.
              </li>
            </ul>
            <div class="mt-6">
              <button class="border border-white text-white bg-transparent hover:bg-white/10 rounded px-4 py-2">Contact Support</button>
            </div>
          </div>
        </div>
        <div class="pt-8 border-t border-gray-800 text-sm text-gray-400">
          <div class="flex flex-col md:flex-row justify-between items-center">
            <div class="mb-4 md:mb-0">
              &copy; 2025 UNIOSUNTH PayNexus. All rights reserved.
            </div>
            <div class="flex space-x-6">
              <a href="#" class="hover:text-white">Privacy Policy</a>
              <a href="#" class="hover:text-white">Terms of Service</a>
              <a href="#" class="hover:text-white">Security</a>
            </div>
          </div>
        </div>
      </div>
    </footer>
  </body>
</html>
