<?php
session_start();
require_once '../database/config.php';

if (!isset($_SESSION['employee_id'])) {
    header("Location: login.php");
    exit;
}

$employee_id = $_SESSION['employee_id'];

// Fetch employee info
$stmt = $pdo->prepare("SELECT full_name, email, phone, password FROM employees WHERE id = ?");
$stmt->execute([$employee_id]);
$employee = $stmt->fetch(PDO::FETCH_ASSOC);

$success = $error = "";

// Handle update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $phone = trim($_POST['phone']);
    $email = trim($_POST['email']);
    $old_pass = $_POST['old_password'];
    $new_pass = $_POST['new_password'];
    $confirm_pass = $_POST['confirm_password'];

    // Update phone and (email if allowed)
    if ($employee['email'] == '' && filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $pdo->prepare("UPDATE employees SET phone = ?, email = ? WHERE id = ?")->execute([$phone, $email, $employee_id]);
        $success = "Profile and email updated.";
    } else {
        $pdo->prepare("UPDATE employees SET phone = ? WHERE id = ?")->execute([$phone, $employee_id]);
        $success = "Phone number updated.";
    }

    // Password update
    if (!empty($old_pass) && !empty($new_pass) && !empty($confirm_pass)) {
        if (!password_verify($old_pass, $employee['password'])) {
            $error = "Old password is incorrect.";
        } elseif ($new_pass !== $confirm_pass) {
            $error = "New passwords do not match.";
        } elseif (strlen($new_pass) < 6) {
            $error = "Password must be at least 6 characters.";
        } else {
            $hashed = password_hash($new_pass, PASSWORD_DEFAULT);
            $pdo->prepare("UPDATE employees SET password = ? WHERE id = ?")->execute([$hashed, $employee_id]);
            $success .= " Password updated.";
        }
    }
    // Refresh employee info
    $stmt->execute([$employee_id]);
    $employee = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Update Profile - UNIOSUNTH ESSP</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #e0e5ec;
      font-family: 'Segoe UI', sans-serif;
      padding-bottom: 70px;
    }
    .neumorphic-box {
      background: #e0e5ec;
      border-radius: 16px;
      box-shadow: 8px 8px 16px #babecc, -8px -8px 16px #ffffff;
      padding: 25px;
      margin-bottom: 20px;
    }
    .neumorphic-input {
      background: #e0e5ec;
      border: none;
      border-radius: 10px;
      box-shadow: inset 4px 4px 8px #c2cbd6, inset -4px -4px 8px #ffffff;
      padding: 10px 12px;
      width: 100%;
      margin-bottom: 15px;
    }
    .neumorphic-input:focus {
      outline: none;
      box-shadow: inset 2px 2px 6px #c2cbd6, inset -2px -2px 6px #ffffff;
    }
    .btn-neu {
      background: #e0e5ec;
      border: none;
      border-radius: 12px;
      box-shadow: 6px 6px 12px #babecc, -6px -6px 12px #ffffff;
      padding: 10px 20px;
      font-weight: bold;
      color: #5a4225;
    }
    .btn-neu:hover {
      box-shadow: inset 4px 4px 8px #babecc, inset -4px -4px 8px #ffffff;
    }
  </style>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      background: #e0e5ec;
      font-family: 'Segoe UI', sans-serif;
      padding-bottom: 70px;
    }
    .neumorphic {
      background: #e0e5ec;
      border-radius: 20px;
      box-shadow: 8px 8px 16px #a3b1c6, -8px -8px 16px #ffffff;
      padding: 20px;
    }
    .neumorphic-btn {
      background: #e0e5ec;
      border: none;
      border-radius: 12px;
      box-shadow: 6px 6px 12px #babecc, -6px -6px 12px #ffffff;
      transition: all 0.3s ease;
      padding: 12px;
      text-align: center;
      font-weight: bold;
      color: #4a3e29;
      cursor: pointer;
      width: 100%;
      display: block;
    }
    .neumorphic-btn:hover {
      box-shadow: inset 4px 4px 8px #babecc, inset -4px -4px 8px #ffffff;
    }
    .bottom-nav {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background: #e0e5ec;
      border-top: 1px solid #ccc;
      display: flex;
      justify-content: space-around;
      padding: 6px 0;
      z-index: 1000;
    }
    .bottom-nav a {
      flex: 1;
      text-align: center;
      font-size: 12px;
      color: #5a4225;
      text-decoration: none;
    }
    .bottom-nav a.active {
      font-weight: bold;
      color: #7b4e0d;
    }
    .bottom-nav i {
      font-size: 18px;
      display: block;
    }
    .logo {
      height: 60px;
    }
  </style>
</head>
<body>

<div class="container py-4">
  <h4 class="text-center fw-bold mb-4" style="color: #7b4e0d;">Update Profile</h4>

  <?php if ($success): ?>
    <div class="alert alert-success"><?= $success ?></div>
  <?php endif; ?>
  <?php if ($error): ?>
    <div class="alert alert-danger"><?= $error ?></div>
  <?php endif; ?>

  <div class="neumorphic-box">
    <form method="post">
      <label>Full Name</label>
      <input type="text" class="neumorphic-input" value="<?= htmlspecialchars($_SESSION['employee_name']) ?>" disabled>

      <label>Email (if not yet set)</label>
      <input type="email" name="email" class="neumorphic-input" value="<?= htmlspecialchars($employee['email']) ?>" <?= $employee['email'] ? 'readonly' : '' ?>>

      <label>Phone Number</label>
      <input type="text" name="phone" class="neumorphic-input" value="<?= htmlspecialchars($employee['phone']) ?>" required>

      <hr>

      <h6>Change Password</h6>
      <input type="password" name="old_password" class="neumorphic-input" placeholder="Old Password">
      <input type="password" name="new_password" class="neumorphic-input" placeholder="New Password">
      <input type="password" name="confirm_password" class="neumorphic-input" placeholder="Confirm New Password">

      <div class="text-end">
        <button type="submit" class="btn btn-neu">Update Profile</button>
      </div>
    </form>
  </div>
</div>

<?php include 'footer.php'; ?>
</body>
</html>
