<?php
session_start();
require_once '../database/config.php';

if (!isset($_SESSION['employee_id'])) {
    header("Location: login.php");
    exit;
}

$employee_id = $_SESSION['employee_id'];
$category = $_GET['category'] ?? 'earnings';
$type = $_GET['type'] ?? '';
$months = $_GET['months'] ?? [];

$table = $category === 'deductions' ? 'deductions' : 'allowances';
$dateField = $category === 'deductions' ? 'deduction_date' : 'allowance_date';

// Fetch types
$stmt = $pdo->prepare("SELECT DISTINCT type FROM $table WHERE employee_id = ?");
$stmt->execute([$employee_id]);
$types = $stmt->fetchAll(PDO::FETCH_COLUMN);

// Process records
$data = [];
$total = 0;

if ($type) {
    $sql = "SELECT type, amount, $dateField AS entry_date, description 
            FROM $table 
            WHERE employee_id = ? AND type = ?";
    $params = [$employee_id, $type];

    if (!empty($months)) {
        $placeholders = implode(',', array_fill(0, count($months), '?'));
        $sql .= " AND MONTH($dateField) IN ($placeholders)";
        $params = array_merge($params, $months);
    }

    $sql .= " ORDER BY entry_date DESC";
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    foreach ($data as $row) {
        $total += $row['amount'];
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Reports - UNIOSUNTH ESSP</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #e0e5ec;
      font-family: 'Segoe UI', sans-serif;
      padding-bottom: 70px;
    }
    .neumorphic-box {
      background: #e0e5ec;
      border-radius: 16px;
      box-shadow: 8px 8px 16px #babecc, -8px -8px 16px #ffffff;
      padding: 25px;
      margin-bottom: 25px;
    }
    .neumorphic-select {
      background: #e0e5ec;
      border: none;
      border-radius: 10px;
      box-shadow: inset 4px 4px 8px #c2cbd6, inset -4px -4px 8px #ffffff;
      padding: 8px 12px;
      width: 100%;
      margin-bottom: 12px;
    }
    .neumorphic-select:focus {
      outline: none;
      box-shadow: inset 2px 2px 6px #c2cbd6, inset -2px -2px 6px #ffffff;
    }
    .btn-neu {
      background: #e0e5ec;
      border: none;
      border-radius: 12px;
      box-shadow: 6px 6px 12px #babecc, -6px -6px 12px #ffffff;
      padding: 10px 20px;
      font-weight: bold;
      color: #5a4225;
    }
    .btn-neu:hover {
      box-shadow: inset 4px 4px 8px #babecc, inset -4px -4px 8px #ffffff;
    }
    .summary-box {
      background: #fffbe6;
      border-left: 5px solid #7b4e0d;
      padding: 15px;
      border-radius: 10px;
      font-size: 16px;
    }
    .table th, .table td {
      font-size: 13px;
    }
  </style>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      background: #e0e5ec;
      font-family: 'Segoe UI', sans-serif;
      padding-bottom: 70px;
    }
    .neumorphic {
      background: #e0e5ec;
      border-radius: 20px;
      box-shadow: 8px 8px 16px #a3b1c6, -8px -8px 16px #ffffff;
      padding: 20px;
    }
    .neumorphic-btn {
      background: #e0e5ec;
      border: none;
      border-radius: 12px;
      box-shadow: 6px 6px 12px #babecc, -6px -6px 12px #ffffff;
      transition: all 0.3s ease;
      padding: 12px;
      text-align: center;
      font-weight: bold;
      color: #4a3e29;
      cursor: pointer;
      width: 100%;
      display: block;
    }
    .neumorphic-btn:hover {
      box-shadow: inset 4px 4px 8px #babecc, inset -4px -4px 8px #ffffff;
    }
    .bottom-nav {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background: #e0e5ec;
      border-top: 1px solid #ccc;
      display: flex;
      justify-content: space-around;
      padding: 6px 0;
      z-index: 1000;
    }
    .bottom-nav a {
      flex: 1;
      text-align: center;
      font-size: 12px;
      color: #5a4225;
      text-decoration: none;
    }
    .bottom-nav a.active {
      font-weight: bold;
      color: #7b4e0d;
    }
    .bottom-nav i {
      font-size: 18px;
      display: block;
    }
    .logo {
      height: 60px;
    }
  </style>
</head>
<body>

<div class="container py-4">
  <h4 class="text-center mb-3 fw-bold text-uppercase" style="color: #7b4e0d;">Reports</h4>

  <div class="neumorphic-box">
    <form method="GET">
      <div class="row g-3">
        <div class="col-md-4">
          <label class="form-label">Category</label>
          <select name="category" class="neumorphic-select" onchange="this.form.submit()">
            <option value="earnings" <?= $category === 'earnings' ? 'selected' : '' ?>>Earnings</option>
            <option value="deductions" <?= $category === 'deductions' ? 'selected' : '' ?>>Deductions</option>
          </select>
        </div>

        <div class="col-md-4">
          <label class="form-label">Type</label>
          <select name="type" class="neumorphic-select" required>
            <option value="">-- Choose Type --</option>
            <?php foreach ($types as $t): ?>
              <option value="<?= htmlspecialchars($t) ?>" <?= $type === $t ? 'selected' : '' ?>><?= htmlspecialchars($t) ?></option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="col-md-4">
          <label class="form-label">Select Month(s)</label>
          <select name="months[]" class="neumorphic-select" multiple size="4">
            <?php for ($m = 1; $m <= 12; $m++): ?>
              <option value="<?= $m ?>" <?= in_array((string)$m, $months) ? 'selected' : '' ?>>
                <?= date('F', mktime(0, 0, 0, $m, 10)) ?>
              </option>
            <?php endfor; ?>
          </select>
        </div>
      </div>

      <div class="text-end">
        <button type="submit" class="btn btn-neu mt-2">Generate</button>
      </div>
    </form>
  </div>

  <?php if ($type && $data): ?>
    <div class="table-responsive mb-3">
      <table class="table table-bordered table-sm">
        <thead class="table-light">
          <tr>
            <th>Date</th>
            <th>Type</th>
            <th>Amount (₦)</th>
            <th>Description</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($data as $r): ?>
            <tr>
              <td><?= date('d M Y', strtotime($r['entry_date'])) ?></td>
              <td><?= htmlspecialchars($r['type']) ?></td>
              <td><?= number_format($r['amount'], 2) ?></td>
              <td><?= $r['description'] ? htmlspecialchars($r['description']) : '-' ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>

    <div class="summary-box">
      <strong>Total <?= ucfirst($category) ?>:</strong> ₦<?= number_format($total, 2) ?>
    </div>
  <?php elseif ($type): ?>
    <div class="alert alert-warning text-center">No records found for selected type/months.</div>
  <?php endif; ?>
</div>

<?php include 'footer.php'; ?>

</body>
</html>
