<?php
session_start();
require_once '../database/config.php';

if (!isset($_SESSION['employee_id'])) {
    header("Location: login.php");
    exit;
}

$employee_id = $_SESSION['employee_id'];
$stmt = $pdo->prepare("
    SELECT pr.id AS payroll_id, pr.payroll_month, pr.status, d.gross_pay, d.net_pay
    FROM payrolls pr
    JOIN payroll_details d ON pr.id = d.payroll_id
    WHERE d.employee_id = ?
    ORDER BY pr.payroll_month DESC
");
$stmt->execute([$employee_id]);
$payslips = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Payslips - UNIOSUNTH ESSP</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      background: #e0e5ec;
      font-family: 'Segoe UI', sans-serif;
      padding-bottom: 70px;
    }
    .neumorphic-card {
      background: #e0e5ec;
      border-radius: 16px;
      box-shadow: 6px 6px 12px #babecc, -6px -6px 12px #ffffff;
      padding: 18px;
      margin-bottom: 15px;
    }
    .header-title {
      text-align: center;
      font-weight: bold;
      color: #7b4e0d;
      margin-bottom: 30px;
    }
    .badge-month {
      font-size: 13px;
      font-weight: 600;
      background-color: #7b4e0d;
      color: white;
      border-radius: 10px;
      padding: 4px 12px;
    }
    .neumorphic-btn {
      background: #e0e5ec;
      border: none;
      border-radius: 12px;
      box-shadow: 4px 4px 8px #babecc, -4px -4px 8px #ffffff;
      transition: all 0.2s ease-in-out;
      padding: 10px 16px;
      font-size: 14px;
      font-weight: 500;
      color: #5a4225;
      text-decoration: none;
    }
    .neumorphic-btn:hover {
      box-shadow: inset 3px 3px 6px #babecc, inset -3px -3px 6px #ffffff;
    }
  </style>
  <style>
    body {
      background: #e0e5ec;
      font-family: 'Segoe UI', sans-serif;
      padding-bottom: 70px;
    }
    .neumorphic {
      background: #e0e5ec;
      border-radius: 20px;
      box-shadow: 8px 8px 16px #a3b1c6, -8px -8px 16px #ffffff;
      padding: 20px;
    }
    .neumorphic-btn {
      background: #e0e5ec;
      border: none;
      border-radius: 12px;
      box-shadow: 6px 6px 12px #babecc, -6px -6px 12px #ffffff;
      transition: all 0.3s ease;
      padding: 12px;
      text-align: center;
      font-weight: bold;
      color: #4a3e29;
      cursor: pointer;
      width: 100%;
      display: block;
    }
    .neumorphic-btn:hover {
      box-shadow: inset 4px 4px 8px #babecc, inset -4px -4px 8px #ffffff;
    }
    .bottom-nav {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background: #e0e5ec;
      border-top: 1px solid #ccc;
      display: flex;
      justify-content: space-around;
      padding: 6px 0;
      z-index: 1000;
    }
    .bottom-nav a {
      flex: 1;
      text-align: center;
      font-size: 12px;
      color: #5a4225;
      text-decoration: none;
    }
    .bottom-nav a.active {
      font-weight: bold;
      color: #7b4e0d;
    }
    .bottom-nav i {
      font-size: 18px;
      display: block;
    }
    .logo {
      height: 60px;
    }
  </style>
</head>
<body>
<div class="container py-4">
  <h4 class="header-title">My Payslips</h4>

  <?php if (count($payslips) === 0): ?>
    <div class="alert alert-warning text-center">No payslip records found.</div>
  <?php else: ?>
    <?php foreach ($payslips as $row): ?>
      <?php
        $month = date('F Y', strtotime($row['payroll_month']));
        $gross = number_format($row['gross_pay'], 2);
        $net = number_format($row['net_pay'], 2);
        $status = $row['status'];
        // Status display logic
        switch ($status) {
          case 'pending':
            $status_label = '<span class="badge-status badge-pending">Pending</span>';
            $can_view = false;
            break;
          case 'approved_by_dof':
            $status_label = '<span class="badge-status badge-approved-dof">Approved by DoF</span>';
            $can_view = false;
            break;
          case 'approved_by_cmd':
            $status_label = '<span class="badge-status badge-approved-cmd">Approved by CMD</span>';
            $can_view = true;
            break;
          case 'rejected':
            $status_label = '<span class="badge-status badge-rejected">Rejected</span>';
            $can_view = false;
            break;
          default:
            $status_label = '<span class="badge-status badge-pending">Unknown</span>';
            $can_view = false;
        }
      ?>
      <div class="neumorphic-card d-flex justify-content-between align-items-center flex-wrap">
        <div class="me-3">
          <div><span class="badge-month"><?= $month ?></span></div>
          <div><strong>Gross Pay:</strong> ₦<?= $gross ?></div>
          <div><strong>Net Pay:</strong> ₦<?= $net ?></div>
          <div><?= $status_label ?></div>
        </div>
        <div class="text-end">
          <?php if ($can_view): ?>
            <a href="payslip.php?payroll_id=<?= $row['payroll_id'] ?>&employee_id=<?= $employee_id ?>" target="_blank" class="neumorphic-btn mt-2">View / Download</a>
          <?php else: ?>
            <button class="neumorphic-btn mt-2" disabled>Not yet available</button>
          <?php endif; ?>
        </div>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</div>
<?php include 'footer.php'; ?>
</body>
</html>
