<?php
require_once '../database/config.php';
session_start();

if (!isset($_GET['payroll_id'], $_GET['employee_id'])) {
    die("Invalid request. Payroll ID and Employee ID required.");
}

$payroll_id = intval($_GET['payroll_id']);
$employee_id = intval($_GET['employee_id']);

// Fetch payroll and detail
$stmt = $pdo->prepare("
    SELECT pr.*, d.*, e.full_name, e.employee_no, e.chams_no, e.department, e.c_level, e.c_step, e.job_title, e.scheme
    FROM payrolls pr
    JOIN payroll_details d ON d.payroll_id = pr.id
    JOIN employees e ON d.employee_id = e.id
    WHERE pr.id = ? AND d.employee_id = ?
");
$stmt->execute([$payroll_id, $employee_id]);
$payroll = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$payroll) die("Payroll not found for this employee.");

// Fetch individual allowances
$allowances = $pdo->prepare("SELECT type, amount FROM allowances WHERE employee_id = ? AND (recurring = 1 OR (MONTH(allowance_date) = MONTH(?) AND YEAR(allowance_date) = YEAR(?)))");
$allowances->execute([$employee_id, $payroll['payroll_month'], $payroll['payroll_month']]);
$allowList = $allowances->fetchAll(PDO::FETCH_ASSOC);

// Fetch individual deductions
$deductions = $pdo->prepare("SELECT type, amount FROM deductions WHERE employee_id = ? AND (recurring = 1 OR (MONTH(deduction_date) = MONTH(?) AND YEAR(deduction_date) = YEAR(?)))");
$deductions->execute([$employee_id, $payroll['payroll_month'], $payroll['payroll_month']]);
$deductList = $deductions->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Payslip - <?= htmlspecialchars($payroll['full_name']) ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
  body {
    font-family: Arial, sans-serif;
    font-size: 13px;
    background: #fff;
    margin: 0;
    padding: 0;
  }

  .container {
    max-width: 794px; /* A4 width in pixels at 96 DPI */
    margin: auto;
    padding: 8px;
    box-sizing: border-box;
  }

  table {
    width: 100%;
    border-collapse: collapse;
  }

  th, td {
    padding: 4px 6px;
    font-size: 13px;
  }

@media print {
  html, body {
    width: 210mm;
    height: 297mm;
    margin: 0 !important;
    padding: 0 !important;
    overflow: hidden;
  }

  .no-print,
  .btn,
  .btn-close {
    display: none !important;
  }

  .container {
    width: 100%;
    padding: 10mm;
    margin: 0;
  }

  .row {
    display: flex;
    flex-wrap: nowrap !important;
  }

  .col-md-6 {
    width: 50% !important;
    padding: 0 5px;
    box-sizing: border-box;
  }

  .table th {
    background: #f0f0f0 !important;
  }
}


  .signature-line {
    height: 40px;
    border-bottom: 1px solid #000;
    margin-bottom: 5px;
  }

  .logo {
    max-height: 60px;
  }

  .table th {
    background-color: #f8f9fa;
  }
  @page {
    size: A4 portrait;
    margin: 0;
  }
</style>

</head>
<body>
<div class="container py-4">

  <div class="no-print text-end mb-3">
    <button onclick="window.print()" class="btn btn-secondary">Print Payslip</button>
  </div>

  <div class="text-center mb-4">
    <img src="../img/uth-logo.png" class="logo mb-2" alt="Logo">
    <h4 class="mb-1 text-uppercase fw-bold">UNIOSUN TEACHING HOSPITAL</h4>
    <h6 class="text-uppercase">Monthly Payslip for <?= date('F Y', strtotime($payroll['payroll_month'])) ?></h6>
    <hr>
  </div>

  <div class="row mb-3">
    <div class="col-md-6">
      <p><strong>Employee Name:</strong> <?= htmlspecialchars($payroll['full_name']) ?></p>
      <p><strong>Employee ID/Staff Number:</strong> <?= htmlspecialchars($payroll['employee_no']) ?>/<?= htmlspecialchars($payroll['chams_no']) ?></p>
      <p><strong>Designation:</strong> <?= htmlspecialchars($payroll['job_title']) ?></p>
    </div>
    <div class="col-md-6">
      <p><strong>Department/Unit:</strong> <?= htmlspecialchars($payroll['department']) ?></p>
      <p><strong>Level/Step:</strong> <?= htmlspecialchars($payroll['scheme']) ?> <?= htmlspecialchars($payroll['c_level']) ?> - <?= htmlspecialchars($payroll['c_step']) ?></p>
      <p><strong>Generated:</strong> <?= date('d M Y H:i') ?></p>
    </div>
  </div>

<?php
$allowanceBreakdown = json_decode($payroll['allowance_breakdown'], true) ?? [];
$deductionBreakdown = json_decode($payroll['deduction_breakdown'], true) ?? [];
?>

  <div class="row">
    <div class="col-md-6">
      <h6 class="text-decoration-underline">Earnings</h6>
      <table class="table table-bordered small">
        <thead class="table-light"><tr><th>Description</th><th class="text-end">Amount (₦)</th></tr></thead>
        <tbody>
          <tr>
            <td>Basic Salary</td>
            <td class="text-end"><?= number_format($payroll['base_salary'], 2) ?></td>
          </tr>
        <?php foreach ($allowanceBreakdown as $type => $amt): ?>
          <tr>
            <td ><?= htmlspecialchars($type) ?></td>
            <td class="text-end"><?= number_format($amt, 2) ?></td>
          </tr>
        <?php endforeach; ?>
          
        </tbody>
      </table>
    </div>

    <div class="col-md-6">
      <h6 class="text-decoration-underline">Deductions</h6>
      <table class="table table-bordered small">
        <thead><tr><th>Deduction Type</th><th>Amount (₦)</th></tr></thead>
          <tbody>
            <?php foreach ($deductionBreakdown as $type => $amt): ?>
              <tr>
                <td><?= htmlspecialchars($type) ?></td>
                <td><?= number_format($amt, 2) ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
      </table>
    </div>
  </div>

  <div class="row mt-3">
    <div class="col-md-6 offset-md-6">
      <table class="table table-bordered">
        <tbody>
          <tr>
            <th>Gross Pay</th>
            <td class="text-end"><?= number_format($payroll['gross_pay'], 2) ?></td>
          </tr>
          <tr>
            <th>Total Deductions</th>
            <td class="text-end"><?= number_format($payroll['total_deduction'], 2) ?></td>
          </tr>
          <tr class="table-success fw-bold">
            <th>Net Pay</th>
            <td class="text-end"><?= number_format($payroll['net_pay'], 2) ?></td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>

  <div class="mt-5 row">
    <div class="col-md-6 text-center">
      <div class="signature-line"></div>
      <p>Salary Unit</p>
    </div>
    <div class="col-md-6 text-center">
      <div class="signature-line"></div>
      <p>Director of Finance</p>
    </div>
  </div>

  <div class="text-muted mt-4 small">
    <p><strong>Note:</strong> This is a system-generated payslip. For official use only.</p>
  </div>

</div>
</body>
</html>
