<?php
session_start();
require_once '../database/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $employee_code = trim($_POST['employee_code']);
    $password = $_POST['password'];

    // Fetch the user row by employee_no
    $stmt = $pdo->prepare("SELECT * FROM employees WHERE employee_no = ?");
    $stmt->execute([$employee_code]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['password'])) {
        // Password correct, set session
        $_SESSION['employee_id'] = $user['id'];
        $_SESSION['employee_name'] = $user['full_name'];
        $_SESSION['employee_no'] = $user['employee_no'];
        header("Location: dashboard.php");
        exit;
    } else {
        $_SESSION['error'] = "Invalid employee code or password.";
        header("Location: login.php");
        exit;
    }
}
