<?php
session_start();
if (isset($_SESSION['employee_id'])) {
    header("Location: dashboard.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Login - UNIOSUNTH Payroll Portal</title>
  
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #e0e5ec;
      font-family: 'Segoe UI', sans-serif;
      height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
    }

    .neumorphic-box {
      background: #e0e5ec;
      border-radius: 20px;
      box-shadow: 8px 8px 15px #a3b1c6,
                  -8px -8px 15px #ffffff;
      padding: 30px 25px;
      width: 100%;
      max-width: 400px;
    }

    .neumorphic-input {
      background: #e0e5ec;
      border: none;
      border-radius: 10px;
      box-shadow: inset 4px 4px 8px #c2cbd6,
                  inset -4px -4px 8px #ffffff;
    }

    .neumorphic-input:focus {
      box-shadow: inset 2px 2px 6px #c2cbd6,
                  inset -2px -2px 6px #ffffff;
      outline: none;
    }

    .neumorphic-btn {
      background: #e0e5ec;
      border: none;
      border-radius: 12px;
      box-shadow: 6px 6px 12px #babecc,
                  -6px -6px 12px #ffffff;
      transition: 0.3s ease-in-out;
    }

    .neumorphic-btn:hover {
      box-shadow: inset 4px 4px 8px #babecc,
                  inset -4px -4px 8px #ffffff;
    }

    .form-title {
      text-align: center;
      font-weight: bold;
      margin-bottom: 25px;
      color: #333;
    }
  </style>
</head>
<body>

<div class="neumorphic-box">
  <h4 class="form-title">UNIOSUNTH Payroll Portal</h4>

  <?php if (isset($_SESSION['error'])): ?>
    <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
  <?php endif; ?>
 <action="login_process.php">
  <form method="post">
    <div class="mb-3">
      <label class="form-label">Employee Code</label>
      <input type="text" name="employee_code" class="form-control neumorphic-input" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Password</label>
      <input type="password" name="password" class="form-control neumorphic-input" required>
    </div>

    <div class="d-grid">
      <button type="submit" class="btn neumorphic-btn">Login</button>
    </div>

    <div class="text-center mt-3">
      <a href="#" class="text-decoration-none text-muted">Forgot Password?</a>
    </div>
  </form>
</div>

</body>
</html>
