<?php
session_start();
require_once '../database/config.php';

if (!isset($_SESSION['employee_id'])) {
    header("Location: login.php");
    exit;
}

$employee_id = $_SESSION['employee_id'];

// Fetch all payrolls with deduction breakdown for this employee
$stmt = $pdo->prepare("
    SELECT pr.payroll_month, pd.deduction_breakdown
    FROM payroll_details pd
    JOIN payrolls pr ON pr.id = pd.payroll_id
    WHERE pd.employee_id = ?
    ORDER BY pr.payroll_month DESC
");
$stmt->execute([$employee_id]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Flatten deduction breakdowns to a single list
$deductions_flat = [];
foreach ($rows as $row) {
    $month = date('F Y', strtotime($row['payroll_month']));
    $deduction_breakdown = json_decode($row['deduction_breakdown'], true) ?: [];
    foreach ($deduction_breakdown as $type => $amount) {
        $deductions_flat[] = [
            'month' => $month,
            'type' => $type,
            'amount' => $amount
        ];
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Deductions - UNIOSUNTH ESSP</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #e0e5ec;
      font-family: 'Segoe UI', sans-serif;
      padding-bottom: 70px;
    }
    .neumorphic-card {
      background: #e0e5ec;
      border-radius: 16px;
      box-shadow: 6px 6px 12px #babecc, -6px -6px 12px #ffffff;
      padding: 18px;
      margin-bottom: 15px;
    }
    .title {
      text-align: center;
      color: #7b4e0d;
      margin-bottom: 30px;
      font-weight: bold;
    }
    .deduction-row {
      display: flex;
      justify-content: space-between;
      align-items: center;
      border-bottom: 1px dashed #ccc;
      padding: 6px 0;
      flex-wrap: wrap;
    }
    .amount {
      font-weight: bold;
      color: #c0392b;
    }
    .label-small {
      font-size: 12px;
      color: #999;
    }
  </style>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      background: #e0e5ec;
      font-family: 'Segoe UI', sans-serif;
      padding-bottom: 70px;
    }
    .neumorphic {
      background: #e0e5ec;
      border-radius: 20px;
      box-shadow: 8px 8px 16px #a3b1c6, -8px -8px 16px #ffffff;
      padding: 20px;
    }
    .neumorphic-btn {
      background: #e0e5ec;
      border: none;
      border-radius: 12px;
      box-shadow: 6px 6px 12px #babecc, -6px -6px 12px #ffffff;
      transition: all 0.3s ease;
      padding: 12px;
      text-align: center;
      font-weight: bold;
      color: #4a3e29;
      cursor: pointer;
      width: 100%;
      display: block;
    }
    .neumorphic-btn:hover {
      box-shadow: inset 4px 4px 8px #babecc, inset -4px -4px 8px #ffffff;
    }
    .bottom-nav {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background: #e0e5ec;
      border-top: 1px solid #ccc;
      display: flex;
      justify-content: space-around;
      padding: 6px 0;
      z-index: 1000;
    }
    .bottom-nav a {
      flex: 1;
      text-align: center;
      font-size: 12px;
      color: #5a4225;
      text-decoration: none;
    }
    .bottom-nav a.active {
      font-weight: bold;
      color: #7b4e0d;
    }
    .bottom-nav i {
      font-size: 18px;
      display: block;
    }
    .logo {
      height: 60px;
    }
  </style>
</head>
<body>

<div class="container py-4">
  <h4 class="mb-4 text-center">My Deductions</h4>
  <?php if (empty($deductions_flat)): ?>
    <div class="alert alert-warning text-center">No deduction records found.</div>
  <?php else: ?>
    <div class="neumorphic-card">
      <div class="table-responsive">
        <table id="deductionTable" class="table table-bordered table-striped deduction-table">
          <thead>
            <tr>
              <th>Month</th>
              <th>Deduction Type</th>
              <th>Amount (₦)</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($deductions_flat as $row): ?>
            <tr>
              <td><?= htmlspecialchars($row['month']) ?></td>
              <td><?= htmlspecialchars($row['type']) ?></td>
              <td><?= number_format($row['amount'], 2) ?></td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  <?php endif; ?>
</div>

<!-- DataTables & Bootstrap JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script>
$(document).ready(function(){
  $('#deductionTable').DataTable({
    paging: true,
    pageLength: 10,
    searching: true,
    lengthChange: true,
    info: true,
    order: [[0, 'desc']],
    language: {
      emptyTable: "No deductions found.",
      paginate: { previous: "<", next: ">" }
    }
  });
});
</script>

<?php include 'footer.php'; ?>

</body>
</html>
