<?php
session_start();
require_once '../database/config.php';

if (!isset($_SESSION['employee_id'])) {
    header("Location: login.php");
    exit;
}

$employee_id = $_SESSION['employee_id'];
$stmt = $pdo->prepare("SELECT * FROM employees WHERE id = ?");
$stmt->execute([$employee_id]);
$employee = $stmt->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Dashboard - UNIOSUNTH ESSP</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      background: #e0e5ec;
      font-family: 'Segoe UI', sans-serif;
      padding-bottom: 70px;
    }
    .neumorphic {
      background: #e0e5ec;
      border-radius: 20px;
      box-shadow: 8px 8px 16px #a3b1c6, -8px -8px 16px #ffffff;
      padding: 20px;
    }
    .neumorphic-btn {
      background: #e0e5ec;
      border: none;
      border-radius: 12px;
      box-shadow: 6px 6px 12px #babecc, -6px -6px 12px #ffffff;
      transition: all 0.3s ease;
      padding: 12px;
      text-align: center;
      font-weight: bold;
      color: #4a3e29;
      cursor: pointer;
      width: 100%;
      display: block;
    }
    .neumorphic-btn:hover {
      box-shadow: inset 4px 4px 8px #babecc, inset -4px -4px 8px #ffffff;
    }
    .bottom-nav {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background: #e0e5ec;
      border-top: 1px solid #ccc;
      display: flex;
      justify-content: space-around;
      padding: 6px 0;
      z-index: 1000;
    }
    .bottom-nav a {
      flex: 1;
      text-align: center;
      font-size: 12px;
      color: #5a4225;
      text-decoration: none;
    }
    .bottom-nav a.active {
      font-weight: bold;
      color: #7b4e0d;
    }
    .bottom-nav i {
      font-size: 18px;
      display: block;
    }
    .logo {
      height: 60px;
    }
  </style>
</head>
<body>

<div class="container py-4">
  <div class="text-center mb-4">
    <img src="../img/uth-logo.png" class="logo" alt="UTH Logo"><br>
    <h5 class="text-uppercase mt-2 fw-bold" style="color: #7b4e0d;">UNIOSUN Teaching Hospital</h5>
    <div class="text-muted">Employee Self-Service Portal</div>
  </div>

  <div class="bg-white rounded p-3 mb-4">
    <h6 class="text-muted">Welcome,</h6>
    <h5><?= htmlspecialchars($employee['full_name']) ?></h5>
    <p class="mb-1"><strong>Employee ID/STAFF No.:</strong> <?= $employee['employee_no'] ?>/<?= $employee['chams_no'] ?></p>
    <p class="mb-1"><strong>Department:</strong> <?= $employee['department'] ?></p>
    <p class="mb-1"><strong>GL:</strong> <?= $employee['c_level'] ?> | <strong>STEP:</strong> <?= $employee['c_step'] ?></p>
    <p class="mb-0"><strong>Scheme:</strong> <?= $employee['scheme'] ?> </p>
    <p class="mb-0"><strong>Next Payment Date:</strong> <?= date('30 F Y') ?></p>
  </div>

  <div class="row g-3">
    <div class="col-6">
      <a href="payslips.php" class="neumorphic-btn">Payslips</a>
    </div>
    <div class="col-6">
      <a href="earnings.php" class="neumorphic-btn">Earnings</a>
    </div>
    <div class="col-6">
      <a href="deductions.php" class="neumorphic-btn">Deductions</a>
    </div>
    <div class="col-6">
      <a href="reports.php" class="neumorphic-btn">Reports</a>
    </div>
    <div class="col-6">
      <a href="bank.php" class="neumorphic-btn">Salary Account</a>
    </div>
    <div class="col-6">
      <a href="update_profile.php" class="neumorphic-btn">Update Profile</a>
    </div>
  </div>
</div>

<?php include 'footer.php'?>