<?php
session_start();
require_once '../database/config.php';

if (!isset($_SESSION['employee_id'])) {
    header("Location: login.php");
    exit;
}

$employee_id = $_SESSION['employee_id'];

// Fetch employee record
$stmt = $pdo->prepare("SELECT bank_name, account_number FROM employees WHERE id = ?");
$stmt->execute([$employee_id]);
$employee = $stmt->fetch(PDO::FETCH_ASSOC);

// Check for last update request
$stmt = $pdo->prepare("SELECT * FROM bank_update_requests WHERE employee_id = ? ORDER BY submitted_at DESC LIMIT 1");
$stmt->execute([$employee_id]);
$lastRequest = $stmt->fetch(PDO::FETCH_ASSOC);

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $newBank = trim($_POST['bank_name']);
    $newAccount = trim($_POST['account_number']);

    if (!$newBank || !$newAccount) {
        $error = "Please fill all fields.";
    } elseif ($lastRequest && $lastRequest['status'] === 'pending') {
        $error = "You already have a pending request.";
    } else {
        $stmt = $pdo->prepare("INSERT INTO bank_update_requests (employee_id, bank_name, account_number, status, submitted_at) VALUES (?, ?, ?, 'pending', NOW())");
        $stmt->execute([$employee_id, $newBank, $newAccount]);
        $success = "Your bank update request has been submitted and is pending approval.";
        // Refresh
        header("Location: bank_update.php");
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Update Bank Details - UNIOSUNTH ESSP</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #e0e5ec;
      font-family: 'Segoe UI', sans-serif;
      padding-bottom: 70px;
    }
    .neumorphic-box {
      background: #e0e5ec;
      border-radius: 16px;
      box-shadow: 8px 8px 16px #babecc, -8px -8px 16px #ffffff;
      padding: 25px;
      margin-bottom: 20px;
    }
    .neumorphic-input {
      background: #e0e5ec;
      border: none;
      border-radius: 10px;
      box-shadow: inset 4px 4px 8px #c2cbd6, inset -4px -4px 8px #ffffff;
      padding: 8px 12px;
      width: 100%;
      margin-bottom: 15px;
    }
    .neumorphic-input:focus {
      outline: none;
      box-shadow: inset 2px 2px 6px #c2cbd6, inset -2px -2px 6px #ffffff;
    }
    .btn-neu {
      background: #e0e5ec;
      border: none;
      border-radius: 12px;
      box-shadow: 6px 6px 12px #babecc, -6px -6px 12px #ffffff;
      padding: 10px 20px;
      font-weight: bold;
      color: #5a4225;
    }
    .btn-neu:hover {
      box-shadow: inset 4px 4px 8px #babecc, inset -4px -4px 8px #ffffff;
    }
    .summary-box {
      background: #fffbe6;
      border-left: 5px solid #7b4e0d;
      padding: 15px;
      border-radius: 10px;
      font-size: 14px;
    }
    .text-muted small {
      font-size: 12px;
    }
  </style>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      background: #e0e5ec;
      font-family: 'Segoe UI', sans-serif;
      padding-bottom: 70px;
    }
    .neumorphic {
      background: #e0e5ec;
      border-radius: 20px;
      box-shadow: 8px 8px 16px #a3b1c6, -8px -8px 16px #ffffff;
      padding: 20px;
    }
    .neumorphic-btn {
      background: #e0e5ec;
      border: none;
      border-radius: 12px;
      box-shadow: 6px 6px 12px #babecc, -6px -6px 12px #ffffff;
      transition: all 0.3s ease;
      padding: 12px;
      text-align: center;
      font-weight: bold;
      color: #4a3e29;
      cursor: pointer;
      width: 100%;
      display: block;
    }
    .neumorphic-btn:hover {
      box-shadow: inset 4px 4px 8px #babecc, inset -4px -4px 8px #ffffff;
    }
    .bottom-nav {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background: #e0e5ec;
      border-top: 1px solid #ccc;
      display: flex;
      justify-content: space-around;
      padding: 6px 0;
      z-index: 1000;
    }
    .bottom-nav a {
      flex: 1;
      text-align: center;
      font-size: 12px;
      color: #5a4225;
      text-decoration: none;
    }
    .bottom-nav a.active {
      font-weight: bold;
      color: #7b4e0d;
    }
    .bottom-nav i {
      font-size: 18px;
      display: block;
    }
    .logo {
      height: 60px;
    }
  </style>
</head>
<body>

<div class="container py-4">
  <h4 class="text-center fw-bold mb-4" style="color: #7b4e0d;">Bank Details</h4>

  <?php if (!empty($success)): ?>
    <div class="alert alert-success"><?= $success ?></div>
  <?php elseif (!empty($error)): ?>
    <div class="alert alert-danger"><?= $error ?></div>
  <?php endif; ?>

  <div class="neumorphic-box">
    <h6>Current Bank Details</h6>
    <p><strong>Bank Name:</strong> <?= $employee['bank_name'] ?: 'Not set' ?></p>
    <p><strong>Account Number:</strong> <?= $employee['account_number'] ?: 'Not set' ?></p>
  </div>

  <?php if ($lastRequest): ?>
    <div class="summary-box mb-4">
      <strong>Last Request:</strong><br>
      Bank: <?= htmlspecialchars($lastRequest['bank_name']) ?><br>
      Account: <?= htmlspecialchars($lastRequest['account_number']) ?><br>
      Status: 
        <span class="badge bg-<?= $lastRequest['status'] === 'approved' ? 'success' : ($lastRequest['status'] === 'pending' ? 'warning text-dark' : 'danger') ?>">
          <?= ucfirst($lastRequest['status']) ?>
        </span><br>
      <?php if (!empty($lastRequest['reason'])): ?>
        <em>Reason: <?= htmlspecialchars($lastRequest['reason']) ?></em>
      <?php endif; ?>
    </div>
  <?php endif; ?>

  <?php if (!$lastRequest || $lastRequest['status'] !== 'pending'): ?>
    <div class="neumorphic-box">
      <form method="post">
        <label class="form-label">New Bank Name</label>
        <input type="text" name="bank_name" class="neumorphic-input" required>

        <label class="form-label">New Account Number</label>
        <input type="text" name="account_number" class="neumorphic-input" required>

        <div class="text-end">
          <button type="submit" class="btn btn-neu">Submit Request</button>
        </div>
      </form>
    </div>
  <?php else: ?>
    <div class="alert alert-info">You already have a pending bank update request. You can submit again after it's approved or rejected.</div>
  <?php endif; ?>
</div>

<?php include 'footer.php'; ?>

</body>
</html>
